/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.graph.inst;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pcgen.base.graph.base.NonDirectionalEdge;

public class DefaultHyperEdge<N>
implements NonDirectionalEdge<N> {
    private final List<N> nodes;

    public DefaultHyperEdge(Collection<N> nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException("GraphNode List of DefaultHyperEdge cannot be null");
        }
        this.nodes = new ArrayList<N>(nodes.size());
        this.nodes.addAll(nodes);
        if (this.nodes.isEmpty()) {
            throw new IllegalArgumentException("GraphNode List of DefaultHyperEdge cannot be empty");
        }
        for (N node : this.nodes) {
            if (node != null) continue;
            throw new IllegalArgumentException("Node List contains null");
        }
    }

    @Override
    public N getNodeAt(int index) {
        return this.nodes.get(index);
    }

    @Override
    public List<N> getAdjacentNodes() {
        return new ArrayList<N>(this.nodes);
    }

    @Override
    public boolean isAdjacentNode(N node) {
        return this.nodes.contains(node);
    }

    @Override
    public int getAdjacentNodeCount() {
        return this.nodes.size();
    }

    @Override
    public DefaultHyperEdge<N> createReplacementEdge(Collection<N> newNodes) {
        return new DefaultHyperEdge<N>(newNodes);
    }
}

