/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.format;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import pcgen.base.util.FormatManager;
import pcgen.base.util.Indirect;
import pcgen.base.util.ObjectContainer;

public class ArrayFormatManager<T>
implements FormatManager<T[]> {
    private final char separator;
    private final FormatManager<T> componentManager;
    private final transient Class<T[]> formatClass;

    public ArrayFormatManager(FormatManager<T> underlying, char separator) {
        if (underlying == null) {
            throw new IllegalArgumentException("Cannot build from null FormatManager");
        }
        Class<?> fClass = Array.newInstance(underlying.getManagedClass(), 0).getClass();
        this.separator = separator;
        this.formatClass = fClass;
        this.componentManager = underlying;
    }

    @Override
    public T[] convert(String instructions) {
        Class<T> componentClass = this.componentManager.getManagedClass();
        if (instructions == null || instructions.isEmpty()) {
            Object[] toSet = (Object[])Array.newInstance(componentClass, 0);
            return toSet;
        }
        String[] items = instructions.split(Character.toString(this.separator));
        Object[] toSet = (Object[])Array.newInstance(componentClass, items.length);
        for (int i = 0; i < items.length; ++i) {
            T obj = this.componentManager.convert(items[i]);
            toSet[i] = obj;
        }
        return toSet;
    }

    @Override
    public Indirect<T[]> convertIndirect(String instructions) {
        return this.convertInstructions(instructions);
    }

    @Override
    public ObjectContainer<T[]> convertObjectContainer(String instructions) {
        return this.convertInstructions(instructions);
    }

    private ArrayObjectContainer convertInstructions(String instructions) {
        if (instructions == null || instructions.isEmpty()) {
            ObjectContainer[] toSet = (ObjectContainer[])Array.newInstance(ObjectContainer.class, 0);
            return new ArrayObjectContainer(toSet);
        }
        String[] items = instructions.split(Character.toString(this.separator));
        ObjectContainer[] toSet = (ObjectContainer[])Array.newInstance(ObjectContainer.class, items.length);
        for (int i = 0; i < items.length; ++i) {
            ObjectContainer<T> indirect;
            toSet[i] = indirect = this.componentManager.convertObjectContainer(items[i]);
        }
        return new ArrayObjectContainer(toSet);
    }

    @Override
    public FormatManager<?> getComponentManager() {
        return this.componentManager;
    }

    @Override
    public String getIdentifierType() {
        return "ARRAY[" + this.componentManager.getIdentifierType() + "]";
    }

    @Override
    public Class<T[]> getManagedClass() {
        return this.formatClass;
    }

    @Override
    public String unconvert(T[] array) {
        StringBuilder result = new StringBuilder();
        boolean needjoin = false;
        for (T obj : array) {
            if (needjoin) {
                result.append(this.separator);
            }
            needjoin = true;
            result.append(this.componentManager.unconvert(obj));
        }
        return result.toString();
    }

    public int hashCode() {
        return this.componentManager.hashCode() * this.separator;
    }

    public boolean equals(Object o) {
        if (o instanceof ArrayFormatManager) {
            ArrayFormatManager other = (ArrayFormatManager)o;
            return this.componentManager.equals(other.componentManager) && this.separator == other.separator;
        }
        return false;
    }

    private class ArrayObjectContainer
    implements ObjectContainer<T[]>,
    Indirect<T[]> {
        private final ObjectContainer<T>[] array;

        public ArrayObjectContainer(ObjectContainer<T>[] toSet) {
            this.array = toSet;
        }

        @Override
        public boolean contains(T[] toCheck) {
            for (Object obj : toCheck) {
                boolean found = false;
                for (ObjectContainer container : this.array) {
                    if (!container.contains(obj)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }

        @Override
        public Class<T[]> getReferenceClass() {
            return ArrayFormatManager.this.formatClass;
        }

        @Override
        public Collection<? extends T[]> getContainedObjects() {
            return Collections.singleton(this.resolvesTo());
        }

        @Override
        public String getLSTformat(boolean useAny) {
            StringBuilder result = new StringBuilder();
            boolean needjoin = false;
            for (ObjectContainer container : this.array) {
                if (needjoin) {
                    result.append(ArrayFormatManager.this.separator);
                }
                needjoin = true;
                result.append(container.getLSTformat(useAny));
            }
            return result.toString();
        }

        @Override
        public T[] resolvesTo() {
            Class arrayClass = ArrayFormatManager.this.componentManager.getManagedClass();
            ArrayList returnList = new ArrayList(this.array.length * 5);
            for (ObjectContainer container : this.array) {
                returnList.addAll(container.getContainedObjects());
            }
            Object[] toReturn = (Object[])Array.newInstance(arrayClass, returnList.size());
            for (int i = 0; i < this.array.length; ++i) {
                toReturn[i] = returnList.get(i);
            }
            return toReturn;
        }

        @Override
        public String getUnconverted() {
            return this.getLSTformat(false);
        }
    }
}

