//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/ctfontcollection?language=objc)
///
/// This is toll-free bridged with `NSFontCollection`.
#[doc(alias = "CTFontCollectionRef")]
#[repr(C)]
pub struct CTFontCollection {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CTFontCollection {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CTFontCollection"> for CTFontCollection {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/ctmutablefontcollection?language=objc)
///
/// This is toll-free bridged with `NSMutableFontCollection`.
#[doc(alias = "CTMutableFontCollectionRef")]
#[repr(C)]
pub struct CTMutableFontCollection {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CTMutableFontCollection: CTFontCollection {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CTFontCollection"> for CTMutableFontCollection {}
);

unsafe impl ConcreteType for CTFontCollection {
    /// Returns the type identifier for Core Text font collection references.
    ///
    /// Returns: The identifier for the opaque types CTFontCollectionRef or CTMutableFontCollectionRef.
    #[doc(alias = "CTFontCollectionGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CTFontCollectionGetTypeID() -> CFTypeID;
        }
        unsafe { CTFontCollectionGetTypeID() }
    }
}

/// Collection sorting callback.
///
/// This callback can be specified to obtain the matching font descriptors of a collection in sorted order. Return the appropriate comparison result of first descriptor to second descriptor.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/ctfontcollectionsortdescriptorscallback?language=objc)
#[cfg(feature = "CTFontDescriptor")]
pub type CTFontCollectionSortDescriptorsCallback = Option<
    unsafe extern "C-unwind" fn(
        NonNull<CTFontDescriptor>,
        NonNull<CTFontDescriptor>,
        NonNull<c_void>,
    ) -> CFComparisonResult,
>;

extern "C" {
    /// kCTFontCollectionRemoveDuplicatesOption
    ///
    /// Option key to specify filtering of duplicates.
    ///
    /// Specify this option key in the options dictionary with a non- zero value to enable automatic filtering of duplicate font descriptors.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontcollectionremoveduplicatesoption?language=objc)
    pub static kCTFontCollectionRemoveDuplicatesOption: &'static CFString;
}

extern "C" {
    /// kCTFontCollectionIncludeDisabledFontsOption
    ///
    /// Option key to include disabled fonts in the matching results.
    ///
    /// Specify this option key in the options dictionary with a non-zero value to enable matching of disabled fonts. You can pass font descriptors specifying disabled fonts to CTFontManagerEnableFontDescriptors, but you cannot use such a font descriptor to query font attributes from the system database or create a CTFontRef.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontcollectionincludedisabledfontsoption?language=objc)
    pub static kCTFontCollectionIncludeDisabledFontsOption: &'static CFString;
}

extern "C" {
    /// kCTFontCollectionDisallowAutoActivationOption
    ///
    /// Option key to avoid auto-activating fonts.
    ///
    /// Specify this option key in the options dictionary with a non-zero value to disallow searches for missing fonts (font descriptors returning no results).
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontcollectiondisallowautoactivationoption?language=objc)
    pub static kCTFontCollectionDisallowAutoActivationOption: &'static CFString;
}

impl CTFontCollection {
    /// Returns a new font collection matching all available fonts.
    ///
    ///
    /// Parameter `options`: The options dictionary. See constant option keys.
    ///
    ///
    /// Returns: This function creates a new collection containing all fonts available to the current application.
    ///
    /// # Safety
    ///
    /// `options` generics must be of the correct type.
    #[doc(alias = "CTFontCollectionCreateFromAvailableFonts")]
    #[inline]
    pub unsafe fn from_available_fonts(
        options: Option<&CFDictionary>,
    ) -> CFRetained<CTFontCollection> {
        extern "C-unwind" {
            fn CTFontCollectionCreateFromAvailableFonts(
                options: Option<&CFDictionary>,
            ) -> Option<NonNull<CTFontCollection>>;
        }
        let ret = unsafe { CTFontCollectionCreateFromAvailableFonts(options) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }

    /// Returns a new collection based on the array of font descriptors.
    ///
    ///
    /// Parameter `queryDescriptors`: An array of font descriptors to use for matching. May be NULL, in which case the matching descriptors will be NULL.
    ///
    ///
    /// Parameter `options`: The options dictionary. See constant option keys.
    ///
    ///
    /// Returns: This function creates a new collection based on the provided font descriptors. The contents of this collection is defined by matching the provided descriptors against all available font descriptors.
    ///
    /// # Safety
    ///
    /// - `query_descriptors` generic must be of the correct type.
    /// - `options` generics must be of the correct type.
    #[doc(alias = "CTFontCollectionCreateWithFontDescriptors")]
    #[inline]
    pub unsafe fn with_font_descriptors(
        query_descriptors: Option<&CFArray>,
        options: Option<&CFDictionary>,
    ) -> CFRetained<CTFontCollection> {
        extern "C-unwind" {
            fn CTFontCollectionCreateWithFontDescriptors(
                query_descriptors: Option<&CFArray>,
                options: Option<&CFDictionary>,
            ) -> Option<NonNull<CTFontCollection>>;
        }
        let ret = unsafe { CTFontCollectionCreateWithFontDescriptors(query_descriptors, options) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }

    /// Returns a copy of the original collection augmented with the new font descriptors.
    ///
    ///
    /// Parameter `original`: The original font collection reference.
    ///
    ///
    /// Parameter `queryDescriptors`: An array of font descriptors to augment those of the original collection.
    ///
    ///
    /// Parameter `options`: The options dictionary. See constant option keys.
    ///
    ///
    /// Returns: This function creates a copy of the original font collection augmented by the new font descriptors and options. The new font descriptors are merged with the existing descriptors to create a single set.
    ///
    /// # Safety
    ///
    /// - `query_descriptors` generic must be of the correct type.
    /// - `options` generics must be of the correct type.
    #[doc(alias = "CTFontCollectionCreateCopyWithFontDescriptors")]
    #[inline]
    pub unsafe fn copy_with_font_descriptors(
        &self,
        query_descriptors: Option<&CFArray>,
        options: Option<&CFDictionary>,
    ) -> CFRetained<CTFontCollection> {
        extern "C-unwind" {
            fn CTFontCollectionCreateCopyWithFontDescriptors(
                original: &CTFontCollection,
                query_descriptors: Option<&CFArray>,
                options: Option<&CFDictionary>,
            ) -> Option<NonNull<CTFontCollection>>;
        }
        let ret = unsafe {
            CTFontCollectionCreateCopyWithFontDescriptors(self, query_descriptors, options)
        };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }
}

impl CTMutableFontCollection {
    /// Returns a mutable copy of the original collection.
    ///
    ///
    /// Parameter `original`: The original font collection reference.
    ///
    ///
    /// Returns: This function creates a mutable copy of the original font collection.
    #[doc(alias = "CTFontCollectionCreateMutableCopy")]
    #[inline]
    pub unsafe fn new_copy(original: &CTFontCollection) -> CFRetained<CTMutableFontCollection> {
        extern "C-unwind" {
            fn CTFontCollectionCreateMutableCopy(
                original: &CTFontCollection,
            ) -> Option<NonNull<CTMutableFontCollection>>;
        }
        let ret = unsafe { CTFontCollectionCreateMutableCopy(original) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }
}

impl CTFontCollection {
    /// Returns the array of descriptors to match.
    ///
    ///
    /// Parameter `collection`: The font collection reference.
    ///
    ///
    /// Returns: This function returns a retained reference to the array of descriptors to be used to query (match) the system font database. The return value is undefined if CTFontCollectionCreateFromAvailableFonts was used to create the collection.
    #[doc(alias = "CTFontCollectionCopyQueryDescriptors")]
    #[inline]
    pub unsafe fn query_descriptors(&self) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CTFontCollectionCopyQueryDescriptors(
                collection: &CTFontCollection,
            ) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CTFontCollectionCopyQueryDescriptors(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

impl CTMutableFontCollection {
    /// Replaces the array of descriptors to match.
    ///
    ///
    /// Parameter `collection`: The font collection reference.
    ///
    ///
    /// Parameter `descriptors`: An array of CTFontDescriptorRef. May be NULL to represent an empty collection, in which case the matching descriptors will also be NULL.
    ///
    /// # Safety
    ///
    /// `descriptors` generic must be of the correct type.
    #[doc(alias = "CTFontCollectionSetQueryDescriptors")]
    #[inline]
    pub unsafe fn set_query_descriptors(&self, descriptors: Option<&CFArray>) {
        extern "C-unwind" {
            fn CTFontCollectionSetQueryDescriptors(
                collection: &CTMutableFontCollection,
                descriptors: Option<&CFArray>,
            );
        }
        unsafe { CTFontCollectionSetQueryDescriptors(self, descriptors) }
    }
}

impl CTFontCollection {
    /// Returns the array of descriptors to exclude from the match.
    ///
    ///
    /// Parameter `collection`: The font collection reference.
    ///
    ///
    /// Returns: This function returns a retained reference to the array of descriptors to be used to query (match) the system font database.
    #[doc(alias = "CTFontCollectionCopyExclusionDescriptors")]
    #[inline]
    pub unsafe fn exclusion_descriptors(&self) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CTFontCollectionCopyExclusionDescriptors(
                collection: &CTFontCollection,
            ) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CTFontCollectionCopyExclusionDescriptors(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

impl CTMutableFontCollection {
    /// Replaces the array of descriptors to exclude from the match.
    ///
    ///
    /// Parameter `collection`: The font collection reference.
    ///
    ///
    /// Parameter `descriptors`: An array of CTFontDescriptorRef. May be NULL.
    ///
    /// # Safety
    ///
    /// `descriptors` generic must be of the correct type.
    #[doc(alias = "CTFontCollectionSetExclusionDescriptors")]
    #[inline]
    pub unsafe fn set_exclusion_descriptors(&self, descriptors: Option<&CFArray>) {
        extern "C-unwind" {
            fn CTFontCollectionSetExclusionDescriptors(
                collection: &CTMutableFontCollection,
                descriptors: Option<&CFArray>,
            );
        }
        unsafe { CTFontCollectionSetExclusionDescriptors(self, descriptors) }
    }
}

impl CTFontCollection {
    /// Returns an array of font descriptors matching the collection.
    ///
    ///
    /// Parameter `collection`: The font collection reference.
    ///
    ///
    /// Returns: An array of CTFontDescriptors matching the collection definition or NULL if there are none.
    #[doc(alias = "CTFontCollectionCreateMatchingFontDescriptors")]
    #[inline]
    pub unsafe fn matching_font_descriptors(&self) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CTFontCollectionCreateMatchingFontDescriptors(
                collection: &CTFontCollection,
            ) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CTFontCollectionCreateMatchingFontDescriptors(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns the array of matching font descriptors sorted with the callback function.
    ///
    ///
    /// Parameter `collection`: The collection reference.
    ///
    ///
    /// Parameter `sortCallback`: The sorting callback function that defines the sort order.
    ///
    ///
    /// Parameter `refCon`: Pointer to client data define context for the callback.
    ///
    ///
    /// Returns: An array of CTFontDescriptors matching the criteria of the collection, sorted by the results of the sorting callback function, or NULL if there are none.
    ///
    /// # Safety
    ///
    /// - `sort_callback` must be implemented correctly.
    /// - `ref_con` must be a valid pointer or null.
    #[doc(alias = "CTFontCollectionCreateMatchingFontDescriptorsSortedWithCallback")]
    #[cfg(feature = "CTFontDescriptor")]
    #[inline]
    pub unsafe fn matching_font_descriptors_sorted_with_callback(
        &self,
        sort_callback: CTFontCollectionSortDescriptorsCallback,
        ref_con: *mut c_void,
    ) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CTFontCollectionCreateMatchingFontDescriptorsSortedWithCallback(
                collection: &CTFontCollection,
                sort_callback: CTFontCollectionSortDescriptorsCallback,
                ref_con: *mut c_void,
            ) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe {
            CTFontCollectionCreateMatchingFontDescriptorsSortedWithCallback(
                self,
                sort_callback,
                ref_con,
            )
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns an array of font descriptors matching the collection.
    ///
    ///
    /// Parameter `collection`: The font collection reference.
    ///
    ///
    /// Parameter `options`: The options dictionary. See constant option keys. May be NULL, in which case this call returns the same results as CTFontCollectionCreateMatchingFontDescriptors, using the options passed in when the collection was created.
    ///
    ///
    /// Returns: An array of CTFontDescriptors matching the collection definition or NULL if there are none.
    ///
    /// # Safety
    ///
    /// `options` generics must be of the correct type.
    #[doc(alias = "CTFontCollectionCreateMatchingFontDescriptorsWithOptions")]
    #[inline]
    pub unsafe fn matching_font_descriptors_with_options(
        &self,
        options: Option<&CFDictionary>,
    ) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CTFontCollectionCreateMatchingFontDescriptorsWithOptions(
                collection: &CTFontCollection,
                options: Option<&CFDictionary>,
            ) -> Option<NonNull<CFArray>>;
        }
        let ret =
            unsafe { CTFontCollectionCreateMatchingFontDescriptorsWithOptions(self, options) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns an array of font descriptors matching the specified family, one descriptor for each style in the collection.
    ///
    ///
    /// Parameter `collection`: The font collection reference.
    ///
    ///
    /// Parameter `familyName`: The font family name
    ///
    ///
    /// Returns: An array of CTFontDescriptors matching the specified family in the collection or NULL if there are none.
    ///
    /// # Safety
    ///
    /// `options` generics must be of the correct type.
    #[doc(alias = "CTFontCollectionCreateMatchingFontDescriptorsForFamily")]
    #[inline]
    pub unsafe fn matching_font_descriptors_for_family(
        &self,
        family_name: &CFString,
        options: Option<&CFDictionary>,
    ) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CTFontCollectionCreateMatchingFontDescriptorsForFamily(
                collection: &CTFontCollection,
                family_name: &CFString,
                options: Option<&CFDictionary>,
            ) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe {
            CTFontCollectionCreateMatchingFontDescriptorsForFamily(self, family_name, options)
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

/// Option bits for use with CTFontCollectionCopyFontAttribute(s).
///
///
/// Passing this option indicates that the return values should be sorted in standard UI order, suitable for display to the user. This is the same sorting behavior used by NSFontPanel and Font Book.
///
///
/// Passing this option indicates that duplicate values should be removed from the results.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/ctfontcollectioncopyoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CTFontCollectionCopyOptions(pub u32);
bitflags::bitflags! {
    impl CTFontCollectionCopyOptions: u32 {
        #[doc(alias = "kCTFontCollectionCopyDefaultOptions")]
        const DefaultOptions = 0;
        #[doc(alias = "kCTFontCollectionCopyUnique")]
        const Unique = 1<<0;
        #[doc(alias = "kCTFontCollectionCopyStandardSort")]
        const StandardSort = 1<<1;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CTFontCollectionCopyOptions {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CTFontCollectionCopyOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

impl CTFontCollection {
    /// Returns an array of font descriptor attribute values.
    ///
    ///
    /// Parameter `collection`: The font collection reference.
    ///
    ///
    /// Parameter `attributeName`: The attribute to retrieve for each descriptor in the collection.
    ///
    ///
    /// Parameter `options`: Options to alter the return value.
    ///
    ///
    /// Returns: An array containing one value for each descriptor. With kCTFontCollectionCopyDefaultOptions, the values will be in the same order as the results from CTFontCollectionCreateMatchingFontDescriptors and NULL values will be transformed to kCFNull. When the kCTFontCollectionCopyUnique is set, duplicate values will be removed. When kCTFontCollectionCopyStandardSort is set, the values will be sorted in standard UI order.
    #[doc(alias = "CTFontCollectionCopyFontAttribute")]
    #[inline]
    pub unsafe fn font_attribute(
        &self,
        attribute_name: &CFString,
        options: CTFontCollectionCopyOptions,
    ) -> CFRetained<CFArray> {
        extern "C-unwind" {
            fn CTFontCollectionCopyFontAttribute(
                collection: &CTFontCollection,
                attribute_name: &CFString,
                options: CTFontCollectionCopyOptions,
            ) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CTFontCollectionCopyFontAttribute(self, attribute_name, options) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }

    /// Returns an array of dictionaries containing font descriptor attribute values.
    ///
    ///
    /// Parameter `collection`: The font collection reference.
    ///
    ///
    /// Parameter `attributeNames`: The attributes to retrieve for each descriptor in the collection.
    ///
    ///
    /// Parameter `options`: Options to alter the return value.
    ///
    ///
    /// Returns: An array containing one CFDictionary value for each descriptor mapping the requested attribute names. With kCTFontCollectionCopyDefaultOptions, the values will be in the same order as the results from CTFontCollectionCreateMatchingFontDescriptors. When the kCTFontCollectionCopyUnique is set, duplicate values will be removed. When kCTFontCollectionCopyStandardSort is set, the values will be sorted in standard UI order.
    ///
    /// # Safety
    ///
    /// `attribute_names` generic must be of the correct type.
    #[doc(alias = "CTFontCollectionCopyFontAttributes")]
    #[inline]
    pub unsafe fn font_attributes(
        &self,
        attribute_names: &CFSet,
        options: CTFontCollectionCopyOptions,
    ) -> CFRetained<CFArray> {
        extern "C-unwind" {
            fn CTFontCollectionCopyFontAttributes(
                collection: &CTFontCollection,
                attribute_names: &CFSet,
                options: CTFontCollectionCopyOptions,
            ) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CTFontCollectionCopyFontAttributes(self, attribute_names, options) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }
}

#[deprecated = "renamed to `CTFontCollection::from_available_fonts`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCollectionCreateFromAvailableFonts(
    options: Option<&CFDictionary>,
) -> CFRetained<CTFontCollection> {
    extern "C-unwind" {
        fn CTFontCollectionCreateFromAvailableFonts(
            options: Option<&CFDictionary>,
        ) -> Option<NonNull<CTFontCollection>>;
    }
    let ret = unsafe { CTFontCollectionCreateFromAvailableFonts(options) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[deprecated = "renamed to `CTFontCollection::with_font_descriptors`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCollectionCreateWithFontDescriptors(
    query_descriptors: Option<&CFArray>,
    options: Option<&CFDictionary>,
) -> CFRetained<CTFontCollection> {
    extern "C-unwind" {
        fn CTFontCollectionCreateWithFontDescriptors(
            query_descriptors: Option<&CFArray>,
            options: Option<&CFDictionary>,
        ) -> Option<NonNull<CTFontCollection>>;
    }
    let ret = unsafe { CTFontCollectionCreateWithFontDescriptors(query_descriptors, options) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[deprecated = "renamed to `CTFontCollection::copy_with_font_descriptors`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCollectionCreateCopyWithFontDescriptors(
    original: &CTFontCollection,
    query_descriptors: Option<&CFArray>,
    options: Option<&CFDictionary>,
) -> CFRetained<CTFontCollection> {
    extern "C-unwind" {
        fn CTFontCollectionCreateCopyWithFontDescriptors(
            original: &CTFontCollection,
            query_descriptors: Option<&CFArray>,
            options: Option<&CFDictionary>,
        ) -> Option<NonNull<CTFontCollection>>;
    }
    let ret = unsafe {
        CTFontCollectionCreateCopyWithFontDescriptors(original, query_descriptors, options)
    };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[deprecated = "renamed to `CTMutableFontCollection::new_copy`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCollectionCreateMutableCopy(
    original: &CTFontCollection,
) -> CFRetained<CTMutableFontCollection> {
    extern "C-unwind" {
        fn CTFontCollectionCreateMutableCopy(
            original: &CTFontCollection,
        ) -> Option<NonNull<CTMutableFontCollection>>;
    }
    let ret = unsafe { CTFontCollectionCreateMutableCopy(original) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[deprecated = "renamed to `CTFontCollection::query_descriptors`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCollectionCopyQueryDescriptors(
    collection: &CTFontCollection,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CTFontCollectionCopyQueryDescriptors(
            collection: &CTFontCollection,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CTFontCollectionCopyQueryDescriptors(collection) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTMutableFontCollection::set_query_descriptors`"]
    pub fn CTFontCollectionSetQueryDescriptors(
        collection: &CTMutableFontCollection,
        descriptors: Option<&CFArray>,
    );
}

#[deprecated = "renamed to `CTFontCollection::exclusion_descriptors`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCollectionCopyExclusionDescriptors(
    collection: &CTFontCollection,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CTFontCollectionCopyExclusionDescriptors(
            collection: &CTFontCollection,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CTFontCollectionCopyExclusionDescriptors(collection) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTMutableFontCollection::set_exclusion_descriptors`"]
    pub fn CTFontCollectionSetExclusionDescriptors(
        collection: &CTMutableFontCollection,
        descriptors: Option<&CFArray>,
    );
}

#[deprecated = "renamed to `CTFontCollection::matching_font_descriptors`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCollectionCreateMatchingFontDescriptors(
    collection: &CTFontCollection,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CTFontCollectionCreateMatchingFontDescriptors(
            collection: &CTFontCollection,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CTFontCollectionCreateMatchingFontDescriptors(collection) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CTFontDescriptor")]
#[deprecated = "renamed to `CTFontCollection::matching_font_descriptors_sorted_with_callback`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCollectionCreateMatchingFontDescriptorsSortedWithCallback(
    collection: &CTFontCollection,
    sort_callback: CTFontCollectionSortDescriptorsCallback,
    ref_con: *mut c_void,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CTFontCollectionCreateMatchingFontDescriptorsSortedWithCallback(
            collection: &CTFontCollection,
            sort_callback: CTFontCollectionSortDescriptorsCallback,
            ref_con: *mut c_void,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe {
        CTFontCollectionCreateMatchingFontDescriptorsSortedWithCallback(
            collection,
            sort_callback,
            ref_con,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CTFontCollection::matching_font_descriptors_with_options`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCollectionCreateMatchingFontDescriptorsWithOptions(
    collection: &CTFontCollection,
    options: Option<&CFDictionary>,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CTFontCollectionCreateMatchingFontDescriptorsWithOptions(
            collection: &CTFontCollection,
            options: Option<&CFDictionary>,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret =
        unsafe { CTFontCollectionCreateMatchingFontDescriptorsWithOptions(collection, options) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CTFontCollection::matching_font_descriptors_for_family`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCollectionCreateMatchingFontDescriptorsForFamily(
    collection: &CTFontCollection,
    family_name: &CFString,
    options: Option<&CFDictionary>,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CTFontCollectionCreateMatchingFontDescriptorsForFamily(
            collection: &CTFontCollection,
            family_name: &CFString,
            options: Option<&CFDictionary>,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe {
        CTFontCollectionCreateMatchingFontDescriptorsForFamily(collection, family_name, options)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CTFontCollection::font_attribute`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCollectionCopyFontAttribute(
    collection: &CTFontCollection,
    attribute_name: &CFString,
    options: CTFontCollectionCopyOptions,
) -> CFRetained<CFArray> {
    extern "C-unwind" {
        fn CTFontCollectionCopyFontAttribute(
            collection: &CTFontCollection,
            attribute_name: &CFString,
            options: CTFontCollectionCopyOptions,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CTFontCollectionCopyFontAttribute(collection, attribute_name, options) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[deprecated = "renamed to `CTFontCollection::font_attributes`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCollectionCopyFontAttributes(
    collection: &CTFontCollection,
    attribute_names: &CFSet,
    options: CTFontCollectionCopyOptions,
) -> CFRetained<CFArray> {
    extern "C-unwind" {
        fn CTFontCollectionCopyFontAttributes(
            collection: &CTFontCollection,
            attribute_names: &CFSet,
            options: CTFontCollectionCopyOptions,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CTFontCollectionCopyFontAttributes(collection, attribute_names, options) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}
