/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.project.ProjectManager;
import com.jeta.forms.store.properties.JETAProperty;
import com.jeta.open.registry.JETARegistry;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class IconProperty
extends JETAProperty
implements Externalizable,
Icon {
    static final long serialVersionUID = -7743120720855547949L;
    public static final int VERSION = 1;
    private boolean m_embedded = false;
    private String m_path;
    private transient ImageIcon m_image;
    private String m_description;
    private int[] m_pixels;
    static final /* synthetic */ boolean $assertionsDisabled;

    public String getDescription() {
        return this.m_description;
    }

    public ImageIcon imageIcon() {
        return this.m_image;
    }

    public int getIconWidth() {
        return this.m_image == null ? 0 : this.m_image.getIconWidth();
    }

    public int getIconHeight() {
        return this.m_image == null ? 0 : this.m_image.getIconHeight();
    }

    public String getRelativePath() {
        return this.m_path;
    }

    public boolean isEmbedded() {
        return this.m_embedded;
    }

    public void loadImage() {
        try {
            ProjectManager projectManager = (ProjectManager)JETARegistry.lookup("jeta.forms.projectManager");
            if (projectManager != null && this.m_path != null && this.m_path.length() > 0) {
                this.m_image = projectManager.loadImage(this.m_path);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.m_image != null) {
            this.m_image.paintIcon(component, graphics, n, n2);
        }
    }

    public void print() {
        System.out.println("IconProperty..................");
        System.out.println("  embedded: " + this.isEmbedded());
        System.out.println("  description: " + this.getDescription());
        System.out.println("  path: " + this.getRelativePath());
        System.out.println("  width: " + this.getIconWidth());
        System.out.println("  height: " + this.getIconHeight());
    }

    public void setEmbedded(boolean bl) {
        this.m_embedded = false;
    }

    public void setDescription(String string) {
        this.m_description = string;
    }

    public void setRelativePath(String string) {
        this.m_path = string;
        this.m_image = null;
        this.loadImage();
        if (string != null) {
            int n = string.lastIndexOf(92);
            this.m_description = (n = Math.max(n, string.lastIndexOf(47))) > 0 ? string.substring(n + 1, string.length()) : string;
        }
    }

    public void setValue(Object object) {
        if (object == this) {
            return;
        }
        if (object instanceof IconProperty) {
            IconProperty iconProperty = (IconProperty)object;
            this.m_embedded = false;
            this.m_path = iconProperty.m_path;
            this.m_image = iconProperty.m_image;
            this.m_description = iconProperty.m_description;
            if (!this.m_embedded && this.m_image == null) {
                this.loadImage();
            }
        } else if (object == null) {
            this.m_path = "";
            this.m_image = null;
            this.m_description = "";
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void updateBean(JETABean jETABean) {
    }

    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        super.readExternal(objectInput);
        int n = objectInput.readInt();
        this.m_embedded = objectInput.readBoolean();
        this.m_path = (String)objectInput.readObject();
        if (FormUtils.isDesignMode()) {
            this.m_path = FormUtils.fixPath(this.m_path);
        }
        this.m_description = (String)objectInput.readObject();
        int n2 = objectInput.readInt();
        int n3 = objectInput.readInt();
        this.m_embedded = false;
        this.loadImage();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(1);
        objectOutput.writeBoolean(this.m_embedded);
        objectOutput.writeObject(this.m_path);
        objectOutput.writeObject(this.m_description);
        int n = this.getIconWidth();
        int n2 = this.getIconHeight();
        objectOutput.writeInt(n);
        objectOutput.writeInt(n2);
    }

    static {
        $assertionsDisabled = !IconProperty.class.desiredAssertionStatus();
    }
}

