all: config.h ls ls_sus ls_su3 ls_ucb

ls: ls.o
	$(LD) $(LDFLAGS) ls.o $(LCURS) $(LCOMMON) $(LWCHAR) $(LIBS) -o ls

ls.o: ls.c config.h
	$(CC) $(CFLAGS) $(CPPFLAGS) $(LARGEF) $(IWCHAR) -c ls.c

ls_sus: ls_sus.o
	$(LD) $(LDFLAGS) ls_sus.o $(LCURS) $(LCOMMON) $(LWCHAR) $(LIBS) -o ls_sus

ls_sus.o: ls.c config.h
	$(CC) $(CFLAGS) $(CPPFLAGS) $(LARGEF) $(IWCHAR) -DSUS -c ls.c -o ls_sus.o

ls_su3: ls_su3.o
	$(LD) $(LDFLAGS) ls_su3.o $(LCURS) $(LCOMMON) $(LWCHAR) $(LIBS) -o ls_su3

ls_su3.o: ls.c config.h
	$(CC) $(CFLAGS) $(CPPFLAGS) $(LARGEF) $(IWCHAR) -DSU3 -c ls.c -o ls_su3.o

ls_ucb: ls_ucb.o
	$(LD) $(LDFLAGS) ls_ucb.o $(LCURS) $(LCOMMON) $(LWCHAR) $(LIBS) -o ls_ucb

ls_ucb.o: ls.c config.h
	$(CC) $(CFLAGS) $(CPPFLAGS) $(LARGEF) $(IWCHAR) -DUCB -c ls.c -o ls_ucb.o

install: all
	$(UCBINST) -c ls $(ROOT)$(SV3BIN)/ls
	$(STRIP) $(ROOT)$(SV3BIN)/ls
	rm -f $(ROOT)$(SV3BIN)/lc
	$(LNS) ls $(ROOT)$(SV3BIN)/lc
	$(UCBINST) -c ls_sus $(ROOT)$(SUSBIN)/ls
	$(STRIP) $(ROOT)$(SUSBIN)/ls
	$(UCBINST) -c ls_su3 $(ROOT)$(SU3BIN)/ls
	$(STRIP) $(ROOT)$(SU3BIN)/ls
	$(UCBINST) -c ls_ucb $(ROOT)$(UCBBIN)/ls
	$(STRIP) $(ROOT)$(UCBBIN)/ls
	$(MANINST) -c -m 644 ls.1 $(ROOT)$(MANDIR)/man1/ls.1
	rm -f $(ROOT)$(MANDIR)/man1/lc.1
	$(LNS) ls.1 $(ROOT)$(MANDIR)/man1/lc.1
	$(MANINST) -c -m 644 ls.1b $(ROOT)$(MANDIR)/man1b/ls.1b

clean:
	rm -f config.h ls ls.o ls_sus ls_sus.o ls_su3 ls_su3.o ls_ucb ls_ucb.o core log *~

config.h:
	-echo '/*	Auto-generated by make. Do no edit!	*/' >config.h
	-echo '#include <wchar.h>' >___build$$$$.c ; \
	echo 'int main(void) { wcwidth(0); return 0; }' >>___build$$$$.c ; \
	$(CC) $(CFLAGS) $(CPPFLAGS) $(LARGEF) $(IWCHAR) -o ___build$$$$  ___build$$$$.c >/dev/null 2>&1 ; \
	if test $$? = 0 && test -f ___build$$$$ ; \
	then	echo '#include	<wchar.h>' >>config.h ; \
	fi ; \
	rm -f ___build$$$$ ___build$$$$.c
	-echo '#include <wctype.h>' >___build$$$$.c ; \
	echo 'int main(void) { iswprint(0); return 0; }' >>___build$$$$.c ; \
	$(CC) $(CFLAGS) $(CPPFLAGS) $(LARGEF) $(IWCHAR) -o ___build$$$$  ___build$$$$.c >/dev/null 2>&1 ; \
	if test $$? = 0 && test -f ___build$$$$ ; \
	then	echo '#include	<wctype.h>' >>config.h ; \
	fi ; \
	rm -f ___build$$$$ ___build$$$$.c
	-echo '#include <libgen.h>' >___build$$$$.c ; \
	$(CC) $(CFLAGS) $(CPPFLAGS) $(LARGEF) $(IWCHAR) -c ___build$$$$.c >/dev/null 2>&1 ; \
	if test $$? = 0 && test -f ___build$$$$.o ; \
	then	echo '#include	<libgen.h>' >>config.h ; \
	fi ; \
	rm -f ___build$$$$.o ___build$$$$.c
	-echo '#include <sys/types.h>' >___build$$$$.c ; \
	echo '#include <sys/mkdev.h>' >>___build$$$$.c ; \
	echo 'int main(void) { major(0); return 0; }' >>___build$$$$.c ; \
	$(CC) $(CFLAGS) $(CPPFLAGS) $(LARGEF) $(IWCHAR) -o ___build$$$$  ___build$$$$.c >/dev/null 2>&1 ; \
	if test $$? = 0 && test -f ___build$$$$ ; \
	then	echo '#include	<sys/mkdev.h>' >>config.h ; \
	fi ; \
	rm -f ___build$$$$ ___build$$$$.c
	-echo 'long long foo;' >___build$$$$.c ; \
	$(CC) $(CFLAGS) $(CPPFLAGS) $(LARGEF) $(IWCHAR) -c ___build$$$$.c >/dev/null 2>&1 ; \
	if test $$? = 0 && test -f ___build$$$$.o ; \
	then	echo '#define	LONGLONG' >>config.h ; \
	fi ; \
	rm -f ___build$$$$.o ___build$$$$.c
	-echo '#include <sys/types.h>' >___build$$$$.c ; \
	echo 'blkcnt_t foo;' >>___build$$$$.c ; \
	$(CC) $(CFLAGS) $(CPPFLAGS) $(LARGEF) $(IWCHAR) -c ___build$$$$.c >/dev/null 2>&1 ; \
	if test $$? != 0 || test ! -f ___build$$$$.o ; \
	then	echo 'typedef	long	blkcnt_t;' >>config.h ; \
	fi ; \
	rm -f ___build$$$$.o ___build$$$$.c
