// Code generated by sdkgen. DO NOT EDIT.

// nolint
package organizationmanager

import (
	"context"

	"google.golang.org/grpc"

	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	organizationmanager "github.com/yandex-cloud/go-genproto/yandex/cloud/organizationmanager/v1"
)

//revive:disable

// UserServiceClient is a organizationmanager.UserServiceClient with
// lazy GRPC connection initialization.
type UserServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// DeleteMembership implements organizationmanager.UserServiceClient
func (c *UserServiceClient) DeleteMembership(ctx context.Context, in *organizationmanager.DeleteMembershipRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return organizationmanager.NewUserServiceClient(conn).DeleteMembership(ctx, in, opts...)
}

// ListMembers implements organizationmanager.UserServiceClient
func (c *UserServiceClient) ListMembers(ctx context.Context, in *organizationmanager.ListMembersRequest, opts ...grpc.CallOption) (*organizationmanager.ListMembersResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return organizationmanager.NewUserServiceClient(conn).ListMembers(ctx, in, opts...)
}

type UserMembersIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *UserServiceClient
	request *organizationmanager.ListMembersRequest

	items []*organizationmanager.ListMembersResponse_OrganizationUser
}

func (c *UserServiceClient) UserMembersIterator(ctx context.Context, req *organizationmanager.ListMembersRequest, opts ...grpc.CallOption) *UserMembersIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &UserMembersIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *UserMembersIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListMembers(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Users
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *UserMembersIterator) Take(size int64) ([]*organizationmanager.ListMembersResponse_OrganizationUser, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*organizationmanager.ListMembersResponse_OrganizationUser

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *UserMembersIterator) TakeAll() ([]*organizationmanager.ListMembersResponse_OrganizationUser, error) {
	return it.Take(0)
}

func (it *UserMembersIterator) Value() *organizationmanager.ListMembersResponse_OrganizationUser {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *UserMembersIterator) Error() error {
	return it.err
}
