// Code generated by sdkgen. DO NOT EDIT.

// nolint
package functions

import (
	"context"

	"google.golang.org/grpc"

	functions "github.com/yandex-cloud/go-genproto/yandex/cloud/serverless/functions/v1"
)

//revive:disable

// NetworkServiceClient is a functions.NetworkServiceClient with
// lazy GRPC connection initialization.
type NetworkServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// GetUsed implements functions.NetworkServiceClient
func (c *NetworkServiceClient) GetUsed(ctx context.Context, in *functions.GetUsedNetworkRequest, opts ...grpc.CallOption) (*functions.UsedNetwork, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return functions.NewNetworkServiceClient(conn).GetUsed(ctx, in, opts...)
}

// ListConnectedResources implements functions.NetworkServiceClient
func (c *NetworkServiceClient) ListConnectedResources(ctx context.Context, in *functions.ListConnectedResourcesRequest, opts ...grpc.CallOption) (*functions.ListConnectedResourcesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return functions.NewNetworkServiceClient(conn).ListConnectedResources(ctx, in, opts...)
}

type NetworkConnectedResourcesIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *NetworkServiceClient
	request *functions.ListConnectedResourcesRequest

	items []*functions.ListConnectedResourcesResponse_ConnectedResource
}

func (c *NetworkServiceClient) NetworkConnectedResourcesIterator(ctx context.Context, req *functions.ListConnectedResourcesRequest, opts ...grpc.CallOption) *NetworkConnectedResourcesIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &NetworkConnectedResourcesIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *NetworkConnectedResourcesIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListConnectedResources(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Resources
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *NetworkConnectedResourcesIterator) Take(size int64) ([]*functions.ListConnectedResourcesResponse_ConnectedResource, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*functions.ListConnectedResourcesResponse_ConnectedResource

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *NetworkConnectedResourcesIterator) TakeAll() ([]*functions.ListConnectedResourcesResponse_ConnectedResource, error) {
	return it.Take(0)
}

func (it *NetworkConnectedResourcesIterator) Value() *functions.ListConnectedResourcesResponse_ConnectedResource {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *NetworkConnectedResourcesIterator) Error() error {
	return it.err
}

// ListUsed implements functions.NetworkServiceClient
func (c *NetworkServiceClient) ListUsed(ctx context.Context, in *functions.ListUsedNetworksRequest, opts ...grpc.CallOption) (*functions.ListUsedNetworksResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return functions.NewNetworkServiceClient(conn).ListUsed(ctx, in, opts...)
}

type NetworkUsedIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *NetworkServiceClient
	request *functions.ListUsedNetworksRequest

	items []*functions.UsedNetwork
}

func (c *NetworkServiceClient) NetworkUsedIterator(ctx context.Context, req *functions.ListUsedNetworksRequest, opts ...grpc.CallOption) *NetworkUsedIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &NetworkUsedIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *NetworkUsedIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListUsed(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Networks
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *NetworkUsedIterator) Take(size int64) ([]*functions.UsedNetwork, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*functions.UsedNetwork

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *NetworkUsedIterator) TakeAll() ([]*functions.UsedNetwork, error) {
	return it.Take(0)
}

func (it *NetworkUsedIterator) Value() *functions.UsedNetwork {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *NetworkUsedIterator) Error() error {
	return it.err
}

// TriggerUsedCleanup implements functions.NetworkServiceClient
func (c *NetworkServiceClient) TriggerUsedCleanup(ctx context.Context, in *functions.TriggerUsedNetworkCleanupRequest, opts ...grpc.CallOption) (*functions.TriggerUsedNetworkCleanupResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return functions.NewNetworkServiceClient(conn).TriggerUsedCleanup(ctx, in, opts...)
}
