package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDomainResolveStatisticsSummary invokes the alidns.DescribeDomainResolveStatisticsSummary API synchronously
func (client *Client) DescribeDomainResolveStatisticsSummary(request *DescribeDomainResolveStatisticsSummaryRequest) (response *DescribeDomainResolveStatisticsSummaryResponse, err error) {
	response = CreateDescribeDomainResolveStatisticsSummaryResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDomainResolveStatisticsSummaryWithChan invokes the alidns.DescribeDomainResolveStatisticsSummary API asynchronously
func (client *Client) DescribeDomainResolveStatisticsSummaryWithChan(request *DescribeDomainResolveStatisticsSummaryRequest) (<-chan *DescribeDomainResolveStatisticsSummaryResponse, <-chan error) {
	responseChan := make(chan *DescribeDomainResolveStatisticsSummaryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDomainResolveStatisticsSummary(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDomainResolveStatisticsSummaryWithCallback invokes the alidns.DescribeDomainResolveStatisticsSummary API asynchronously
func (client *Client) DescribeDomainResolveStatisticsSummaryWithCallback(request *DescribeDomainResolveStatisticsSummaryRequest, callback func(response *DescribeDomainResolveStatisticsSummaryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDomainResolveStatisticsSummaryResponse
		var err error
		defer close(result)
		response, err = client.DescribeDomainResolveStatisticsSummary(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDomainResolveStatisticsSummaryRequest is the request struct for api DescribeDomainResolveStatisticsSummary
type DescribeDomainResolveStatisticsSummaryRequest struct {
	*requests.RpcRequest
	Threshold    requests.Integer `position:"Query" name:"Threshold"`
	StartDate    string           `position:"Query" name:"StartDate"`
	PageNumber   requests.Integer `position:"Query" name:"PageNumber"`
	EndDate      string           `position:"Query" name:"EndDate"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	UserClientIp string           `position:"Query" name:"UserClientIp"`
	SearchMode   string           `position:"Query" name:"SearchMode"`
	Keyword      string           `position:"Query" name:"Keyword"`
	Lang         string           `position:"Query" name:"Lang"`
	Direction    string           `position:"Query" name:"Direction"`
}

// DescribeDomainResolveStatisticsSummaryResponse is the response struct for api DescribeDomainResolveStatisticsSummary
type DescribeDomainResolveStatisticsSummaryResponse struct {
	*responses.BaseResponse
	RequestId  string      `json:"RequestId" xml:"RequestId"`
	PageSize   int         `json:"PageSize" xml:"PageSize"`
	PageNumber int         `json:"PageNumber" xml:"PageNumber"`
	TotalPages int         `json:"TotalPages" xml:"TotalPages"`
	TotalItems int         `json:"TotalItems" xml:"TotalItems"`
	Statistics []Statistic `json:"Statistics" xml:"Statistics"`
}

// CreateDescribeDomainResolveStatisticsSummaryRequest creates a request to invoke DescribeDomainResolveStatisticsSummary API
func CreateDescribeDomainResolveStatisticsSummaryRequest() (request *DescribeDomainResolveStatisticsSummaryRequest) {
	request = &DescribeDomainResolveStatisticsSummaryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DescribeDomainResolveStatisticsSummary", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDomainResolveStatisticsSummaryResponse creates a response to parse from DescribeDomainResolveStatisticsSummary response
func CreateDescribeDomainResolveStatisticsSummaryResponse() (response *DescribeDomainResolveStatisticsSummaryResponse) {
	response = &DescribeDomainResolveStatisticsSummaryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
