/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.layout.builder;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.layout.internal.AbstractButtonPanelBuilder;
import com.jgoodies.layout.layout.ColumnSpec;
import com.jgoodies.layout.layout.ConstantSize;
import com.jgoodies.layout.layout.FormLayout;
import com.jgoodies.layout.layout.FormSpecs;
import com.jgoodies.layout.layout.RowSpec;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;

public final class ButtonBarBuilder
extends AbstractButtonPanelBuilder<ButtonBarBuilder> {
    private static final ColumnSpec[] COL_SPECS = new ColumnSpec[0];
    private static final RowSpec[] ROW_SPECS = new RowSpec[]{RowSpec.decode("center:pref")};

    public ButtonBarBuilder() {
        this(new JPanel(null));
    }

    public ButtonBarBuilder(JPanel panel) {
        super(new FormLayout(COL_SPECS, ROW_SPECS), panel);
    }

    public ButtonBarBuilder addButton(JComponent button) {
        Preconditions.checkNotNull(button, "The %s must not be null.", "button to add");
        this.getLayout().appendColumn(FormSpecs.BUTTON_COLSPEC);
        this.add(button);
        this.nextColumn();
        return this;
    }

    public ButtonBarBuilder addButton(JComponent ... buttons) {
        super.addButton(buttons);
        return this;
    }

    public ButtonBarBuilder addButton(Action ... actions) {
        super.addButton(actions);
        return this;
    }

    public ButtonBarBuilder addFixed(JComponent component) {
        this.getLayout().appendColumn(FormSpecs.PREF_COLSPEC);
        this.add(component);
        this.nextColumn();
        return this;
    }

    public ButtonBarBuilder addGrowing(JComponent component) {
        this.getLayout().appendColumn(FormSpecs.GROWING_BUTTON_COLSPEC);
        this.add(component);
        this.nextColumn();
        return this;
    }

    public ButtonBarBuilder addGap(ConstantSize width) {
        this.getLayout().appendColumn(ColumnSpec.createGap(width));
        this.nextColumn();
        return this;
    }

    public ButtonBarBuilder addGrowingGap() {
        this.appendGrowingGapColumn();
        this.nextColumn();
        return this;
    }

    public ButtonBarBuilder addRelatedGap() {
        this.appendRelatedComponentsGapColumn();
        this.nextColumn();
        return this;
    }

    public ButtonBarBuilder addUnrelatedGap() {
        this.appendUnrelatedComponentsGapColumn();
        this.nextColumn();
        return this;
    }
}

