/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.gui.statistic;

import com.jgoodies.jdiskreport.gui.node.FileNode;
import com.jgoodies.jdiskreport.gui.statistic.AbstractDistribution;

final class SizeDistribution
extends AbstractDistribution {
    private static final long[] ROW_BOUNDS = new long[]{Long.MAX_VALUE, 0x1000000000L, 0x400000000L, 0x100000000L, 0x40000000L, 0x10000000L, 0x4000000L, 0x1000000L, 0x400000L, 0x100000L, 262144L, 65536L, 16384L, 4096L, 1024L};

    SizeDistribution() {
    }

    @Override
    protected int getRowCount() {
        return ROW_BOUNDS.length;
    }

    @Override
    protected void add(FileNode fileNode) {
        long size = fileNode.getSize();
        int rowCount = this.getRowCount();
        for (int i = rowCount - 1; i >= 0; --i) {
            if (size >= ROW_BOUNDS[i]) continue;
            this.add(i, size, 1L);
            return;
        }
    }
}

