/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.gui.shared.renderer;

import com.jgoodies.components.renderer.JGDefaultTableCellRenderer;
import com.jgoodies.jdiskreport.gui.node.AbstractNode;
import com.jgoodies.jdiskreport.gui.node.DirectoryNode;
import com.jgoodies.jdiskreport.gui.shared.format.JDFormats;
import java.util.function.Function;
import javax.swing.table.TableCellRenderer;

public final class JDRenderers {
    public static final TableCellRenderer DEFAULT_RENDERER = new JGDefaultTableCellRenderer();
    public static final TableCellRenderer RIGHT_ALIGNED_DEFAULT_RENDERER = new RightAlignedJGDefaultTableCellRenderer();
    public static final TableCellRenderer NODE_RENDERER = new NodeRenderer();
    public static final TableCellRenderer DIRECTOY_PATH_RENDERER = new DirectoryPathRenderer();
    public static final TableCellRenderer DATE_TIME_RENDERER = new JGDefaultTableCellRenderer<Long>(JDFormats::formatDateTime);
    public static final TableCellRenderer NUMBER_RENDERER = new RightAlignedJGDefaultTableCellRenderer();
    public static final TableCellRenderer SIZE_RENDERER = new RightAlignedJGDefaultTableCellRenderer<Long>(JDFormats::formatSizeForTableCell);
    public static final TableCellRenderer COUNT_RENDERER = new RightAlignedJGDefaultTableCellRenderer<Long>(JDFormats::formatCountForCell);
    public static final TableCellRenderer PERCENT_RENDERER = new RightAlignedJGDefaultTableCellRenderer<Double>(JDFormats::formatPercentForCell);

    private JDRenderers() {
    }

    private static final class DirectoryPathRenderer
    extends JGDefaultTableCellRenderer<DirectoryNode> {
        private DirectoryPathRenderer() {
        }

        @Override
        protected void setValue(DirectoryNode node) {
            this.setIcon(node == null ? null : node.getIcon(false));
            this.setText(node == null ? "" : node.getPathName(), new Object[0]);
        }
    }

    private static final class NodeRenderer
    extends JGDefaultTableCellRenderer<AbstractNode> {
        private NodeRenderer() {
        }

        @Override
        protected void setValue(AbstractNode node) {
            this.setIcon(node.getIcon(false));
            this.setText(node.getName(), new Object[0]);
        }
    }

    private static class RightAlignedJGDefaultTableCellRenderer<V>
    extends JGDefaultTableCellRenderer<V> {
        RightAlignedJGDefaultTableCellRenderer() {
            this.setHorizontalAlignment(4);
        }

        RightAlignedJGDefaultTableCellRenderer(Function<V, String> displayStringFunction) {
            super(displayStringFunction);
            this.setHorizontalAlignment(4);
        }
    }
}

