/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.domain;

import com.jgoodies.jdiskreport.domain.AccessDeniedDirectorySnapshot;
import com.jgoodies.jdiskreport.domain.FileSnapshot;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DirectorySnapshot
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final ArrayList<DirectorySnapshot> directories;
    private final ArrayList<FileSnapshot> files;
    private long startTimeMillis;
    private long stopTimeMillis;

    public DirectorySnapshot(String name) {
        this.name = name;
        this.directories = new ArrayList();
        this.files = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public List<DirectorySnapshot> getDirectories() {
        return Collections.unmodifiableList(this.directories);
    }

    public List<FileSnapshot> getFiles() {
        return Collections.unmodifiableList(this.files);
    }

    long startTimeMillis() {
        return this.startTimeMillis;
    }

    long stopTimeMillis() {
        return this.stopTimeMillis;
    }

    public void startSnapshot() {
        this.startTimeMillis = System.currentTimeMillis();
    }

    public void stopSnapshot() {
        this.stopTimeMillis = System.currentTimeMillis();
    }

    public DirectorySnapshot addDirectory(Path dir, BasicFileAttributes attrs) {
        DirectorySnapshot child = new DirectorySnapshot(dir.toString());
        this.directories.add(child);
        return child;
    }

    public DirectorySnapshot addDirectory(Path dir, IOException exc) {
        AccessDeniedDirectorySnapshot child = new AccessDeniedDirectorySnapshot(dir, exc);
        this.directories.add(child);
        return child;
    }

    public FileSnapshot addFile(Path file, BasicFileAttributes attrs) {
        FileSnapshot child = new FileSnapshot(file, attrs);
        this.files.add(child);
        return child;
    }

    public void trimToSize() {
        this.directories.trimToSize();
        this.files.trimToSize();
    }
}

