/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.components.internal;

import com.jgoodies.components.internal.ComponentSupport;
import com.jgoodies.components.util.ComponentUtils;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;

public class StaticEditorPane
extends JEditorPane {
    public StaticEditorPane(String type) {
        this(type, null);
    }

    public StaticEditorPane(String type, String text) {
        super(type, text);
        super.setEditable(false);
        this.setRequestFocusEnabled(false);
        ComponentUtils.clearFocusTraversalKeys(this);
        Action insertBreakAction = this.getActionMap().get("insert-break");
        if (insertBreakAction != null) {
            this.getActionMap().put("insert-break", new TextActionWrapper(this, insertBreakAction));
        }
    }

    @Override
    public void setEditable(boolean editable) {
    }

    @Override
    public void updateUI() {
        super.updateUI();
        ComponentSupport.configureTransparentBackground(this);
        this.setMargin(new Insets(0, 0, 0, 0));
        if (this.getForeground() instanceof UIResource) {
            this.setForeground(UIManager.getColor("controlText"));
        }
    }

    private static final class TextActionWrapper
    extends TextAction {
        private final JTextComponent editor;
        private final Action delegate;

        TextActionWrapper(JTextComponent editor, Action action) {
            super((String)action.getValue("Name"));
            this.editor = editor;
            this.delegate = action;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.delegate.actionPerformed(e);
        }

        @Override
        public boolean isEnabled() {
            return this.editor != null && this.editor.isEditable() && this.delegate.isEnabled();
        }
    }
}

