/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.adapter;

import com.jgoodies.binding.adapter.ComboBoxAdapter;
import com.jgoodies.binding.adapter.ListModelBindable;
import com.jgoodies.binding.adapter.RadioButtonAdapter;
import com.jgoodies.binding.adapter.SingleListSelectionAdapter;
import com.jgoodies.binding.adapter.TextComponentConnector;
import com.jgoodies.binding.adapter.ToggleButtonAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.internal.TableRowSorterListSelectionModel;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.ComponentValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.base.Preconditions;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.beans.PropertyChangeSupport;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataListener;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

public final class Bindings {
    private static final String COMMIT_ON_FOCUS_LOST_MODEL_KEY = "commitOnFocusListModel";
    private static final String COMPONENT_VALUE_MODEL_KEY = "componentValueModel";
    private static final String COMPONENT_PROPERTY_HANDLER_KEY = "componentPropertyHandler";
    static final FocusLostHandler FOCUS_LOST_HANDLER = new FocusLostHandler();
    static final WeakTrigger FOCUS_LOST_TRIGGER = new WeakTrigger();

    private Bindings() {
    }

    public static void bind(AbstractButton toggleButton, ValueModel valueModel) {
        Bindings.bind(toggleButton, valueModel, Boolean.TRUE, Boolean.FALSE);
    }

    public static void bind(AbstractButton toggleButton, ValueModel valueModel, Object selectedValue, Object deselectedValue) {
        ButtonModel oldModel = toggleButton.getModel();
        String oldActionCommand = oldModel.getActionCommand();
        boolean oldEnabled = oldModel.isEnabled();
        int oldMnemonic = oldModel.getMnemonic();
        int oldMnemonicIndex = toggleButton.getDisplayedMnemonicIndex();
        ToggleButtonAdapter newModel = new ToggleButtonAdapter(valueModel, selectedValue, deselectedValue);
        newModel.setActionCommand(oldActionCommand);
        newModel.setEnabled(oldEnabled);
        newModel.setMnemonic(oldMnemonic);
        toggleButton.setModel(newModel);
        toggleButton.setDisplayedMnemonicIndex(oldMnemonicIndex);
        Bindings.addComponentPropertyHandler(toggleButton, valueModel);
    }

    public static void bind(AbstractButton toggleButton, ValueModel model, Object choice) {
        ButtonModel oldModel = toggleButton.getModel();
        String oldActionCommand = oldModel.getActionCommand();
        boolean oldEnabled = oldModel.isEnabled();
        int oldMnemonic = oldModel.getMnemonic();
        int oldMnemonicIndex = toggleButton.getDisplayedMnemonicIndex();
        RadioButtonAdapter newModel = new RadioButtonAdapter(model, choice);
        newModel.setActionCommand(oldActionCommand);
        newModel.setEnabled(oldEnabled);
        newModel.setMnemonic(oldMnemonic);
        toggleButton.setModel(newModel);
        toggleButton.setDisplayedMnemonicIndex(oldMnemonicIndex);
        Bindings.addComponentPropertyHandler(toggleButton, model);
    }

    public static <E> void bind(JComboBox<E> comboBox, ComboBoxModel<E> model) {
        Preconditions.checkNotNull(model, "The %s must not be null.", "combo box model");
        comboBox.setModel(model);
    }

    public static <E> void bind(JComboBox<E> comboBox, ComboBoxModel<E> model, String nullText) {
        Preconditions.checkNotNull(model, "The %s must not be null.", "combo box model");
        NullElement nullElement = new NullElement(nullText);
        comboBox.setModel(new NullElementComboBoxModel<E>(model, nullElement));
        comboBox.setRenderer(new NullElementComboBoxRenderer<E>(comboBox.getRenderer(), nullElement));
    }

    public static <E> void bind(JComboBox<E> comboBox, SelectionInList<E> selectionInList) {
        Preconditions.checkNotNull(selectionInList, "The %s must not be null.", "SelectionInList");
        comboBox.setModel(new ComboBoxAdapter<E>(selectionInList));
        Bindings.addComponentPropertyHandler(comboBox, selectionInList.getSelectionHolder());
    }

    public static <E> void bind(JComboBox<E> comboBox, SelectionInList<E> selectionInList, String nullText) {
        NullElement nullElement = new NullElement(nullText);
        Bindings.bind(comboBox, selectionInList);
        comboBox.setModel(new NullElementComboBoxModel<E>(comboBox.getModel(), nullElement));
        comboBox.setRenderer(new NullElementComboBoxRenderer<E>(comboBox.getRenderer(), nullElement));
    }

    public static <E> void bind(JComboBox<E> comboBox, ValueModel valueModel) {
        Preconditions.checkNotNull(comboBox, "The %s must not be null.", "combo box");
        comboBox.setSelectedItem(valueModel.getValue());
        valueModel.addValueChangeListener(new ComboBoxSelectedItemUpdateHandler(valueModel, comboBox));
        comboBox.addItemListener(new SelectedItemChangeHandler(comboBox, valueModel));
        Bindings.addComponentPropertyHandler(comboBox, valueModel);
    }

    public static <E> void bind(JComboBox<E> comboBox, ValueModel valueModel, String nullText) {
        NullElement nullElement = new NullElement(nullText);
        Bindings.bind(comboBox, valueModel);
        comboBox.setModel(new NullElementComboBoxModel<E>(comboBox.getModel(), nullElement));
        comboBox.setRenderer(new NullElementComboBoxRenderer<E>(comboBox.getRenderer(), nullElement));
    }

    public static void bind(JFormattedTextField textField, ValueModel valueModel) {
        Bindings.bind((JComponent)textField, "value", valueModel);
    }

    public static void bind(JLabel label, ValueModel valueModel) {
        Bindings.bind(label, "text", valueModel);
    }

    public static <E> void bind(JList<E> list, SelectionInList<E> selectionInList) {
        Preconditions.checkNotNull(selectionInList, "The %s must not be null.", "SelectionInList");
        list.setModel(selectionInList);
        list.setSelectionModel(new SingleListSelectionAdapter(selectionInList.getSelectionIndexHolder()));
        Bindings.addComponentPropertyHandler(list, selectionInList.getSelectionHolder());
    }

    public static <E> void bind(JList<E> list, ListModel<E> listModel, ListSelectionModel listSelectionModel) {
        list.setModel(listModel);
        list.setSelectionModel(listSelectionModel);
    }

    public static <E> void bind(JTable table, SelectionInList<E> selectionInList) {
        ListModel listModel = Preconditions.checkNotNull(selectionInList, "The %s must not be null.", "SelectionInList");
        SingleListSelectionAdapter listSelectionModel = new SingleListSelectionAdapter(selectionInList.getSelectionIndexHolder());
        Bindings.bind(table, listModel, (ListSelectionModel)listSelectionModel);
    }

    public static <E> void bind(JTable table, ListModel<E> listModel, ListSelectionModel listSelectionModel) {
        TableModel tableModel = table.getModel();
        Preconditions.checkNotNull(listSelectionModel, "The %s must not be null.", "ListSelectionModel");
        Preconditions.checkArgument(tableModel instanceof ListModelBindable, "The table's TableModel must implement ListModelBindable to be bound.");
        ((ListModelBindable)((Object)tableModel)).setListModel(listModel);
        if (table.getRowSorter() != null) {
            table.setSelectionModel(new TableRowSorterListSelectionModel(listSelectionModel, table));
        } else {
            table.setSelectionModel(listSelectionModel);
        }
    }

    public static void bind(JTextArea textArea, ValueModel valueModel) {
        Bindings.bind(textArea, valueModel, false);
    }

    public static void bind(JTextArea textArea, ValueModel valueModel, boolean commitOnFocusLost) {
        ValueModel textModel;
        Preconditions.checkNotNull(valueModel, "The %s must not be null.", "value model");
        if (commitOnFocusLost) {
            textModel = Bindings.createCommitOnFocusLostModel(valueModel, textArea);
            textArea.putClientProperty(COMMIT_ON_FOCUS_LOST_MODEL_KEY, textModel);
        } else {
            textModel = valueModel;
        }
        TextComponentConnector connector = new TextComponentConnector(textModel, textArea);
        connector.updateTextComponent();
        Bindings.addComponentPropertyHandler(textArea, valueModel);
    }

    public static void bind(JTextField textField, ValueModel valueModel) {
        Bindings.bind(textField, valueModel, false);
    }

    public static void bind(JTextField textField, ValueModel valueModel, boolean commitOnFocusLost) {
        ValueModel textModel;
        Preconditions.checkNotNull(valueModel, "The %s must not be null.", "value model");
        if (commitOnFocusLost) {
            textModel = Bindings.createCommitOnFocusLostModel(valueModel, textField);
            textField.putClientProperty(COMMIT_ON_FOCUS_LOST_MODEL_KEY, textModel);
        } else {
            textModel = valueModel;
        }
        TextComponentConnector connector = new TextComponentConnector(textModel, textField);
        connector.updateTextComponent();
        Bindings.addComponentPropertyHandler(textField, valueModel);
    }

    public static void bind(JComponent component, String propertyName, ValueModel valueModel) {
        Preconditions.checkNotNull(component, "The %s must not be null.", "component");
        Preconditions.checkNotNull(valueModel, "The %s must not be null.", "value model");
        Preconditions.checkNotBlank(propertyName, "The %s must not be null, empty, or whitespace.", "property name");
        PropertyConnector.connectAndUpdate(valueModel, component, propertyName);
        Bindings.addComponentPropertyHandler(component, valueModel);
    }

    public static void addComponentPropertyHandler(JComponent component, ValueModel valueModel) {
        if (!(valueModel instanceof ComponentValueModel)) {
            return;
        }
        ComponentValueModel cvm = (ComponentValueModel)valueModel;
        ComponentPropertyHandler componentHandler = new ComponentPropertyHandler(component);
        cvm.addPropertyChangeListener(componentHandler);
        component.putClientProperty(COMPONENT_VALUE_MODEL_KEY, cvm);
        component.putClientProperty(COMPONENT_PROPERTY_HANDLER_KEY, componentHandler);
        component.setEnabled(cvm.isEnabled());
        component.setVisible(cvm.isVisible());
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).setEditable(cvm.isEditable());
        }
    }

    public static void removeComponentPropertyHandler(JComponent component) {
        ComponentValueModel componentValueModel = (ComponentValueModel)component.getClientProperty(COMPONENT_VALUE_MODEL_KEY);
        PropertyChangeListener componentHandler = (PropertyChangeListener)component.getClientProperty(COMPONENT_PROPERTY_HANDLER_KEY);
        if (componentValueModel != null && componentHandler != null) {
            componentValueModel.removePropertyChangeListener(componentHandler);
            component.putClientProperty(COMPONENT_VALUE_MODEL_KEY, null);
            component.putClientProperty(COMPONENT_PROPERTY_HANDLER_KEY, null);
        } else if (componentValueModel != null || componentHandler != null) {
            if (componentValueModel != null) {
                throw new IllegalStateException("The component has a ComponentValueModel stored, but lacks the ComponentPropertyHandler.");
            }
            throw new IllegalStateException("The component has a ComponentPropertyHandler stored, but lacks the ComponentValueModel.");
        }
    }

    public static void commitImmediately() {
        FOCUS_LOST_TRIGGER.triggerCommit();
    }

    public static boolean flushImmediately() {
        boolean buffering = Bindings.isFocusOwnerBuffering();
        if (buffering) {
            FOCUS_LOST_TRIGGER.triggerFlush();
        }
        return buffering;
    }

    public static boolean isFocusOwnerBuffering() {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (!(focusOwner instanceof JComponent)) {
            return false;
        }
        Object value = ((JComponent)focusOwner).getClientProperty(COMMIT_ON_FOCUS_LOST_MODEL_KEY);
        if (!(value instanceof BufferedValueModel)) {
            return false;
        }
        BufferedValueModel commitOnFocusLostModel = (BufferedValueModel)value;
        return commitOnFocusLostModel.isBuffering();
    }

    private static ValueModel createCommitOnFocusLostModel(ValueModel valueModel, Component component) {
        Preconditions.checkNotNull(valueModel, "The %s must not be null.", "value model");
        BufferedValueModel model = new BufferedValueModel(valueModel, FOCUS_LOST_TRIGGER);
        component.addFocusListener(FOCUS_LOST_HANDLER);
        return model;
    }

    private static final class ComboBoxSelectedItemUpdateHandler<E>
    implements PropertyChangeListener {
        private final ValueModel valueModel;
        private final JComboBox<E> comboBox;

        private ComboBoxSelectedItemUpdateHandler(ValueModel valueModel, JComboBox<E> comboBox) {
            this.valueModel = valueModel;
            this.comboBox = comboBox;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.comboBox.setSelectedItem(this.valueModel.getValue());
        }
    }

    private static final class ComponentPropertyHandler
    implements PropertyChangeListener {
        private final JComponent component;

        private ComponentPropertyHandler(JComponent component) {
            this.component = component;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            ComponentValueModel model = (ComponentValueModel)evt.getSource();
            switch (propertyName) {
                case "enabled": {
                    this.component.setEnabled(model.isEnabled());
                    break;
                }
                case "visible": {
                    this.component.setVisible(model.isVisible());
                    break;
                }
                case "editable": {
                    if (!(this.component instanceof JTextComponent)) break;
                    ((JTextComponent)this.component).setEditable(model.isEditable());
                    break;
                }
            }
        }
    }

    private static final class FocusLostHandler
    extends FocusAdapter {
        private FocusLostHandler() {
        }

        @Override
        public void focusLost(FocusEvent evt) {
            if (!evt.isTemporary()) {
                FOCUS_LOST_TRIGGER.triggerCommit();
            }
        }
    }

    private static final class NullElement {
        private final String text;

        NullElement(String text) {
            this.text = Preconditions.checkNotBlank(text, "The %s must not be null, empty, or whitespace.", "text");
        }

        public String toString() {
            return this.text;
        }
    }

    private static final class NullElementComboBoxModel<E>
    implements ComboBoxModel<Object> {
        private final ComboBoxModel<E> delegate;
        private final Object nullElement;

        NullElementComboBoxModel(ComboBoxModel<E> delegate, Object nullElement) {
            this.delegate = Preconditions.checkNotNull(delegate, "The %s must not be null.", "wrapped ComboBoxModel");
            this.nullElement = Preconditions.checkNotNull(nullElement, "The %s must not be null.", "null element");
        }

        @Override
        public int getSize() {
            return this.delegate.getSize() + 1;
        }

        @Override
        public Object getElementAt(int index) {
            return index == 0 ? this.nullElement : this.delegate.getElementAt(index - 1);
        }

        @Override
        public Object getSelectedItem() {
            Object selected = this.delegate.getSelectedItem();
            return selected == null ? this.nullElement : selected;
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.delegate.setSelectedItem(anItem != this.nullElement ? anItem : null);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.delegate.addListDataListener(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.delegate.removeListDataListener(l);
        }
    }

    private static final class NullElementComboBoxRenderer<E>
    extends DefaultListCellRenderer {
        private final ListCellRenderer<E> delegate;
        private final NullElement nullElement;

        NullElementComboBoxRenderer(ListCellRenderer<E> delegate, NullElement nullElement) {
            this.delegate = Preconditions.checkNotNull(delegate, "The %s must not be null.", "wrapped ListCellRenderer");
            this.nullElement = Preconditions.checkNotNull(nullElement, "The %s must not be null.", "null element");
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == this.nullElement) {
                return super.getListCellRendererComponent(list, this.nullElement, index, isSelected, cellHasFocus);
            }
            return this.delegate.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }

    private static final class SelectedItemChangeHandler<E>
    implements ItemListener {
        private final JComboBox<E> comboBox;
        private final ValueModel valueModel;

        private SelectedItemChangeHandler(JComboBox<E> comboBox, ValueModel valueModel) {
            this.comboBox = comboBox;
            this.valueModel = valueModel;
        }

        @Override
        public void itemStateChanged(ItemEvent evt) {
            if (evt.getStateChange() != 1) {
                return;
            }
            Object selectedItem = this.comboBox.getModel().getSelectedItem();
            Object selectedValue = selectedItem instanceof NullElement ? null : selectedItem;
            this.valueModel.setValue(selectedValue);
        }
    }

    private static final class WeakPropertyChangeSupport
    extends PropertyChangeSupport {
        static final ReferenceQueue<PropertyChangeListener> QUEUE = new ReferenceQueue();

        WeakPropertyChangeSupport(Object sourceBean) {
            super(sourceBean);
        }

        @Override
        public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
            if (listener == null) {
                return;
            }
            if (listener instanceof PropertyChangeListenerProxy) {
                PropertyChangeListenerProxy proxy = (PropertyChangeListenerProxy)listener;
                this.addPropertyChangeListener(proxy.getPropertyName(), (PropertyChangeListener)proxy.getListener());
            } else {
                super.addPropertyChangeListener(new WeakPropertyChangeListener(listener));
            }
        }

        @Override
        public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            if (listener == null) {
                return;
            }
            super.addPropertyChangeListener(propertyName, new WeakPropertyChangeListener(propertyName, listener));
        }

        @Override
        public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
            if (listener == null) {
                return;
            }
            if (listener instanceof PropertyChangeListenerProxy) {
                PropertyChangeListenerProxy proxy = (PropertyChangeListenerProxy)listener;
                this.removePropertyChangeListener(proxy.getPropertyName(), (PropertyChangeListener)proxy.getListener());
                return;
            }
            PropertyChangeListener[] listeners = this.getPropertyChangeListeners();
            for (int i = listeners.length - 1; i >= 0; --i) {
                WeakPropertyChangeListener wpcl;
                if (listeners[i] instanceof PropertyChangeListenerProxy || (wpcl = (WeakPropertyChangeListener)listeners[i]).get() != listener) continue;
                super.removePropertyChangeListener(wpcl);
                break;
            }
        }

        @Override
        public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            if (listener == null) {
                return;
            }
            PropertyChangeListener[] listeners = this.getPropertyChangeListeners(propertyName);
            for (int i = listeners.length - 1; i >= 0; --i) {
                WeakPropertyChangeListener wpcl = (WeakPropertyChangeListener)listeners[i];
                if (wpcl.get() != listener) continue;
                super.removePropertyChangeListener(propertyName, wpcl);
                break;
            }
        }

        @Override
        public void firePropertyChange(PropertyChangeEvent evt) {
            WeakPropertyChangeSupport.cleanUp();
            super.firePropertyChange(evt);
        }

        @Override
        public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            WeakPropertyChangeSupport.cleanUp();
            super.firePropertyChange(propertyName, oldValue, newValue);
        }

        private static void cleanUp() {
            WeakPropertyChangeListener wpcl;
            while ((wpcl = (WeakPropertyChangeListener)QUEUE.poll()) != null) {
                wpcl.removeListener();
            }
        }

        void removeWeakPropertyChangeListener(WeakPropertyChangeListener l) {
            if (l.propertyName == null) {
                super.removePropertyChangeListener(l);
            } else {
                super.removePropertyChangeListener(l.propertyName, l);
            }
        }

        private final class WeakPropertyChangeListener
        extends WeakReference<PropertyChangeListener>
        implements PropertyChangeListener {
            final String propertyName;

            private WeakPropertyChangeListener(PropertyChangeListener delegate) {
                this(null, delegate);
            }

            private WeakPropertyChangeListener(String propertyName, PropertyChangeListener delegate) {
                super(delegate, QUEUE);
                this.propertyName = propertyName;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PropertyChangeListener delegate = (PropertyChangeListener)this.get();
                if (delegate != null) {
                    delegate.propertyChange(evt);
                }
            }

            void removeListener() {
                WeakPropertyChangeSupport.this.removeWeakPropertyChangeListener(this);
            }
        }
    }

    private static final class WeakTrigger
    implements ValueModel {
        private final transient WeakPropertyChangeSupport changeSupport = new WeakPropertyChangeSupport(this);
        private Boolean value = null;

        WeakTrigger() {
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public void setValue(Object newValue) {
            Preconditions.checkArgument(newValue == null || newValue instanceof Boolean, "Trigger values must be of type Boolean.");
            Boolean oldValue = this.value;
            this.value = (Boolean)newValue;
            this.fireValueChange(oldValue, newValue);
        }

        @Override
        public void addValueChangeListener(PropertyChangeListener listener) {
            if (listener == null) {
                return;
            }
            this.changeSupport.addPropertyChangeListener("value", listener);
        }

        @Override
        public void removeValueChangeListener(PropertyChangeListener listener) {
            if (listener == null) {
                return;
            }
            this.changeSupport.removePropertyChangeListener("value", listener);
        }

        private void fireValueChange(Object oldValue, Object newValue) {
            this.changeSupport.firePropertyChange("value", oldValue, newValue);
        }

        void triggerCommit() {
            if (Boolean.TRUE.equals(this.getValue())) {
                this.setValue(null);
            }
            this.setValue(Boolean.TRUE);
        }

        void triggerFlush() {
            if (Boolean.FALSE.equals(this.getValue())) {
                this.setValue(null);
            }
            this.setValue(Boolean.FALSE);
        }
    }
}

