/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.application;

import com.jgoodies.application.ResourceMap;
import com.jgoodies.application.internal.Exceptions;
import com.jgoodies.common.base.Preconditions;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.IllegalFormatException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;

public abstract class AbstractResourceMap
implements ResourceMap {
    private final ResourceMap parent;
    private final String baseName;
    private final ClassLoader classLoader;

    public AbstractResourceMap(ResourceMap parent, String baseName, ClassLoader classLoader) {
        Preconditions.checkNotNull(baseName, "The %s must not be null.", "resource bundle base name");
        Preconditions.checkNotNull(classLoader, "The %s must not be null.", "class loader");
        this.parent = parent;
        this.baseName = baseName;
        this.classLoader = classLoader;
    }

    @Override
    public final ResourceMap getParent() {
        return this.parent;
    }

    @Override
    public final String getBaseName() {
        return this.baseName;
    }

    @Override
    public final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public final String resolvePath(String path) {
        if (path == null) {
            return path;
        }
        return path.startsWith("/") ? path.substring(1) : this.getResourceParentPath() + path;
    }

    @Override
    public abstract <T> T getObject(String var1, Class<T> var2);

    @Override
    public abstract <T> T getObject(ResourceMap var1, String var2, Class<T> var3);

    @Override
    public final boolean getBoolean(String key) {
        return this.getObject(key, Boolean.class);
    }

    @Override
    public final byte getByte(String key) {
        return this.getObject(key, Byte.class);
    }

    @Override
    public final Calendar getCalendar(String key) {
        return this.getObject(key, Calendar.class);
    }

    @Override
    public final char getCharacter(String key) {
        return this.getObject(key, Character.class).charValue();
    }

    @Override
    public final Color getColor(String key) {
        return this.getObject(key, Color.class);
    }

    @Override
    public final Date getDate(String key) {
        return this.getObject(key, Date.class);
    }

    @Override
    public final LocalDate getLocalDate(String key) {
        return this.getObject(key, LocalDate.class);
    }

    @Override
    public final Dimension getDimension(String key) {
        return this.getObject(key, Dimension.class);
    }

    @Override
    public final double getDouble(String key) {
        return this.getObject(key, Double.class);
    }

    @Override
    public final EmptyBorder getEmptyBorder(String key) {
        return this.getObject(key, EmptyBorder.class);
    }

    @Override
    public final File getFile(String key) {
        return this.getObject(key, File.class);
    }

    @Override
    public final float getFloat(String key) {
        return this.getObject(key, Float.class).floatValue();
    }

    @Override
    public final Font getFont(String key) {
        return this.getObject(key, Font.class);
    }

    @Override
    public final Icon getIcon(String key) {
        return this.getObject(key, Icon.class);
    }

    @Override
    public final Image getImage(String key) {
        return this.getObject(key, Image.class);
    }

    @Override
    public final ImageIcon getImageIcon(String key) {
        return this.getObject(key, ImageIcon.class);
    }

    @Override
    public final Insets getInsets(String key) {
        return this.getObject(key, Insets.class);
    }

    @Override
    public final int getInt(String key) {
        return this.getObject(key, Integer.class);
    }

    @Override
    public final KeyStroke getKeyStroke(String key) {
        return this.getObject(key, KeyStroke.class);
    }

    @Override
    public final long getLong(String key) {
        return this.getObject(key, Long.class);
    }

    @Override
    public final MessageFormat getMessageFormat(String key) {
        return this.getObject(key, MessageFormat.class);
    }

    @Override
    public final Point getPoint(String key) {
        return this.getObject(key, Point.class);
    }

    @Override
    public final Rectangle getRectangle(String key) {
        return this.getObject(key, Rectangle.class);
    }

    @Override
    public final short getShort(String key) {
        return this.getObject(key, Short.class);
    }

    @Override
    public final String getString(String key, Object ... args) {
        String str = this.getObject(key, String.class);
        if (args == null || args.length == 0) {
            return str;
        }
        try {
            return String.format(str, args);
        }
        catch (IllegalFormatException ex) {
            throw new Exceptions.ResourceFormatException(this, key, str, ex);
        }
    }

    @Override
    public final URI getURI(String key) {
        return this.getObject(key, URI.class);
    }

    @Override
    public final URL getURL(String key) {
        return this.getObject(key, URL.class);
    }

    @Override
    public final InputStream getURLAsStream(String key) {
        URL url = this.getURL(key);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }
}

