# Stefan Achatz 2012
#
# Tries to find libnotify and sets following variables according to found capabilities:
#
# NOTIFY_FOUND
# NOTIFY_INCLUDE_DIRS
# NOTIFY_LIBRARIES
# HAVE_NOTIFY_0_7

FIND_PACKAGE(PkgConfig)
PKG_CHECK_MODULES(PKG_NOTIFY libnotify)

FIND_PATH(NOTIFY_INCLUDE_DIRS libnotify/notify.h
  HINTS
    ${PKG_NOTIFY_INCLUDE_DIRS}
    ${PKG_NOTIFY_INCLUDEDIR}
)

FIND_LIBRARY(NOTIFY_LIBRARIES notify
  HINTS ${PKG_NOTIFY_LIBRARY_DIRS}
)

IF(NOTIFY_LIBRARIES AND NOTIFY_INCLUDE_DIRS)
  SET(NOTIFY_FOUND true)
ENDIF()

IF(NOTIFY_FIND_REQUIRED AND NOT NOTIFY_FOUND)
  MESSAGE(FATAL_ERROR "Could not find NOTIFY")
ENDIF()

FIND_PACKAGE(GTK)

IF(NOTIFY_FOUND AND GTK_FOUND)
  SET(INCLUDE_DIRS ${GTK_INCLUDE_DIRS} ${NOTIFY_INCLUDE_DIRS})
  SET(LINK_LIBS ${GTK_LIBRARIES} ${NOTIFY_LIBRARIES})

  TRY_COMPILE(HAVE_NOTIFY_0_7
    "${CMAKE_BINARY_DIR}"
    "${CMAKE_SOURCE_DIR}/cmake_modules/test_notify_0_7.c"
    CMAKE_FLAGS
      "-DINCLUDE_DIRECTORIES:STRING=${INCLUDE_DIRS}"
      "-DLINK_LIBRARIES:STRING=${LINK_LIBS}"
    OUTPUT_VARIABLE OUTPUT
  )
ENDIF()

