/***************************************************************************
 *   crengine-ng                                                           *
 *   Copyright (C) 2013 Vadim Lopatin <coolreader.org@gmail.com>           *
 *   Copyright (C) 2020 Aleksey Chernov <valexlin@gmail.com>               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU General Public License           *
 *   as published by the Free Software Foundation; either version 2        *
 *   of the License, or (at your option) any later version.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,            *
 *   MA 02110-1301, USA.                                                   *
 ***************************************************************************/

/**
 * \file lvassetcontainerfactory.h
 * \brief factory to handle filesystem access for paths started with ASSET_PATH_PREFIX (@ sign)
 */

#ifndef __LVASSETCONTAINERFACTORY_H_INCLUDED__
#define __LVASSETCONTAINERFACTORY_H_INCLUDED__

#include <lvstream.h>
#include <lvcontainer.h>

/// factory to handle filesystem access for paths started with ASSET_PATH_PREFIX (@ sign)
class LVAssetContainerFactory
{
public:
    virtual LVContainerRef openAssetContainer(lString32 path) = 0;
    virtual LVStreamRef openAssetStream(lString32 path) = 0;
    LVAssetContainerFactory() { }
    virtual ~LVAssetContainerFactory() { }
};

#endif // __LVASSETCONTAINERFACTORY_H_INCLUDED__
