/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.format;

import java.util.regex.Pattern;
import org.rundeck.client.tool.format.NiceFormatter;
import org.rundeck.client.tool.format.OutputFormatter;
import org.rundeck.client.tool.format.ToStringFormatter;

public class PrefixFormatter
implements OutputFormatter {
    final String prefix;
    final OutputFormatter base;
    private boolean truncateFinalNewline = true;

    public PrefixFormatter(String prefix) {
        this.prefix = prefix;
        this.base = new ToStringFormatter();
    }

    public PrefixFormatter(String prefix, OutputFormatter base) {
        this.prefix = prefix;
        this.base = base;
    }

    @Override
    public String format(Object o) {
        return this.addPrefix(this.prefix, null != this.base ? this.base.format(o) : o.toString());
    }

    private String addPrefix(String prefix, String text) {
        StringBuilder sb = new StringBuilder();
        this.indent(text, sb, true, prefix);
        return sb.toString();
    }

    private void indent(String text, StringBuilder sb, boolean firstLine, String prefix) {
        if (text.contains(NiceFormatter.NL)) {
            String[] split = text.split(Pattern.quote(NiceFormatter.NL), -1);
            int length = split.length;
            if (text.endsWith(NiceFormatter.NL)) {
                --length;
            }
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    sb.append(NiceFormatter.NL);
                }
                sb.append(prefix).append(split[i]);
            }
            if (text.endsWith(NiceFormatter.NL) && !this.isTruncateFinalNewline()) {
                sb.append(NiceFormatter.NL);
            }
        } else {
            sb.append(prefix).append(text);
        }
    }

    @Override
    public OutputFormatter withBase(OutputFormatter base) {
        return new PrefixFormatter(this.prefix, base);
    }

    public boolean isTruncateFinalNewline() {
        return this.truncateFinalNewline;
    }

    public void setTruncateFinalNewline(boolean truncateFinalNewline) {
        this.truncateFinalNewline = truncateFinalNewline;
    }
}

