/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.format;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.rundeck.client.tool.format.Formatable;
import org.rundeck.client.tool.format.OutputFormatter;

public abstract class BaseDataOutputFormatter
implements OutputFormatter {
    OutputFormatter base;
    Function<Object, Optional<Formatable>> dataFormatter;

    public BaseDataOutputFormatter() {
    }

    public BaseDataOutputFormatter(Function<Object, Optional<Formatable>> dataFormatter) {
        this.dataFormatter = dataFormatter;
    }

    public BaseDataOutputFormatter(OutputFormatter base) {
        this.base = base;
    }

    public BaseDataOutputFormatter(OutputFormatter base, Function<Object, Optional<Formatable>> dataFormatter) {
        this.base = base;
        this.dataFormatter = dataFormatter;
    }

    @Override
    public String format(Object o) {
        Formatable value;
        if (o instanceof Formatable) {
            value = (Formatable)o;
        } else {
            Formatable formatable = value = null != this.dataFormatter ? (Formatable)this.dataFormatter.apply(o).orElse(null) : null;
        }
        if (value != null) {
            List<?> objects = value.asList();
            if (null != objects) {
                return this.formatList(objects);
            }
            Map<?, ?> map = value.asMap();
            if (null != map) {
                return this.formatMap(map);
            }
        } else if (this.canFormatObject(o)) {
            return this.formatObject(o);
        }
        return null != this.base ? this.base.format(o) : o.toString();
    }

    protected String formatMap(Map value) {
        return this.formatObject(value);
    }

    protected String formatList(List value) {
        return this.formatObject(value);
    }

    @Override
    public OutputFormatter withBase(OutputFormatter base) {
        return this.withBase(this.dataFormatter, base);
    }

    protected abstract OutputFormatter withBase(Function<Object, Optional<Formatable>> var1, OutputFormatter var2);

    protected abstract boolean canFormatObject(Object var1);

    protected abstract String formatObject(Object var1);
}

