/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.commands;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.rundeck.client.api.model.ApiToken;
import org.rundeck.client.api.model.CreateToken;
import org.rundeck.client.tool.InputError;
import org.rundeck.client.tool.extension.BaseCommand;
import org.rundeck.client.tool.options.OutputFormat;
import org.rundeck.client.tool.options.TokenFormatOption;
import org.rundeck.client.tool.options.VerboseOption;
import org.rundeck.client.util.Format;
import picocli.CommandLine;

@CommandLine.Command(description={"Create, and manage tokens"}, name="tokens")
public class Tokens
extends BaseCommand {
    @CommandLine.Command(description={"Create a token for a user"})
    public ApiToken create(@CommandLine.Mixin CreateOptions options) throws IOException, InputError {
        ApiToken apiToken;
        boolean v19 = this.getRdTool().getClient().minApiVersion(19);
        if (v19) {
            if (!options.isRoles()) {
                throw new InputError("--roles/-r is required for API v19");
            }
            apiToken = (ApiToken)this.apiCall(api -> api.createToken(new CreateToken(options.getUser(), options.getRoles(), options.getDuration())));
        } else {
            if (options.isRoles() || options.isDuration()) {
                throw new InputError("--roles/-r and --duration/-d are not supported for API v18 and earlier");
            }
            apiToken = (ApiToken)this.apiCall(api -> api.createToken(options.getUser()));
        }
        this.getRdOutput().info(String.format("API Token created: %s", apiToken.getId()));
        this.getRdOutput().output(this.formatTokenOutput(v19, options, ApiToken::toMap, true).apply(apiToken));
        return apiToken;
    }

    @CommandLine.Command(description={"List tokens for a user"})
    public List<ApiToken> list(@CommandLine.Mixin ListOptions options) throws IOException, InputError {
        List tokens = (List)this.apiCall(api -> api.listTokens(options.getUser()));
        this.getRdOutput().info(String.format("API Tokens for %s:", options.getUser()));
        this.getRdOutput().output(tokens.stream().map(this.formatTokenOutput(this.getRdTool().getClient().minApiVersion(19), options, ApiToken::toMap, false)).collect(Collectors.toList()));
        return tokens;
    }

    private Function<? super ApiToken, ?> formatTokenOutput(boolean v19, OutputFormat options, Function<ApiToken, Map<?, ?>> toMap, boolean reveal) {
        if (options.isOutputFormat()) {
            return Format.formatter(options.getOutputFormat(), toMap, "%", "");
        }
        if (options.isVerbose()) {
            return toMap;
        }
        if (v19) {
            return reveal ? ApiToken::getToken : ApiToken::getId;
        }
        return reveal ? ApiToken::getIdOrToken : ApiToken::getTruncatedIdOrToken;
    }

    @CommandLine.Command(description={"Reveal token value for an ID (API v19+) [@|red DEPRECATED|@: use @|bold rd tokens info|@]"}, hidden=true)
    public void reveal(@CommandLine.Mixin RevealOption options) throws IOException, InputError {
        this.getRdOutput().info("@|faint rd tokens reveal is deprecated, use: rd tokens info|@");
        this.getInfo(options, true);
    }

    @CommandLine.Command(description={"Get token info for an ID (API v19+)"})
    public void info(@CommandLine.Mixin RevealOption options) throws IOException, InputError {
        this.getInfo(options, false);
    }

    private void getInfo(@CommandLine.Mixin RevealOption options, boolean reveal) throws IOException, InputError {
        ApiToken token = (ApiToken)this.apiCall(api -> api.getToken(options.getId()));
        this.getRdOutput().info(String.format("API Token %s:", options.getId()));
        this.getRdOutput().output(this.formatTokenOutput(true, options, ApiToken::toMap, reveal).apply(token));
    }

    @CommandLine.Command(description={"Delete a token"})
    public void delete(@CommandLine.Mixin DeleteOptions options) throws IOException, InputError {
        String tokenId = options.getId();
        if (tokenId == null && (tokenId = options.getToken()) != null) {
            this.getRdOutput().warning("--token is deprecated use --id");
        }
        if (tokenId == null) {
            throw new InputError("Missing required option: '--id=<id>'");
        }
        String id = tokenId;
        Void aVoid = (Void)this.apiCall(api -> api.deleteToken(id));
        this.getRdOutput().info("Token deleted.");
    }

    static class DeleteOptions {
        @CommandLine.Option(names={"--token", "-t"}, description={"API token [deprecated, use --id]"}, hidden=true)
        private String token;
        @CommandLine.Option(names={"--id", "-i"}, description={"Token ID"})
        private String id;

        DeleteOptions() {
        }

        public String getToken() {
            return this.token;
        }

        public String getId() {
            return this.id;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    static class RevealOption
    extends VerboseOption
    implements OutputFormat {
        @CommandLine.Option(names={"--id", "-i"}, description={"Token ID"}, required=true)
        private String id;
        @CommandLine.Option(names={"-%", "--outformat"}, description={"Output format specifier for Token info. You can use \"%%key\" where key is one of: token, id, user, creator, roles, expiration, expired. E.g. \"%%id:%%token\""})
        private String outputFormat;

        RevealOption() {
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getOutputFormat() {
            return this.outputFormat;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }
    }

    static class ListOptions
    extends TokenFormatOption {
        @CommandLine.Option(names={"--user", "-u"}, description={"user name"}, required=true)
        private String user;

        ListOptions() {
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }
    }

    static class CreateOptions
    extends TokenFormatOption {
        @CommandLine.Option(names={"--user", "-u"}, description={"user name"}, required=true)
        String user;
        @CommandLine.Option(names={"--duration", "-d"}, description={"Token duration, in the form '#[ydhms]`, e.g. '2y','5h','24h30m'"})
        String duration;
        @CommandLine.Option(names={"--roles", "-r"}, arity="1..*", description={"List of roles to set for the token, space separated (api v19+)"})
        List<String> roles;

        CreateOptions() {
        }

        boolean isDuration() {
            return this.duration != null;
        }

        boolean isRoles() {
            return this.roles != null && !this.roles.isEmpty();
        }

        public String getUser() {
            return this.user;
        }

        public String getDuration() {
            return this.duration;
        }

        public List<String> getRoles() {
            return this.roles;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public void setDuration(String duration) {
            this.duration = duration;
        }

        public void setRoles(List<String> roles) {
            this.roles = roles;
        }
    }
}

