/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.commands;

import java.io.Console;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.rundeck.client.api.RundeckApi;
import org.rundeck.client.api.model.ProjectItem;
import org.rundeck.client.tool.InputError;
import org.rundeck.client.tool.commands.projects.ACLs;
import org.rundeck.client.tool.commands.projects.Archives;
import org.rundeck.client.tool.commands.projects.Configure;
import org.rundeck.client.tool.commands.projects.Readme;
import org.rundeck.client.tool.commands.projects.SCM;
import org.rundeck.client.tool.extension.BaseCommand;
import org.rundeck.client.tool.options.ProjectListFormatOptions;
import org.rundeck.client.tool.options.ProjectNameOptions;
import org.rundeck.client.tool.options.UnparsedConfigOptions;
import org.rundeck.client.tool.options.VerboseOption;
import org.rundeck.client.util.Format;
import picocli.CommandLine;

@CommandLine.Command(description={"List and manage projects."}, name="projects", subcommands={ACLs.class, SCM.class, Readme.class, Configure.class, Archives.class})
public class Projects
extends BaseCommand {
    @CommandLine.Command(description={"List all projects."})
    public void list(@CommandLine.Mixin ProjectListFormatOptions formatOptions, @CommandLine.Mixin VerboseOption verboseOption) throws IOException, InputError {
        List body = (List)this.apiCall(RundeckApi::listProjects);
        if (formatOptions.getOutputFormat() == null) {
            this.getRdOutput().info(String.format("%d Projects:%n", body.size()));
        }
        this.outputProjectList(body, formatOptions, verboseOption, ProjectItem::getName, ProjectItem::toMap);
    }

    @CommandLine.Command(description={"Get info about a project."})
    public void info(@CommandLine.Mixin ProjectNameOptions opts, @CommandLine.Mixin ProjectListFormatOptions formatOptions, @CommandLine.Mixin VerboseOption verboseOption) throws IOException, InputError {
        String project = this.getRdTool().projectOrEnv(opts);
        ProjectItem body = (ProjectItem)this.apiCall(api -> api.getProjectInfo(project));
        this.outputProjectList(Collections.singletonList(body), formatOptions, verboseOption, ProjectItem::toBasicMap, ProjectItem::toMap);
    }

    private void outputProjectList(List<ProjectItem> body, ProjectListFormatOptions formatOptions, VerboseOption verboseOption, Function<ProjectItem, Object> basicOutput, Function<ProjectItem, Map<Object, Object>> verboseOutput) {
        if (verboseOption.isVerbose()) {
            this.getRdOutput().output(body.stream().map(verboseOutput).collect(Collectors.toList()));
            return;
        }
        Function<ProjectItem, Object> outformat = formatOptions.getOutputFormat() != null ? Format.formatter(formatOptions.getOutputFormat(), ProjectItem::toMap, "%", "") : basicOutput;
        this.getRdOutput().output(body.stream().map(outformat).collect(Collectors.toList()));
    }

    @CommandLine.Command(description={"Delete a project"})
    public int delete(@CommandLine.Mixin ProjectDelete options, @CommandLine.Mixin ProjectListFormatOptions formatOptions, @CommandLine.Mixin VerboseOption verboseOption) throws IOException, InputError {
        String project = this.getRdTool().projectOrEnv(options);
        if (!options.isConfirm()) {
            Console console = System.console();
            String s = "n";
            if (null != console) {
                s = console.readLine("Really delete project %s? (y/N) ", project);
            } else {
                this.getRdOutput().warning("No console input available, and --confirm/-y was not set.");
            }
            if (!"y".equals(s)) {
                this.getRdOutput().warning(String.format("Not deleting project %s.", project));
                return 2;
            }
        }
        this.apiCall(api -> api.deleteProject(project));
        this.getRdOutput().info(String.format("Project was deleted: %s%n", project));
        return 0;
    }

    @CommandLine.Command(description={"Create a project."})
    public void create(@CommandLine.Mixin ProjectNameOptions nameOptions, @CommandLine.Mixin Configure.ConfigFileOptions configFileOptions, @CommandLine.Mixin UnparsedConfigOptions options) throws IOException, InputError {
        Map<String, String> config = Configure.loadConfig(configFileOptions, options, false);
        ProjectItem project = new ProjectItem();
        project.setName(this.getRdTool().projectOrEnv(nameOptions));
        project.setConfig(config);
        ProjectItem body = (ProjectItem)this.apiCall(api -> api.createProject(project));
        this.getRdOutput().info(String.format("Created project: \n\t%s%n", body.toBasicString()));
    }

    static class ProjectDelete
    extends ProjectNameOptions {
        @CommandLine.Option(names={"--confirm", "-y"}, description={"Force confirmation of delete request."})
        boolean confirm;

        ProjectDelete() {
        }

        public boolean isConfirm() {
            return this.confirm;
        }

        public void setConfirm(boolean confirm) {
            this.confirm = confirm;
        }
    }
}

