/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.util.Objects;
import java.util.function.Predicate;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.streams.Predicates;
import net.sf.saxon.s9api.streams.Steps;
import org.dita.dost.util.Job;
import org.dita.dost.util.XMLUtils;
import org.w3c.dom.Element;

public class DitaUtils {
    public static boolean isDitaFormat(Element elem) {
        String format = elem.getAttribute("format");
        return DitaUtils.isDitaFormat(format);
    }

    public static boolean isDitaFormat(Job.FileInfo fi) {
        return DitaUtils.isDitaFormat(fi.format);
    }

    public static boolean isDitaFormat(String format) {
        return format == null || format.isEmpty() || format.equals("dita");
    }

    public static boolean isLocalScope(Element elem) {
        return DitaUtils.isLocalScope(XMLUtils.getCascadeValue(elem, "scope"));
    }

    public static boolean isLocalScope(String scope) {
        return scope == null || scope.isEmpty() || scope.equals("local");
    }

    public static boolean isExternalScope(String scope) {
        return Objects.equals(scope, "external");
    }

    public static boolean isExternalScope(Element elem) {
        return DitaUtils.isExternalScope(XMLUtils.getCascadeValue(elem, "scope"));
    }

    public static boolean isNormalProcessRole(Element elem) {
        return DitaUtils.isNormalProcessRole(XMLUtils.getCascadeValue(elem, "processing-role"));
    }

    public static boolean isNormalProcessRole(String processingRole) {
        return processingRole == null || processingRole.equals("normal");
    }

    public static boolean isResourceOnly(String processingRole) {
        return Objects.equals(processingRole, "resource-only");
    }

    public static boolean isResourceOnly(XdmNode elem) {
        return elem.select(Steps.ancestorOrSelf((Predicate)Predicates.hasAttribute((String)"processing-role")).first().where(Predicates.attributeEq((String)"processing-role", (String)"resource-only"))).exists();
    }

    public static Float getDitaVersion(Element topic) {
        String ditaVersion = topic.getAttributeNS("http://dita.oasis-open.org/architecture/2005/", "DITAArchVersion");
        if (!ditaVersion.isEmpty()) {
            try {
                return Float.valueOf(ditaVersion);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }
}

