--
-- SQL script to create the trigger(s) enabling the load API for
-- SGLD_DB_Releases.
--
-- Scaffold auto-generated by gen-api.pl.
--
--
-- $Id: DB_Releases.trg,v 1.1.1.1 2002-08-13 19:51:10 lapp Exp $
--

--
-- Copyright 2002-2003 Genomics Institute of the Novartis Research Foundation
-- Copyright 2002-2008 Hilmar Lapp
-- 
--  This file is part of BioSQL.
--
--  BioSQL is free software: you can redistribute it and/or modify it
--  under the terms of the GNU Lesser General Public License as
--  published by the Free Software Foundation, either version 3 of the
--  License, or (at your option) any later version.
--
--  BioSQL is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU Lesser General Public License for more details.
--
--  You should have received a copy of the GNU Lesser General Public License
--  along with BioSQL. If not, see <http://www.gnu.org/licenses/>.
--

CREATE OR REPLACE TRIGGER BIUR_DB_Releases
       INSTEAD OF INSERT OR UPDATE
       ON SGLD_DB_Releases
       REFERENCING NEW AS new OLD AS old
       FOR EACH ROW
DECLARE
	pk		SG_DB_RELEASE.OID%TYPE DEFAULT :new.Rel_Oid;
	do_DML		INTEGER DEFAULT BSStd.DML_NO;
BEGIN
	IF INSERTING THEN
		do_DML := BSStd.DML_I;
	ELSE
		-- this is an update
		do_DML := BSStd.DML_UI;
	END IF;
	-- do insert or update (depending on whether it exists or not)
	pk := Rel.get_oid(
			Rel_OID => pk,
		        Rel_VERSION => Rel_VERSION,
			Rel_REL_DATE => Rel_REL_DATE,
			Rel_DB_OID => DB_OID_,
			do_DML             => do_DML);
END;
/
