-- -*-Sql-*- mode (to keep my emacs happy)
--
-- API Package Body for Bioentry_Qualifier_Assoc.
--
-- Scaffold auto-generated by gen-api.pl. gen-api.pl is
-- Copyright 2002-2003 Genomics Institute of the Novartis Research Foundation
-- Copyright 2002-2008 Hilmar Lapp
-- 
--  This file is part of BioSQL.
--
--  BioSQL is free software: you can redistribute it and/or modify it
--  under the terms of the GNU Lesser General Public License as
--  published by the Free Software Foundation, either version 3 of the
--  License, or (at your option) any later version.
--
--  BioSQL is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU Lesser General Public License for more details.
--
--  You should have received a copy of the GNU Lesser General Public License
--  along with BioSQL. If not, see <http://www.gnu.org/licenses/>.
--

CREATE OR REPLACE
PACKAGE BODY EntTrmA IS

CURSOR EntTrmA_c (
		EntTrmA_ENT_OID	IN SG_BIOENTRY_QUALIFIER_ASSOC.ENT_OID%TYPE,
		EntTrmA_TRM_OID	IN SG_BIOENTRY_QUALIFIER_ASSOC.TRM_OID%TYPE,
		EntTrmA_RANK	IN SG_BIOENTRY_QUALIFIER_ASSOC.RANK%TYPE)
RETURN SG_BIOENTRY_QUALIFIER_ASSOC%ROWTYPE IS
	SELECT t.* FROM SG_BIOENTRY_QUALIFIER_ASSOC t
	WHERE
		Ent_Oid = EntTrmA_ENT_OID
	AND     Trm_Oid = EntTrmA_TRM_OID
	AND	Rank	= EntTrmA_Rank
	;

FUNCTION get_oid(
		ENT_OID	IN SG_BIOENTRY_QUALIFIER_ASSOC.ENT_OID%TYPE DEFAULT NULL,
		TRM_OID	IN SG_BIOENTRY_QUALIFIER_ASSOC.TRM_OID%TYPE DEFAULT NULL,
		EntTrmA_VALUE	IN SG_BIOENTRY_QUALIFIER_ASSOC.VALUE%TYPE DEFAULT NULL,
		EntTrmA_RANK	IN SG_BIOENTRY_QUALIFIER_ASSOC.RANK%TYPE DEFAULT NULL,
		Trm_NAME	IN SG_TERM.NAME%TYPE DEFAULT NULL,
		ONT_OID	IN SG_TERM.ONT_OID%TYPE DEFAULT NULL,
		ONT_NAME	IN SG_ONTOLOGY.NAME%TYPE DEFAULT NULL,
		Trm_IDENTIFIER	IN SG_TERM.IDENTIFIER%TYPE DEFAULT NULL,
		Ent_IDENTIFIER	IN SG_BIOENTRY.IDENTIFIER%TYPE DEFAULT NULL,
		Ent_ACCESSION	IN SG_BIOENTRY.ACCESSION%TYPE DEFAULT NULL,
		Ent_VERSION	IN SG_BIOENTRY.VERSION%TYPE DEFAULT NULL,
		DB_OID		IN SG_BIOENTRY.DB_OID%TYPE DEFAULT NULL,
		DB_NAME		IN SG_BIODATABASE.NAME%TYPE DEFAULT NULL,
		DB_ACRONYM	IN SG_BIODATABASE.ACRONYM%TYPE DEFAULT NULL,
		do_DML		IN NUMBER DEFAULT BSStd.DML_NO)
RETURN INTEGER
IS
	pk	INTEGER DEFAULT NULL;
	EntTrmA_row EntTrmA_c%ROWTYPE;
	TRM_OID_	SG_TERM.OID%TYPE DEFAULT TRM_OID;
	ENT_OID_	SG_BIOENTRY.OID%TYPE DEFAULT ENT_OID;
BEGIN
	-- initialize
	-- look up SG_BIOENTRY
	IF (ENT_OID_ IS NULL) THEN
		ENT_OID_ := Ent.get_oid(
				Ent_ACCESSION => Ent_ACCESSION,
				Ent_VERSION => Ent_VERSION,
				Ent_IDENTIFIER => Ent_IDENTIFIER,
				DB_OID => DB_OID,
				DB_Name => DB_Name,
				DB_Acronym => DB_Acronym);
	END IF;
	-- look up SG_TERM
	IF (TRM_OID_ IS NULL) THEN
		TRM_OID_ := Trm.get_oid(
				Trm_NAME => Trm_NAME,
				ONT_OID => ONT_OID,
				ONT_NAME => ONT_NAME,
				Trm_IDENTIFIER => Trm_IDENTIFIER);
	END IF;
	-- look up
	FOR EntTrmA_row IN EntTrmA_c (ENT_OID_, TRM_OID_, EntTrmA_RANK) LOOP
        	pk := 1;
	END LOOP;
	-- insert/update if requested
	IF (pk IS NULL) AND 
	   ((do_DML = BSStd.DML_I) OR (do_DML = BSStd.DML_UI)) THEN
	    	-- look up foreign keys if not provided:
		-- look up SG_TERM successful?
		IF (TRM_OID_ IS NULL) THEN
			raise_application_error(-20101,
				'failed to look up Trm <' || Trm_NAME || '|' || ONT_OID || '|' || ONT_NAME || '|' || Trm_IDENTIFIER || '>');
		END IF;
		-- look up SG_BIOENTRY successful?
		IF (ENT_OID_ IS NULL) THEN
			raise_application_error(-20101,
				'failed to look up Ent <' || Ent_ACCESSION || '|' || Ent_VERSION || '|' || DB_OID || '|' || Ent_IDENTIFIER || '>');
		END IF;
	    	-- insert the record and obtain the primary key
	    	pk := do_insert(
		        ENT_OID => ENT_OID_,
		        TRM_OID => TRM_OID_,
			VALUE => EntTrmA_VALUE,
			RANK => EntTrmA_RANK);
	ELSIF (do_DML = BSStd.DML_U) OR (do_DML = BSStd.DML_UI) THEN
	        -- update the record (note that not provided FKs will not
		-- be changed nor looked up)
		do_update(
			EntTrmA_ENT_OID	=> ENT_OID_,
		        EntTrmA_TRM_OID => TRM_OID_,
			EntTrmA_VALUE => EntTrmA_VALUE,
			EntTrmA_RANK => EntTrmA_RANK);
	END IF;
	-- return the primary key
	RETURN pk;
END;

FUNCTION do_insert(
		ENT_OID	IN SG_BIOENTRY_QUALIFIER_ASSOC.ENT_OID%TYPE,
		TRM_OID	IN SG_BIOENTRY_QUALIFIER_ASSOC.TRM_OID%TYPE,
		VALUE	IN SG_BIOENTRY_QUALIFIER_ASSOC.VALUE%TYPE,
		RANK	IN SG_BIOENTRY_QUALIFIER_ASSOC.RANK%TYPE)
RETURN INTEGER
IS
BEGIN
	-- insert the record
	INSERT INTO SG_BIOENTRY_QUALIFIER_ASSOC (
		ENT_OID,
		TRM_OID,
		VALUE,
		RANK)
	VALUES (ENT_OID,
		TRM_OID,
		VALUE,
		RANK)
	;
	-- return TRUE
	RETURN 1;
END;

PROCEDURE do_update(
		EntTrmA_ENT_OID	IN SG_BIOENTRY_QUALIFIER_ASSOC.ENT_OID%TYPE,
		EntTrmA_TRM_OID	IN SG_BIOENTRY_QUALIFIER_ASSOC.TRM_OID%TYPE,
		EntTrmA_VALUE	IN SG_BIOENTRY_QUALIFIER_ASSOC.VALUE%TYPE,
		EntTrmA_RANK	IN SG_BIOENTRY_QUALIFIER_ASSOC.RANK%TYPE)
IS
BEGIN
	-- update the record (and leave attributes passed as NULL untouched)
	UPDATE SG_BIOENTRY_QUALIFIER_ASSOC
	SET
		VALUE = NVL(EntTrmA_VALUE, VALUE)
	WHERE ENT_OID = EntTrmA_ENT_OID
	AND   TRM_OID = EntTrmA_TRM_OID
	AND   RANK    = EntTrmA_RANK
	;
END;

END EntTrmA;
/




