/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.truth.Correspondence;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.Ordered;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectUtils;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MultimapSubject
extends Subject {
    private static final Ordered ALREADY_FAILED = () -> {};
    private final @Nullable Multimap<?, ?> actual;

    protected MultimapSubject(FailureMetadata metadata, @Nullable Multimap<?, ?> multimap) {
        this(metadata, multimap, (String)null);
    }

    MultimapSubject(FailureMetadata metadata, @Nullable Multimap<?, ?> multimap, @Nullable String typeDescription) {
        super(metadata, multimap, typeDescription);
        this.actual = multimap;
    }

    public final void isEmpty() {
        if (!((Multimap)Preconditions.checkNotNull(this.actual)).isEmpty()) {
            this.failWithActual(Fact.simpleFact("expected to be empty"), new Fact[0]);
        }
    }

    public final void isNotEmpty() {
        if (((Multimap)Preconditions.checkNotNull(this.actual)).isEmpty()) {
            this.failWithoutActual(Fact.simpleFact("expected not to be empty"), new Fact[0]);
        }
    }

    public final void hasSize(int expectedSize) {
        Preconditions.checkArgument((expectedSize >= 0 ? 1 : 0) != 0, (String)"expectedSize(%s) must be >= 0", (int)expectedSize);
        this.check("size()", new Object[0]).that(((Multimap)Preconditions.checkNotNull(this.actual)).size()).isEqualTo(expectedSize);
    }

    public final void containsKey(@Nullable Object key) {
        this.check("keySet()", new Object[0]).that(((Multimap)Preconditions.checkNotNull(this.actual)).keySet()).contains(key);
    }

    public final void doesNotContainKey(@Nullable Object key) {
        this.check("keySet()", new Object[0]).that(((Multimap)Preconditions.checkNotNull(this.actual)).keySet()).doesNotContain(key);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public final void containsEntry(@Nullable Object key, @Nullable Object value) {
        Preconditions.checkNotNull(this.actual);
        if (!this.actual.containsEntry(key, value)) {
             @Nullable @Nullable Map.Entry entry = Maps.immutableEntry((Object)key, (Object)value);
            @Nullable @Nullable ImmutableList entryList = ImmutableList.of((Object)entry);
            if (SubjectUtils.hasMatchingToStringPair(this.actual.entries(), entryList)) {
                this.failWithoutActual(Fact.fact("expected to contain entry", entry), Fact.fact("an instance of", SubjectUtils.objectToTypeName(entry)), Fact.simpleFact("but did not"), Fact.fact("though it did contain", SubjectUtils.countDuplicatesAndAddTypeInfo(SubjectUtils.retainMatchingToString(this.actual.entries(), entryList))), Fact.fact("full contents", this.actualCustomStringRepresentationForPackageMembersToCall()));
            } else if (this.actual.containsKey(key)) {
                this.failWithoutActual(Fact.fact("expected to contain entry", entry), Fact.simpleFact("but did not"), Fact.fact("though it did contain values with that key", this.actual.asMap().get(key)), Fact.fact("full contents", this.actualCustomStringRepresentationForPackageMembersToCall()));
            } else if (this.actual.containsValue(value)) {
                LinkedHashSet<@Nullable K> keys = new LinkedHashSet();
                for (Map.Entry actualEntry : this.actual.entries()) {
                    if (!Objects.equal(actualEntry.getValue(), (Object)value)) continue;
                    keys.add(actualEntry.getKey());
                }
                this.failWithoutActual(Fact.fact("expected to contain entry", entry), Fact.simpleFact("but did not"), Fact.fact("though it did contain keys with that value", keys), Fact.fact("full contents", this.actualCustomStringRepresentationForPackageMembersToCall()));
            } else {
                this.failWithActual("expected to contain entry", Maps.immutableEntry((Object)key, (Object)value));
            }
        }
    }

    public final void doesNotContainEntry(@Nullable Object key, @Nullable Object value) {
        this.checkNoNeedToDisplayBothValues("entries()", new Object[0]).that(((Multimap)Preconditions.checkNotNull(this.actual)).entries()).doesNotContain(Maps.immutableEntry((Object)key, (Object)value));
    }

    public IterableSubject valuesForKey(@Nullable Object key) {
        return this.check("valuesForKey(%s)", key).that(((Multimap)Preconditions.checkNotNull(this.actual)).get(key));
    }

    @Override
    public final void isEqualTo(@Nullable Object other) {
        boolean isEqual = Objects.equal(this.actual, (Object)other);
        if (isEqual) {
            return;
        }
        if (this.actual instanceof ListMultimap && other instanceof SetMultimap || this.actual instanceof SetMultimap && other instanceof ListMultimap) {
            String actualType = this.actual instanceof ListMultimap ? "ListMultimap" : "SetMultimap";
            String otherType = other instanceof ListMultimap ? "ListMultimap" : "SetMultimap";
            this.failWithoutActual(Fact.fact("expected", other), Fact.fact("an instance of", otherType), Fact.fact("but was", this.actualCustomStringRepresentationForPackageMembersToCall()), Fact.fact("an instance of", actualType), Fact.simpleFact(Strings.lenientFormat((String)"a %s cannot equal a %s if either is non-empty", (Object[])new Object[]{actualType, otherType})));
        } else if (this.actual instanceof ListMultimap) {
            this.containsExactlyEntriesIn((Multimap)Preconditions.checkNotNull((Object)other)).inOrder();
        } else if (this.actual instanceof SetMultimap) {
            this.containsExactlyEntriesIn((Multimap)Preconditions.checkNotNull((Object)other));
        } else {
            super.isEqualTo(other);
        }
    }

    @CanIgnoreReturnValue
    public final Ordered containsExactlyEntriesIn(Multimap<?, ?> expectedMultimap) {
        Preconditions.checkNotNull(expectedMultimap, (Object)"expectedMultimap");
        Preconditions.checkNotNull(this.actual);
        ListMultimap<?, ?> missing = MultimapSubject.difference(expectedMultimap, this.actual);
        ListMultimap<?, ?> extra = MultimapSubject.difference(this.actual, expectedMultimap);
        if (!missing.isEmpty()) {
            if (!extra.isEmpty()) {
                boolean addTypeInfo = SubjectUtils.hasMatchingToStringPair(missing.entries(), extra.entries());
                String missingDisplay = addTypeInfo ? SubjectUtils.countDuplicatesAndAddTypeInfo(MultimapSubject.annotateEmptyStringsMultimap(missing).entries()) : MultimapSubject.countDuplicatesMultimap(MultimapSubject.annotateEmptyStringsMultimap(missing));
                String extraDisplay = addTypeInfo ? SubjectUtils.countDuplicatesAndAddTypeInfo(MultimapSubject.annotateEmptyStringsMultimap(extra).entries()) : MultimapSubject.countDuplicatesMultimap(MultimapSubject.annotateEmptyStringsMultimap(extra));
                this.failWithActual(Fact.fact("missing", missingDisplay), Fact.fact("unexpected", extraDisplay), Fact.simpleFact("---"), Fact.fact("expected", MultimapSubject.annotateEmptyStringsMultimap(expectedMultimap)));
                return ALREADY_FAILED;
            }
            this.failWithActual(Fact.fact("missing", MultimapSubject.countDuplicatesMultimap(MultimapSubject.annotateEmptyStringsMultimap(missing))), Fact.simpleFact("---"), Fact.fact("expected", MultimapSubject.annotateEmptyStringsMultimap(expectedMultimap)));
            return ALREADY_FAILED;
        }
        if (!extra.isEmpty()) {
            this.failWithActual(Fact.fact("unexpected", MultimapSubject.countDuplicatesMultimap(MultimapSubject.annotateEmptyStringsMultimap(extra))), Fact.simpleFact("---"), Fact.fact("expected", MultimapSubject.annotateEmptyStringsMultimap(expectedMultimap)));
            return ALREADY_FAILED;
        }
        return new MultimapInOrder(false, expectedMultimap);
    }

    @CanIgnoreReturnValue
    public final Ordered containsAtLeastEntriesIn(Multimap<?, ?> expectedMultimap) {
        Preconditions.checkNotNull(expectedMultimap, (Object)"expectedMultimap");
        Preconditions.checkNotNull(this.actual);
        ListMultimap<?, ?> missing = MultimapSubject.difference(expectedMultimap, this.actual);
        if (!missing.isEmpty()) {
            this.failWithActual(Fact.fact("missing", MultimapSubject.countDuplicatesMultimap(MultimapSubject.annotateEmptyStringsMultimap(missing))), Fact.simpleFact("---"), Fact.fact("expected to contain at least", MultimapSubject.annotateEmptyStringsMultimap(expectedMultimap)));
            return ALREADY_FAILED;
        }
        return new MultimapInOrder(true, expectedMultimap);
    }

    @CanIgnoreReturnValue
    public final Ordered containsExactly() {
        return this.check().about(this.iterableEntries()).that(((Multimap)Preconditions.checkNotNull(this.actual)).entries()).containsExactly(new Object[0]);
    }

    @CanIgnoreReturnValue
    public final Ordered containsExactly(@Nullable Object k0, @Nullable Object v0, Object ... rest) {
        return this.containsExactlyEntriesIn((Multimap<?, ?>)MultimapSubject.accumulateMultimap(k0, v0, rest));
    }

    @CanIgnoreReturnValue
    public final Ordered containsAtLeast(@Nullable Object k0, @Nullable Object v0, Object ... rest) {
        return this.containsAtLeastEntriesIn((Multimap<?, ?>)MultimapSubject.accumulateMultimap(k0, v0, rest));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static ListMultimap<@Nullable Object, @Nullable Object> accumulateMultimap(@Nullable Object k0, @Nullable Object v0, Object ... rest) {
        Preconditions.checkArgument((rest.length % 2 == 0 ? 1 : 0) != 0, (String)"There must be an equal number of key/value pairs (i.e., the number of key/value parameters (%s) must be even).", (int)(rest.length + 2));
        @Nullable @Nullable LinkedListMultimap expectedMultimap = LinkedListMultimap.create();
        expectedMultimap.put(k0, v0);
        for (int i = 0; i < rest.length; i += 2) {
            expectedMultimap.put(rest[i], rest[i + 1]);
        }
        return expectedMultimap;
    }

    private Subject.Factory<IterableSubject, Iterable<?>> iterableEntries() {
        return new Subject.Factory<IterableSubject, Iterable<?>>(){

            @Override
            public IterableSubject createSubject(FailureMetadata metadata, @Nullable Iterable<?> actual) {
                return new IterableEntries(metadata, MultimapSubject.this, (Iterable)Preconditions.checkNotNull(actual));
            }
        };
    }

    private static boolean advanceToFind(Iterator<?> iterator, @Nullable Object value) {
        while (iterator.hasNext()) {
            if (!Objects.equal(iterator.next(), (Object)value)) continue;
            return true;
        }
        return false;
    }

    private static <V> Collection<V> get(Multimap<?, V> multimap, @Nullable Object key) {
        if (multimap.containsKey(key)) {
            return (Collection)Preconditions.checkNotNull((Object)((Collection)multimap.asMap().get(key)));
        }
        return Collections.emptyList();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static ListMultimap<?, ?> difference(Multimap<?, ?> minuend, Multimap<?, ?> subtrahend) {
        @Nullable @Nullable LinkedListMultimap difference = LinkedListMultimap.create();
        for (Object key : minuend.keySet()) {
            List<?> valDifference = MultimapSubject.difference(Lists.newArrayList(MultimapSubject.get(minuend, key)), Lists.newArrayList(MultimapSubject.get(subtrahend, key)));
            difference.putAll(key, valDifference);
        }
        return difference;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static List<?> difference(List<?> minuend, List<?> subtrahend) {
        @Nullable LinkedHashMultiset remaining = LinkedHashMultiset.create(subtrahend);
        @Nullable ArrayList difference = Lists.newArrayList();
        for (Object elem : minuend) {
            if (remaining.remove(elem)) continue;
            difference.add(elem);
        }
        return difference;
    }

    private static String countDuplicatesMultimap(Multimap<?, ?> multimap) {
        ArrayList<String> entries = new ArrayList<String>();
        for (Object key : multimap.keySet()) {
            entries.add(key + "=" + SubjectUtils.countDuplicates(MultimapSubject.get(multimap, key)));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        Joiner.on((String)", ").appendTo(sb, entries);
        sb.append("}");
        return sb.toString();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static Multimap<?, ?> annotateEmptyStringsMultimap(Multimap<?, ?> multimap) {
        if (multimap.containsKey((Object)"") || multimap.containsValue((Object)"")) {
            @Nullable @Nullable LinkedListMultimap annotatedMultimap = LinkedListMultimap.create();
            for (Map.Entry entry : multimap.entries()) {
                String key = Objects.equal(entry.getKey(), (Object)"") ? "\"\" (empty String)" : entry.getKey();
                String value = Objects.equal(entry.getValue(), (Object)"") ? "\"\" (empty String)" : entry.getValue();
                annotatedMultimap.put((Object)key, (Object)value);
            }
            return annotatedMultimap;
        }
        return multimap;
    }

    public <A, E> UsingCorrespondence<A, E> comparingValuesUsing(Correspondence<? super A, ? super E> correspondence) {
        return new UsingCorrespondence(correspondence);
    }

    private static <K, A, E> Correspondence<Map.Entry<K, A>, Map.Entry<K, E>> entryCorrespondence(Correspondence<? super A, ? super E> valueCorrespondence) {
        return Correspondence.from((actual, expected) -> Objects.equal(actual.getKey(), expected.getKey()) && valueCorrespondence.compare((Object)actual.getValue(), (Object)expected.getValue()), Strings.lenientFormat((String)"has a key that is equal to and a value that %s the key and value of", (Object[])new Object[]{valueCorrespondence}));
    }

    public final class UsingCorrespondence<A, E> {
        private final Correspondence<? super A, ? super E> correspondence;

        private UsingCorrespondence(Correspondence<? super A, ? super E> correspondence) {
            this.correspondence = (Correspondence)Preconditions.checkNotNull(correspondence);
        }

        public void containsEntry(@Nullable Object expectedKey, E expectedValue) {
            if (((Multimap)Preconditions.checkNotNull((Object)MultimapSubject.this.actual)).containsKey(expectedKey)) {
                Collection actualValues = (Collection)Preconditions.checkNotNull((Object)((Collection)this.getCastActual().asMap().get(expectedKey)));
                Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forMapValues();
                for (Object actualValue : actualValues) {
                    if (!this.correspondence.safeCompare(actualValue, expectedValue, exceptions)) continue;
                    if (exceptions.hasCompareException()) {
                        MultimapSubject.this.failWithoutActual((Iterable<Fact>)ImmutableList.builder().addAll(exceptions.describeAsMainCause()).add((Object)Fact.fact("expected to contain entry", Maps.immutableEntry((Object)expectedKey, expectedValue))).addAll(this.correspondence.describeForMapValues()).add((Object)Fact.fact("found match (but failing because of exception)", Maps.immutableEntry((Object)expectedKey, actualValue))).add((Object)Fact.fact("full contents", MultimapSubject.this.actualCustomStringRepresentationForPackageMembersToCall())).build());
                    }
                    return;
                }
                MultimapSubject.this.failWithoutActual((Iterable<Fact>)ImmutableList.builder().add((Object)Fact.fact("expected to contain entry", Maps.immutableEntry((Object)expectedKey, expectedValue))).addAll(this.correspondence.describeForMapValues()).add((Object)Fact.simpleFact("but did not")).add((Object)Fact.fact("though it did contain values for that key", actualValues)).add((Object)Fact.fact("full contents", MultimapSubject.this.actualCustomStringRepresentationForPackageMembersToCall())).addAll(exceptions.describeAsAdditionalInfo()).build());
            } else {
                LinkedHashSet<Map.Entry> entries = new LinkedHashSet<Map.Entry>();
                Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forMapValues();
                for (Map.Entry actualEntry : this.getCastActual().entries()) {
                    if (!this.correspondence.safeCompare(actualEntry.getValue(), expectedValue, exceptions)) continue;
                    entries.add(actualEntry);
                }
                if (!entries.isEmpty()) {
                    MultimapSubject.this.failWithoutActual((Iterable<Fact>)ImmutableList.builder().add((Object)Fact.fact("expected to contain entry", Maps.immutableEntry((Object)expectedKey, expectedValue))).addAll(this.correspondence.describeForMapValues()).add((Object)Fact.simpleFact("but did not")).add((Object)Fact.fact("though it did contain entries with matching values", entries)).add((Object)Fact.fact("full contents", MultimapSubject.this.actualCustomStringRepresentationForPackageMembersToCall())).addAll(exceptions.describeAsAdditionalInfo()).build());
                } else {
                    MultimapSubject.this.failWithoutActual((Iterable<Fact>)ImmutableList.builder().add((Object)Fact.fact("expected to contain entry", Maps.immutableEntry((Object)expectedKey, expectedValue))).addAll(this.correspondence.describeForMapValues()).add((Object)Fact.simpleFact("but did not")).add((Object)Fact.fact("full contents", MultimapSubject.this.actualCustomStringRepresentationForPackageMembersToCall())).addAll(exceptions.describeAsAdditionalInfo()).build());
                }
            }
        }

        public void doesNotContainEntry(@Nullable Object excludedKey, E excludedValue) {
            if (((Multimap)Preconditions.checkNotNull((Object)MultimapSubject.this.actual)).containsKey(excludedKey)) {
                Collection actualValues = (Collection)Preconditions.checkNotNull((Object)((Collection)this.getCastActual().asMap().get(excludedKey)));
                ArrayList matchingValues = new ArrayList();
                Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forMapValues();
                for (Object actualValue : actualValues) {
                    if (!this.correspondence.safeCompare(actualValue, excludedValue, exceptions)) continue;
                    matchingValues.add(actualValue);
                }
                if (!matchingValues.isEmpty()) {
                    MultimapSubject.this.failWithoutActual((Iterable<Fact>)ImmutableList.builder().add((Object)Fact.fact("expected not to contain entry", Maps.immutableEntry((Object)excludedKey, excludedValue))).addAll(this.correspondence.describeForMapValues()).add((Object)Fact.fact("but contained that key with matching values", matchingValues)).add((Object)Fact.fact("full contents", MultimapSubject.this.actualCustomStringRepresentationForPackageMembersToCall())).addAll(exceptions.describeAsAdditionalInfo()).build());
                } else if (exceptions.hasCompareException()) {
                    MultimapSubject.this.failWithoutActual((Iterable<Fact>)ImmutableList.builder().addAll(exceptions.describeAsMainCause()).add((Object)Fact.fact("expected not to contain entry", Maps.immutableEntry((Object)excludedKey, excludedValue))).addAll(this.correspondence.describeForMapValues()).add((Object)Fact.simpleFact("found no match (but failing because of exception)")).add((Object)Fact.fact("full contents", MultimapSubject.this.actualCustomStringRepresentationForPackageMembersToCall())).build());
                }
            }
        }

        @CanIgnoreReturnValue
        public Ordered containsExactlyEntriesIn(Multimap<?, ? extends E> expectedMultimap) {
            return this.internalContainsExactlyEntriesIn(expectedMultimap);
        }

        private <K, V extends E> Ordered internalContainsExactlyEntriesIn(Multimap<K, V> expectedMultimap) {
            return ((IterableSubject)MultimapSubject.this.check().about(MultimapSubject.this.iterableEntries()).that(((Multimap)Preconditions.checkNotNull((Object)MultimapSubject.this.actual)).entries())).comparingElementsUsing(MultimapSubject.entryCorrespondence(this.correspondence)).containsExactlyElementsIn(expectedMultimap.entries());
        }

        @CanIgnoreReturnValue
        public Ordered containsAtLeastEntriesIn(Multimap<?, ? extends E> expectedMultimap) {
            return this.internalContainsAtLeastEntriesIn(expectedMultimap);
        }

        private <K, V extends E> Ordered internalContainsAtLeastEntriesIn(Multimap<K, V> expectedMultimap) {
            return ((IterableSubject)MultimapSubject.this.check().about(MultimapSubject.this.iterableEntries()).that(((Multimap)Preconditions.checkNotNull((Object)MultimapSubject.this.actual)).entries())).comparingElementsUsing(MultimapSubject.entryCorrespondence(this.correspondence)).containsAtLeastElementsIn(expectedMultimap.entries());
        }

        @CanIgnoreReturnValue
        public Ordered containsExactly(@Nullable Object k0, @Nullable E v0, Object ... rest) {
            ListMultimap expectedMultimap = MultimapSubject.accumulateMultimap(k0, v0, rest);
            return this.containsExactlyEntriesIn((Multimap<?, ? extends E>)expectedMultimap);
        }

        @CanIgnoreReturnValue
        public Ordered containsExactly() {
            return MultimapSubject.this.containsExactly();
        }

        @CanIgnoreReturnValue
        public Ordered containsAtLeast(@Nullable Object k0, @Nullable E v0, Object ... rest) {
            ListMultimap expectedMultimap = MultimapSubject.accumulateMultimap(k0, v0, rest);
            return this.containsAtLeastEntriesIn((Multimap<?, ? extends E>)expectedMultimap);
        }

        private Multimap<?, A> getCastActual() {
            return (Multimap)Preconditions.checkNotNull((Object)MultimapSubject.this.actual);
        }
    }

    private class MultimapInOrder
    implements Ordered {
        private final Multimap<?, ?> expectedMultimap;
        private final boolean allowUnexpected;

        MultimapInOrder(boolean allowUnexpected, Multimap<?, ?> expectedMultimap) {
            this.expectedMultimap = expectedMultimap;
            this.allowUnexpected = allowUnexpected;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public void inOrder() {
            Preconditions.checkNotNull((Object)MultimapSubject.this.actual);
            boolean keysInOrder = Lists.newArrayList((Iterable)Sets.intersection((Set)MultimapSubject.this.actual.keySet(), (Set)this.expectedMultimap.keySet())).equals(Lists.newArrayList((Iterable)this.expectedMultimap.keySet()));
            @Nullable LinkedHashSet keysWithValuesOutOfOrder = Sets.newLinkedHashSet();
            block0: for (Object key : this.expectedMultimap.keySet()) {
                ArrayList actualVals = Lists.newArrayList((Iterable)MultimapSubject.get(MultimapSubject.this.actual, key));
                ArrayList expectedVals = Lists.newArrayList((Iterable)MultimapSubject.get(this.expectedMultimap, key));
                Iterator actualIterator = actualVals.iterator();
                for (Object value : expectedVals) {
                    if (MultimapSubject.advanceToFind(actualIterator, value)) continue;
                    boolean unused = keysWithValuesOutOfOrder.add(key);
                    continue block0;
                }
            }
            if (!keysInOrder) {
                if (!keysWithValuesOutOfOrder.isEmpty()) {
                    MultimapSubject.this.failWithActual(Fact.simpleFact("contents match, but order was wrong"), Fact.simpleFact("keys are not in order"), Fact.fact("keys with out-of-order values", keysWithValuesOutOfOrder), Fact.simpleFact("---"), Fact.fact(this.allowUnexpected ? "expected to contain at least" : "expected", this.expectedMultimap));
                } else {
                    MultimapSubject.this.failWithActual(Fact.simpleFact("contents match, but order was wrong"), Fact.simpleFact("keys are not in order"), Fact.simpleFact("---"), Fact.fact(this.allowUnexpected ? "expected to contain at least" : "expected", this.expectedMultimap));
                }
            } else if (!keysWithValuesOutOfOrder.isEmpty()) {
                MultimapSubject.this.failWithActual(Fact.simpleFact("contents match, but order was wrong"), Fact.fact("keys with out-of-order values", keysWithValuesOutOfOrder), Fact.simpleFact("---"), Fact.fact(this.allowUnexpected ? "expected to contain at least" : "expected", this.expectedMultimap));
            }
        }
    }

    private static class IterableEntries
    extends IterableSubject {
        private final String stringRepresentation;

        IterableEntries(FailureMetadata metadata, MultimapSubject multimapSubject, Iterable<?> actual) {
            super(metadata, actual);
            this.stringRepresentation = String.valueOf(multimapSubject.actual);
        }

        @Override
        protected String actualCustomStringRepresentation() {
            return this.stringRepresentation;
        }
    }
}

