/*
 *  Author: tican
 *
 *  Declarations for Syscriptor.
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <string.h>

void partitions(const int BUF_SIZE)
{
	FILE *file;
	char buf[BUF_SIZE];
	char *fname, *p;

	fname = "/etc/mtab";
	file = fopen(fname, "r");
	if ( !file ) {
		fprintf(stderr, "Could not open %s. Bailing out.\n", fname);
		return;
	}

	puts("");
        printf("  PARTITIONS\n\n");

	while ( fgets(buf, BUF_SIZE, file) ) {
		p = strstr(buf,"/dev");

		if ( p ) {
			printf("  %s", p);
		}
	}

	puts("");
	fclose(file);
}
