import * as eslint from 'eslint';
import { ESLint } from 'eslint';

declare const plugin: {
    meta: {
        name: string;
        version: string;
    };
    rules: {
        "prefer-lowercase-title": eslint.Rule.RuleModule;
        "max-nested-describe": eslint.Rule.RuleModule;
        "no-identical-title": eslint.Rule.RuleModule;
        "no-focused-tests": eslint.Rule.RuleModule;
        "no-conditional-tests": eslint.Rule.RuleModule;
        "expect-expect": eslint.Rule.RuleModule;
        "consistent-test-it": eslint.Rule.RuleModule;
        "prefer-to-be": eslint.Rule.RuleModule;
        "no-hooks": eslint.Rule.RuleModule;
        "no-restricted-vi-methods": eslint.Rule.RuleModule;
        "consistent-test-filename": eslint.Rule.RuleModule;
        "max-expects": eslint.Rule.RuleModule;
        "no-alias-methods": eslint.Rule.RuleModule;
        "no-commented-out-tests": eslint.Rule.RuleModule;
        "no-conditional-expect": eslint.Rule.RuleModule;
        "no-conditional-in-test": eslint.Rule.RuleModule;
        "no-disabled-tests": eslint.Rule.RuleModule;
        "no-done-callback": eslint.Rule.RuleModule;
        "no-duplicate-hooks": eslint.Rule.RuleModule;
        "no-large-snapshots": eslint.Rule.RuleModule;
        "no-interpolation-in-snapshots": eslint.Rule.RuleModule;
        "no-mocks-import": eslint.Rule.RuleModule;
        "no-restricted-matchers": eslint.Rule.RuleModule;
        "no-standalone-expect": eslint.Rule.RuleModule;
        "no-test-prefixes": eslint.Rule.RuleModule;
        "no-test-return-statement": eslint.Rule.RuleModule;
        "no-import-node-test": eslint.Rule.RuleModule;
        "prefer-called-with": eslint.Rule.RuleModule;
        "valid-title": eslint.Rule.RuleModule;
        "valid-expect": eslint.Rule.RuleModule;
        "prefer-to-be-falsy": eslint.Rule.RuleModule;
        "prefer-to-be-object": eslint.Rule.RuleModule;
        "prefer-to-be-truthy": eslint.Rule.RuleModule;
        "prefer-to-have-length": eslint.Rule.RuleModule;
        "prefer-equality-matcher": eslint.Rule.RuleModule;
        "prefer-strict-equal": eslint.Rule.RuleModule;
        "prefer-expect-resolves": eslint.Rule.RuleModule;
        "prefer-each": eslint.Rule.RuleModule;
        "prefer-hooks-on-top": eslint.Rule.RuleModule;
        "prefer-hooks-in-order": eslint.Rule.RuleModule;
        "require-local-test-context-for-concurrent-snapshots": eslint.Rule.RuleModule;
        "prefer-mock-promise-shorthand": eslint.Rule.RuleModule;
        "prefer-snapshot-hint": eslint.Rule.RuleModule;
        "valid-describe-callback": eslint.Rule.RuleModule;
        "require-top-level-describe": eslint.Rule.RuleModule;
        "require-to-throw-message": eslint.Rule.RuleModule;
        "require-hook": eslint.Rule.RuleModule;
        "prefer-todo": eslint.Rule.RuleModule;
        "prefer-spy-on": eslint.Rule.RuleModule;
        "prefer-comparison-matcher": eslint.Rule.RuleModule;
        "prefer-to-contain": eslint.Rule.RuleModule;
        "prefer-expect-assertions": eslint.Rule.RuleModule;
    };
    configs: {
        'legacy-recommended': {
            plugins: string[];
            rules: {};
        };
        'legacy-all': {
            plugins: string[];
            rules: {};
        };
        recommended: {
            plugins: {
                readonly vitest: ESLint.Plugin;
            };
            rules: {
                readonly "vitest/expect-expect": "error";
                readonly "vitest/no-identical-title": "error";
                readonly "vitest/no-commented-out-tests": "error";
                readonly "vitest/valid-title": "error";
                readonly "vitest/valid-expect": "error";
                readonly "vitest/valid-describe-callback": "error";
                readonly "vitest/require-local-test-context-for-concurrent-snapshots": "error";
                readonly "vitest/no-import-node-test": "error";
            };
        };
        all: {
            plugins: {
                readonly vitest: ESLint.Plugin;
            };
            rules: {
                readonly "vitest/prefer-lowercase-title": "warn";
                readonly "vitest/max-nested-describe": "warn";
                readonly "vitest/no-focused-tests": "warn";
                readonly "vitest/no-conditional-tests": "warn";
                readonly "vitest/consistent-test-it": "warn";
                readonly "vitest/no-hooks": "warn";
                readonly "vitest/no-restricted-vi-methods": "warn";
                readonly "vitest/consistent-test-filename": "warn";
                readonly "vitest/max-expects": "warn";
                readonly "vitest/no-alias-methods": "warn";
                readonly "vitest/no-conditional-expect": "warn";
                readonly "vitest/no-conditional-in-test": "warn";
                readonly "vitest/no-disabled-tests": "warn";
                readonly "vitest/no-done-callback": "warn";
                readonly "vitest/no-duplicate-hooks": "warn";
                readonly "vitest/no-large-snapshots": "warn";
                readonly "vitest/no-interpolation-in-snapshots": "warn";
                readonly "vitest/no-mocks-import": "warn";
                readonly "vitest/no-restricted-matchers": "warn";
                readonly "vitest/no-standalone-expect": "warn";
                readonly "vitest/no-test-prefixes": "warn";
                readonly "vitest/no-test-return-statement": "warn";
                readonly "vitest/prefer-called-with": "warn";
                readonly "vitest/prefer-to-be-falsy": "warn";
                readonly "vitest/prefer-to-be-object": "warn";
                readonly "vitest/prefer-to-be-truthy": "warn";
                readonly "vitest/prefer-to-have-length": "warn";
                readonly "vitest/prefer-equality-matcher": "warn";
                readonly "vitest/prefer-strict-equal": "warn";
                readonly "vitest/prefer-expect-resolves": "warn";
                readonly "vitest/prefer-each": "warn";
                readonly "vitest/prefer-hooks-on-top": "warn";
                readonly "vitest/prefer-hooks-in-order": "warn";
                readonly "vitest/prefer-mock-promise-shorthand": "warn";
                readonly "vitest/prefer-snapshot-hint": "warn";
                readonly "vitest/require-top-level-describe": "warn";
                readonly "vitest/require-to-throw-message": "warn";
                readonly "vitest/require-hook": "warn";
                readonly "vitest/prefer-todo": "warn";
                readonly "vitest/prefer-spy-on": "warn";
                readonly "vitest/prefer-comparison-matcher": "warn";
                readonly "vitest/prefer-to-contain": "warn";
                readonly "vitest/prefer-expect-assertions": "warn";
                readonly "vitest/prefer-to-be": "warn";
            };
        };
        env: {
            languageOptions: {
                globals: {
                    suite: "writable";
                    test: "writable";
                    describe: "writable";
                    it: "writable";
                    expect: "writable";
                    assert: "writable";
                    vitest: "writable";
                    vi: "writable";
                    beforeAll: "writable";
                    afterAll: "writable";
                    beforeEach: "writable";
                    afterEach: "writable";
                };
            };
        };
    };
    environments: {
        env: {
            globals: {
                suite: true;
                test: true;
                describe: true;
                it: true;
                expect: true;
                assert: true;
                vitest: true;
                vi: true;
                beforeAll: true;
                afterAll: true;
                beforeEach: true;
                afterEach: true;
            };
        };
    };
};

export { plugin as default };
