'use client';
'use strict';

var jsxRuntime = require('react/jsx-runtime');
var dayjs = require('dayjs');
var react = require('react');
var core = require('@mantine/core');
var hooks = require('@mantine/hooks');
var useUncontrolledDates = require('../../hooks/use-uncontrolled-dates/use-uncontrolled-dates.cjs');
require('../DatesProvider/DatesProvider.cjs');
var useDatesContext = require('../DatesProvider/use-dates-context.cjs');
var assignTime = require('../../utils/assign-time/assign-time.cjs');
var shiftTimezone = require('../../utils/shift-timezone.cjs');
require('../Calendar/Calendar.cjs');
var pickCalendarLevelsProps = require('../Calendar/pick-calendar-levels-props/pick-calendar-levels-props.cjs');
var DatePicker = require('../DatePicker/DatePicker.cjs');
var PickerInputBase = require('../PickerInputBase/PickerInputBase.cjs');
var TimeInput = require('../TimeInput/TimeInput.cjs');
var DateTimePicker_module = require('./DateTimePicker.module.css.cjs');

function _interopDefault (e) { return e && e.__esModule ? e : { default: e }; }

var dayjs__default = /*#__PURE__*/_interopDefault(dayjs);

const defaultProps = {
  dropdownType: "popover"
};
const DateTimePicker = core.factory((_props, ref) => {
  const props = core.useProps("DateTimePicker", defaultProps, _props);
  const {
    value,
    defaultValue,
    onChange,
    valueFormat,
    locale,
    classNames,
    styles,
    unstyled,
    timeInputProps,
    submitButtonProps,
    withSeconds,
    level,
    defaultLevel,
    size,
    variant,
    dropdownType,
    vars,
    minDate,
    maxDate,
    ...rest
  } = props;
  const getStyles = core.useStyles({
    name: "DateTimePicker",
    classes: DateTimePicker_module,
    props,
    classNames,
    styles,
    unstyled,
    vars
  });
  const { resolvedClassNames, resolvedStyles } = core.useResolvedStylesApi({
    classNames,
    styles,
    props
  });
  const _valueFormat = valueFormat || (withSeconds ? "DD/MM/YYYY HH:mm:ss" : "DD/MM/YYYY HH:mm");
  const timeInputRef = react.useRef();
  const timeInputRefMerged = hooks.useMergedRef(timeInputRef, timeInputProps?.ref);
  const {
    calendarProps: { allowSingleDateInRange, ...calendarProps },
    others
  } = pickCalendarLevelsProps.pickCalendarProps(rest);
  const ctx = useDatesContext.useDatesContext();
  const [_value, setValue] = useUncontrolledDates.useUncontrolledDates({
    type: "default",
    value,
    defaultValue,
    onChange
  });
  const formatTime = (dateValue) => dateValue ? dayjs__default.default(dateValue).format(withSeconds ? "HH:mm:ss" : "HH:mm") : "";
  const [timeValue, setTimeValue] = react.useState(formatTime(_value));
  const [currentLevel, setCurrentLevel] = react.useState(level || defaultLevel || "month");
  const [dropdownOpened, dropdownHandlers] = hooks.useDisclosure(false);
  const formattedValue = _value ? dayjs__default.default(_value).locale(ctx.getLocale(locale)).format(_valueFormat) : "";
  const handleTimeChange = (event) => {
    timeInputProps?.onChange?.(event);
    const val = event.currentTarget.value;
    setTimeValue(val);
    if (val) {
      const [hours, minutes, seconds] = val.split(":").map(Number);
      const timeDate = shiftTimezone.shiftTimezone("add", /* @__PURE__ */ new Date(), ctx.getTimezone());
      timeDate.setHours(hours);
      timeDate.setMinutes(minutes);
      timeDate.setSeconds(seconds || 0);
      setValue(assignTime.assignTime(timeDate, _value || shiftTimezone.shiftTimezone("add", /* @__PURE__ */ new Date(), ctx.getTimezone())));
    }
  };
  const handleDateChange = (date) => {
    if (date) {
      setValue(assignTime.assignTime(_value, date));
    }
    timeInputRef.current?.focus();
  };
  const handleTimeInputKeyDown = (event) => {
    timeInputProps?.onKeyDown?.(event);
    if (event.key === "Enter") {
      event.preventDefault();
      dropdownHandlers.close();
    }
  };
  hooks.useDidUpdate(() => {
    if (!dropdownOpened) {
      setTimeValue(formatTime(_value));
    }
  }, [_value, dropdownOpened]);
  hooks.useDidUpdate(() => {
    if (dropdownOpened) {
      setCurrentLevel("month");
    }
  }, [dropdownOpened]);
  const minTime = minDate ? dayjs__default.default(minDate).format("HH:mm:ss") : null;
  const maxTime = maxDate ? dayjs__default.default(maxDate).format("HH:mm:ss") : null;
  const __stopPropagation = dropdownType === "popover";
  return /* @__PURE__ */ jsxRuntime.jsxs(
    PickerInputBase.PickerInputBase,
    {
      formattedValue,
      dropdownOpened: !rest.disabled ? dropdownOpened : false,
      dropdownHandlers,
      classNames: resolvedClassNames,
      styles: resolvedStyles,
      unstyled,
      ref,
      onClear: () => setValue(null),
      shouldClear: !!_value,
      value: _value,
      size,
      variant,
      dropdownType,
      ...others,
      type: "default",
      __staticSelector: "DateTimePicker",
      children: [
        /* @__PURE__ */ jsxRuntime.jsx(
          DatePicker.DatePicker,
          {
            ...calendarProps,
            maxDate,
            minDate,
            size,
            variant,
            type: "default",
            value: _value,
            defaultDate: _value,
            onChange: handleDateChange,
            locale,
            classNames: resolvedClassNames,
            styles: resolvedStyles,
            unstyled,
            __staticSelector: "DateTimePicker",
            __stopPropagation,
            level,
            defaultLevel,
            onLevelChange: (_level) => {
              setCurrentLevel(_level);
              calendarProps.onLevelChange?.(_level);
            },
            __timezoneApplied: true
          }
        ),
        currentLevel === "month" && /* @__PURE__ */ jsxRuntime.jsxs("div", { ...getStyles("timeWrapper"), children: [
          /* @__PURE__ */ jsxRuntime.jsx(
            TimeInput.TimeInput,
            {
              value: timeValue,
              withSeconds,
              ref: timeInputRefMerged,
              unstyled,
              minTime: _value && minDate && _value.toDateString() === minDate.toDateString() ? minTime != null ? minTime : void 0 : void 0,
              maxTime: _value && maxDate && _value.toDateString() === maxDate.toDateString() ? maxTime != null ? maxTime : void 0 : void 0,
              ...timeInputProps,
              ...getStyles("timeInput", {
                className: timeInputProps?.className,
                style: timeInputProps?.style
              }),
              onChange: handleTimeChange,
              onKeyDown: handleTimeInputKeyDown,
              size,
              "data-mantine-stop-propagation": __stopPropagation || void 0
            }
          ),
          /* @__PURE__ */ jsxRuntime.jsx(
            core.ActionIcon,
            {
              variant: "default",
              size: `input-${size || "sm"}`,
              ...getStyles("submitButton", {
                className: submitButtonProps?.className,
                style: submitButtonProps?.style
              }),
              unstyled,
              "data-mantine-stop-propagation": __stopPropagation || void 0,
              children: /* @__PURE__ */ jsxRuntime.jsx(core.CheckIcon, { size: "30%" }),
              ...submitButtonProps,
              onClick: (event) => {
                submitButtonProps?.onClick?.(event);
                dropdownHandlers.close();
              }
            }
          )
        ] })
      ]
    }
  );
});
DateTimePicker.classes = { ...DateTimePicker_module, ...PickerInputBase.PickerInputBase.classes, ...DatePicker.DatePicker.classes };
DateTimePicker.displayName = "@mantine/dates/DateTimePicker";

exports.DateTimePicker = DateTimePicker;
//# sourceMappingURL=DateTimePicker.cjs.map
