import { FloatingAxesOffsets, FloatingPosition, FloatingStrategy } from '../Floating';
import { PopoverMiddlewares, PopoverWidth } from './Popover.types';
interface UsePopoverOptions {
    offset: number | FloatingAxesOffsets;
    position: FloatingPosition;
    positionDependencies: any[] | undefined;
    onPositionChange?: (position: FloatingPosition) => void;
    opened: boolean | undefined;
    defaultOpened: boolean | undefined;
    onChange?: (opened: boolean) => void;
    onClose?: () => void;
    onOpen?: () => void;
    width: PopoverWidth;
    middlewares: PopoverMiddlewares | undefined;
    arrowRef: React.RefObject<HTMLDivElement>;
    arrowOffset: number;
    strategy?: FloatingStrategy;
}
export declare function usePopover(options: UsePopoverOptions): {
    floating: {
        placement: import("@floating-ui/utils").Placement;
        strategy: import("@floating-ui/utils").Strategy;
        middlewareData: import("@floating-ui/core").MiddlewareData;
        x: number;
        y: number;
        isPositioned: boolean;
        update: () => void;
        floatingStyles: import("react").CSSProperties;
        refs: {
            reference: import("react").MutableRefObject<import("@floating-ui/react-dom").ReferenceType | null>;
            floating: import("react").MutableRefObject<HTMLElement | null>;
            setReference: (node: import("@floating-ui/react-dom").ReferenceType | null) => void;
            setFloating: (node: HTMLElement | null) => void;
        } & import("@floating-ui/react").ExtendedRefs<Element>;
        elements: {
            reference: import("@floating-ui/react-dom").ReferenceType | null;
            floating: HTMLElement | null;
        } & import("@floating-ui/react").ExtendedElements<Element>;
        context: {
            x: number;
            y: number;
            placement: import("@floating-ui/utils").Placement;
            strategy: import("@floating-ui/utils").Strategy;
            middlewareData: import("@floating-ui/core").MiddlewareData;
            isPositioned: boolean;
            update: () => void;
            floatingStyles: import("react").CSSProperties;
            open: boolean;
            onOpenChange: (open: boolean, event?: Event | undefined, reason?: import("@floating-ui/react").OpenChangeReason | undefined) => void;
            events: import("@floating-ui/react").FloatingEvents;
            dataRef: import("react").MutableRefObject<import("@floating-ui/react").ContextData>;
            nodeId: string | undefined;
            floatingId: string;
            refs: import("@floating-ui/react").ExtendedRefs<Element>;
            elements: import("@floating-ui/react").ExtendedElements<Element>;
        };
    };
    controlled: boolean;
    opened: boolean;
    onClose: () => void;
    onToggle: () => void;
};
export {};
