import { Factory, MantineThemeComponent } from '../../core';
export interface NumberFormatterProps extends React.ComponentPropsWithoutRef<'span'> {
    /** Value to format */
    value?: number | string;
    /** Determines whether negative values are allowed, `true` by default */
    allowNegative?: boolean;
    /** Limits the number of digits that are displayed after the decimal point, by default there is no limit */
    decimalScale?: number;
    /** Character used as a decimal separator, `'.'` by default */
    decimalSeparator?: string;
    /** If set, 0s are added after `decimalSeparator` to match given `decimalScale`. `false` by default */
    fixedDecimalScale?: boolean;
    /** Prefix added before the value */
    prefix?: string;
    /** Suffix added after the value */
    suffix?: string;
    /** Defines the thousand grouping style */
    thousandsGroupStyle?: 'thousand' | 'lakh' | 'wan' | 'none';
    /** A character used to separate thousands, `','` by default */
    thousandSeparator?: string | boolean;
}
export type NumberFormatterFactory = Factory<{
    props: NumberFormatterProps;
    ref: HTMLDivElement;
}>;
export declare function NumberFormatter(_props: NumberFormatterProps): import("react/jsx-runtime").JSX.Element | null;
export declare namespace NumberFormatter {
    var extend: (c: import("../../core/factory/factory").ExtendsRootComponent<{
        props: NumberFormatterProps;
        ref: HTMLDivElement;
    }>) => MantineThemeComponent;
    var displayName: string;
}
