import { ESessionStorageKeys, ITemporaryStorage } from "../../../helper";
import { InferType, ObjectSchema } from "yup";
import { TPaging, TSorting } from "../../../genericTypes";
declare const tableStoredSchema: ObjectSchema<{
    sorting: TSorting;
    paging: Omit<TPaging, "totalDisplayableResults">;
}>;
export type TTableStorageData = InferType<typeof tableStoredSchema>;
export interface ITableStorage extends ITemporaryStorage<TTableStorageData> {
}
export declare class TableStorage implements ITableStorage {
    private static _instance;
    static sessionStorageKey: ESessionStorageKeys;
    private static storage;
    constructor();
    static Instance(): TableStorage;
    get(id: string): TTableStorageData | null;
    set(id: string, updateData: (prev: TTableStorageData) => TTableStorageData): void;
}
export {};
//# sourceMappingURL=TableStorage.d.ts.map