import { TCascadeOption } from "../../Form/Select/Cascade/CascadeOption";
import { TTermValueNotNull } from "./transformHelpers";
import { TValue } from "../../Form";
export declare namespace TFilter {
    namespace DTO {
        enum Match {
            AND = "and",
            OR = "or"
        }
        type Field = {
            name: string;
            operator: string;
            value: Exclude<TFilter.Internal.Term.TermValue, null>;
            keys?: string[];
        };
        type State = {
            operator: TFilter.DTO.Match;
            fields: Array<TFilter.DTO.Field>;
        };
        type ValueTransformConfigByAttributeName = Record<string, (term: TFilter.Internal.Term.State) => TTermValueNotNull>;
    }
    enum EArrowKeys {
        LEFT = 0,
        RIGHT = 1
    }
    enum EControlType {
        STRING = "string",
        ENUM = "enum",
        INTEGER = "integer",
        FLOAT = "float",
        AUTOCOMPLETE = "autocomplete",
        DATETIME = "dateTime",
        UUID = "uuid"
    }
    type Operator = {
        value: string;
        label: string;
        control?: {
            type: TFilter.EControlType;
        };
        values?: string[];
    };
    type Config = TFilter.ConfigItem[];
    type CascadeValue = TCascadeOption<TValue[]>;
    type ConfigItem = {
        name: {
            label: string;
            value: string;
        };
        control: {
            type: TFilter.EControlType;
        };
        values?: string[];
        cascadeValues?: CascadeValue[];
        operators: Operator[];
        multiSelect: boolean;
    };
    namespace Internal {
        type TFilterApplyOptions = {
            language?: ELanguage;
            term?: TFilter.Internal.Term.State;
        };
        type Match = "ALL" | "ANY";
        type State = {
            match: Match;
            terms: TFilter.Internal.Term.State[];
            termsCollapsed: boolean;
            edited?: boolean;
        };
        enum ESTEP {
            ATTRIBUTE = 0,
            OPERATOR = 1,
            VALUE = 2
        }
        namespace Term {
            type State = {
                attribute: TFilter.ConfigItem | null;
                operator: Operator | null;
                value: TermValue;
                selectedCascadeValues: CascadeValue[] | null;
                completed: boolean;
                id: number;
                active: boolean;
            };
            type TermValue = Array<number | string> | string | number | null;
        }
    }
    namespace EventHandler {
        enum EApplyEvent {
            BLUR = "BLUR",
            KEYPRESS = "KEYPRESS",
            CLICK = "CLICK",
            UPDATE_MATCH = "UPDATE_MATCH",
            DELETE_TERM = "DELETE_TERM",
            DELETE_ALL_TERMS = "DELETE_ALL_TERMS",
            VALUE_CHANGE = "VALUE_CHANGE",
            AUTOMATIC_VALUE_LOAD_FROM_STORAGE = "AUTOMATIC_VALUE_LOAD_FROM_STORAGE",
            VALUE_DELETE = "VALUE_DELETE"
        }
        type TActionMeta = {
            wasUserCreated: boolean;
            event?: TFilter.EventHandler.EApplyEvent;
        };
        type onApply = (state: TFilter.DTO.State, internalState: TFilter.Internal.State, meta: TFilter.EventHandler.TActionMeta) => void;
    }
}
export type TSelectOnChangeReturn = {
    value: unknown;
    label: string;
};
export type TSelectOnChangeReturnArray = Array<TSelectOnChangeReturn>;
export declare enum ELanguage {
    EN = "en",
    DE = "de"
}
export declare namespace ELanguage {
    function fromString(lang: string | undefined): ELanguage;
}
export declare enum EFullLanguage {
    EN_US = "en-US",
    DE_DE = "de-DE"
}
export declare namespace EFullLanguage {
    function fromLanguage(lang: ELanguage): EFullLanguage;
}
//# sourceMappingURL=types.d.ts.map