import{jsx as _jsx,jsxs as _jsxs}from"react/jsx-runtime";import React,{memo}from"react";import{Pagination as MantinePagination}from"@mantine/core";import{PAGING_STEPS}from"../constants";import{Select}from"../../Form";import{useTranslation}from"react-i18next";import classes from"./Paging.module.css";const PaginationRaw=({index,size=10,totalDisplayableResults,actions})=>{const{t}=useTranslation();if(totalDisplayableResults<=0)return null;const pagingStepsStringified=PAGING_STEPS.map(s=>""+s);const start=index*size+1;const end=(index+1)*size>totalDisplayableResults?totalDisplayableResults:(index+1)*size;const text=t("{start}–{end} of {totalDisplayableResults} items",{start,end,totalDisplayableResults});return /*#__PURE__*/_jsxs("div",{className:classes["pagination-container"],"data-testid":"pagination-container",children:[/*#__PURE__*/_jsxs("div",{className:classes.info,children:[/*#__PURE__*/_jsxs("span",{className:classes["per-page"],children:[/*#__PURE__*/_jsxs("span",{className:classes.text,children:[t("Items per page"),":"]}),/*#__PURE__*/_jsx(Select,{"data-testid":"paging-step-select",data:pagingStepsStringified,defaultValue:size+""||pagingStepsStringified[0],onChange:val=>actions.setPageSize(parseInt(val||pagingStepsStringified[0]))})]}),/*#__PURE__*/_jsx("span",{className:classes.text,children:text})]}),/*#__PURE__*/_jsx(MantinePagination,{className:classes.pagination,total:Math.ceil(totalDisplayableResults/size),value:index+1,onChange:val=>{actions.gotoPageIndex(val-1)}})]})};const Pagination=/*#__PURE__*/memo(PaginationRaw);export{Pagination};
//# sourceMappingURL=Paging.js.map