/*
 * Decompiled with CFR 0.152.
 */
package com.declarativa.interprolog;

import com.declarativa.interprolog.AbstractPrologEngine;
import com.declarativa.interprolog.GNUPeer;
import com.declarativa.interprolog.PrologImplementationPeer;
import com.declarativa.interprolog.SubprocessEngine;
import com.declarativa.interprolog.util.IPException;
import java.io.IOException;
import java.io.OutputStream;

public class GNUSubprocessEngine
extends SubprocessEngine {
    protected PrologImplementationPeer makeImplementationPeer() {
        return new GNUPeer(this);
    }

    public GNUSubprocessEngine(String string, boolean bl, boolean bl2) {
        super(string, bl, bl2);
    }

    public GNUSubprocessEngine(String string, boolean bl) {
        super(string, bl);
    }

    public GNUSubprocessEngine(String string) {
        super(string);
    }

    public GNUSubprocessEngine() {
    }

    protected Process createProcess(String string) throws IOException {
        this.progressMessage("Launching subprocess " + string);
        return Runtime.getRuntime().exec(string, new String[]{"LINEDIT=gui=no"});
    }

    protected synchronized void doInterrupt() {
        this.setDetectPromptAndBreak(true);
        try {
            if (AbstractPrologEngine.isWindowsOS()) {
                byte[] byArray = new byte[]{3};
                this.progressMessage("Attempting to interrupt Prolog...");
                OutputStream outputStream = this.intSocket.getOutputStream();
                outputStream.write(byArray);
                outputStream.flush();
            } else {
                this.progressMessage("Interrupting Prolog with " + this.interruptCommand);
                Runtime.getRuntime().exec(this.interruptCommand);
            }
        }
        catch (IOException iOException) {
            throw new IPException("Exception in interrupt():" + iOException);
        }
        this.waitUntilAvailable();
        this.sendAndFlushLn("abort.");
        this.waitUntilAvailable();
    }
}

