/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { InjectionToken } from '@angular/core';
/** Whether test modules should be torn down by default. */
export const TEARDOWN_TESTING_MODULE_ON_DESTROY_DEFAULT = true;
/** Whether unknown elements in templates should throw by default. */
export const THROW_ON_UNKNOWN_ELEMENTS_DEFAULT = false;
/** Whether unknown properties in templates should throw by default. */
export const THROW_ON_UNKNOWN_PROPERTIES_DEFAULT = false;
/**
 * An abstract class for inserting the root test component element in a platform independent way.
 *
 * @publicApi
 */
export class TestComponentRenderer {
    insertRootElement(rootElementId) { }
    removeAllRootElements() { }
}
/**
 * @publicApi
 */
export const ComponentFixtureAutoDetect = new InjectionToken('ComponentFixtureAutoDetect');
/**
 * @publicApi
 */
export const ComponentFixtureNoNgZone = new InjectionToken('ComponentFixtureNoNgZone');
//# sourceMappingURL=data:application/json;base64,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