//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsglasseffectviewstyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSGlassEffectViewStyle(pub NSInteger);
impl NSGlassEffectViewStyle {
    /// Standard glass effect style.
    #[doc(alias = "NSGlassEffectViewStyleRegular")]
    pub const Regular: Self = Self(0);
    /// Clear glass effect style.
    #[doc(alias = "NSGlassEffectViewStyleClear")]
    pub const Clear: Self = Self(1);
}

unsafe impl Encode for NSGlassEffectViewStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSGlassEffectViewStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// A view that embeds its content view in a dynamic glass effect.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsglasseffectview?language=objc)
    #[unsafe(super(NSView, NSResponder, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "NSResponder", feature = "NSView"))]
    pub struct NSGlassEffectView;
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAccessibility for NSGlassEffectView {}
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAccessibilityElementProtocol for NSGlassEffectView {}
);

#[cfg(all(feature = "NSAnimation", feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSAnimatablePropertyContainer for NSGlassEffectView {}
);

#[cfg(all(feature = "NSAppearance", feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSAppearanceCustomization for NSGlassEffectView {}
);

#[cfg(all(feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSCoding for NSGlassEffectView {}
);

#[cfg(all(feature = "NSDragging", feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSDraggingDestination for NSGlassEffectView {}
);

#[cfg(all(feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSObjectProtocol for NSGlassEffectView {}
);

#[cfg(all(
    feature = "NSResponder",
    feature = "NSUserInterfaceItemIdentification",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSUserInterfaceItemIdentification for NSGlassEffectView {}
);

#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSGlassEffectView {
    extern_methods!(
        /// The view to embed in glass.
        ///
        /// - Important: `NSGlassEffectView` only guarantees the `contentView` will be placed inside the glass effect; arbitrary subviews aren't guaranteed specific behavior with regard to z-order in relation to the content view or glass effect.
        #[unsafe(method(contentView))]
        #[unsafe(method_family = none)]
        pub fn contentView(&self) -> Option<Retained<NSView>>;

        /// Setter for [`contentView`][Self::contentView].
        #[unsafe(method(setContentView:))]
        #[unsafe(method_family = none)]
        pub fn setContentView(&self, content_view: Option<&NSView>);

        #[cfg(feature = "objc2-core-foundation")]
        /// The amount of curvature for all corners of the glass.
        #[unsafe(method(cornerRadius))]
        #[unsafe(method_family = none)]
        pub fn cornerRadius(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`cornerRadius`][Self::cornerRadius].
        #[unsafe(method(setCornerRadius:))]
        #[unsafe(method_family = none)]
        pub fn setCornerRadius(&self, corner_radius: CGFloat);

        #[cfg(feature = "NSColor")]
        /// The color the glass effect view uses to tint the background and glass effect toward.
        #[unsafe(method(tintColor))]
        #[unsafe(method_family = none)]
        pub fn tintColor(&self) -> Option<Retained<NSColor>>;

        #[cfg(feature = "NSColor")]
        /// Setter for [`tintColor`][Self::tintColor].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setTintColor:))]
        #[unsafe(method_family = none)]
        pub fn setTintColor(&self, tint_color: Option<&NSColor>);

        /// The style of glass this view uses.
        #[unsafe(method(style))]
        #[unsafe(method_family = none)]
        pub fn style(&self) -> NSGlassEffectViewStyle;

        /// Setter for [`style`][Self::style].
        #[unsafe(method(setStyle:))]
        #[unsafe(method_family = none)]
        pub fn setStyle(&self, style: NSGlassEffectViewStyle);
    );
}

/// Methods declared on superclass `NSView`.
#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSGlassEffectView {
    extern_methods!(
        #[unsafe(method(initWithFrame:))]
        #[unsafe(method_family = init)]
        pub fn initWithFrame(this: Allocated<Self>, frame_rect: NSRect) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSResponder`.
#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSGlassEffectView {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSGlassEffectView {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_class!(
    /// A view that efficiently merges descendant glass effect views together when they are within a specified proximity to each other.
    ///
    /// - Tip: Using a glass effect container view can improve performance by reducing the number of passes required to render similar glass effect views.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsglasseffectcontainerview?language=objc)
    #[unsafe(super(NSView, NSResponder, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "NSResponder", feature = "NSView"))]
    pub struct NSGlassEffectContainerView;
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAccessibility for NSGlassEffectContainerView {}
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAccessibilityElementProtocol for NSGlassEffectContainerView {}
);

#[cfg(all(feature = "NSAnimation", feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSAnimatablePropertyContainer for NSGlassEffectContainerView {}
);

#[cfg(all(feature = "NSAppearance", feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSAppearanceCustomization for NSGlassEffectContainerView {}
);

#[cfg(all(feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSCoding for NSGlassEffectContainerView {}
);

#[cfg(all(feature = "NSDragging", feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSDraggingDestination for NSGlassEffectContainerView {}
);

#[cfg(all(feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSObjectProtocol for NSGlassEffectContainerView {}
);

#[cfg(all(
    feature = "NSResponder",
    feature = "NSUserInterfaceItemIdentification",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSUserInterfaceItemIdentification for NSGlassEffectContainerView {}
);

#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSGlassEffectContainerView {
    extern_methods!(
        /// The view that contains descendant views to merge together when in proximity to each other.
        ///
        /// The glass effect container view does the following:
        /// 1. Elevates the z-order of descendants of `contentView` to position them above the `contentView`.
        /// 2. Merges descendants together if the views are sufficiently similar and within the proximity specified in ``spacing``.
        /// 3. Processes similar glass effect views as a batch to improve performance.
        #[unsafe(method(contentView))]
        #[unsafe(method_family = none)]
        pub fn contentView(&self) -> Option<Retained<NSView>>;

        /// Setter for [`contentView`][Self::contentView].
        #[unsafe(method(setContentView:))]
        #[unsafe(method_family = none)]
        pub fn setContentView(&self, content_view: Option<&NSView>);

        #[cfg(feature = "objc2-core-foundation")]
        /// The proximity at which the glass effect container view begins merging eligible descendent glass effect views.
        ///
        /// The default value, zero, is sufficient for batch processing eligible glass effect views, while avoiding distortion and merging effects for other views in close proximity.
        #[unsafe(method(spacing))]
        #[unsafe(method_family = none)]
        pub fn spacing(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`spacing`][Self::spacing].
        #[unsafe(method(setSpacing:))]
        #[unsafe(method_family = none)]
        pub fn setSpacing(&self, spacing: CGFloat);
    );
}

/// Methods declared on superclass `NSView`.
#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSGlassEffectContainerView {
    extern_methods!(
        #[unsafe(method(initWithFrame:))]
        #[unsafe(method_family = init)]
        pub fn initWithFrame(this: Allocated<Self>, frame_rect: NSRect) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSResponder`.
#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSGlassEffectContainerView {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSGlassEffectContainerView {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
