/*
 * Decompiled with CFR 0.152.
 */
package com.ca.jndiproviders.dsml;

import com.ca.commons.cbutil.CBBase64;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Logger;

public class SoapClient {
    private static Logger log = Logger.getLogger(SoapClient.class.getName());

    public static String sendSoapMsg(String SOAPUrl, byte[] b, String SOAPAction, String username, String pwd) throws IOException {
        String inputLine;
        log.finest("HTTP REQUEST SIZE " + b.length);
        if (!SOAPAction.startsWith("\"")) {
            SOAPAction = "\"" + SOAPAction + "\"";
        }
        URL url = new URL(SOAPUrl);
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        httpConn.setRequestProperty("SOAPAction", SOAPAction);
        httpConn.setRequestProperty("Content-Type", "text/xml; charset=\"utf-8\"");
        httpConn.setRequestProperty("Content-Length", String.valueOf(b.length));
        httpConn.setRequestProperty("Cache-Control", "no-cache");
        httpConn.setRequestProperty("Pragma", "no-cache");
        if (username != null && pwd != null) {
            String authval = username + ":" + pwd;
            String base64val = CBBase64.binaryToString(authval.getBytes("UTF-8"));
            httpConn.setRequestProperty("Authorization", "Basic " + base64val);
        }
        httpConn.setRequestMethod("POST");
        httpConn.setDoOutput(true);
        httpConn.setDoInput(true);
        OutputStream out = httpConn.getOutputStream();
        out.write(b);
        out.close();
        InputStreamReader isr = new InputStreamReader(httpConn.getInputStream());
        BufferedReader in = new BufferedReader(isr);
        StringBuffer response = new StringBuffer(1024);
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        log.finest("HTTP RESPONSE SIZE: " + response.length());
        return response.toString();
    }
}

