/*
* Copyright 2018 - Present Okta, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
 */

// Code generated by okta openapi generator. DO NOT EDIT.

package okta

import (
	"encoding/json"
	"time"
)

type SocialAuthToken struct {
	ExpiresAt       *time.Time `json:"expiresAt,omitempty"`
	Id              string     `json:"id,omitempty"`
	Scopes          []string   `json:"scopes,omitempty"`
	Token           string     `json:"token,omitempty"`
	TokenAuthScheme string     `json:"tokenAuthScheme,omitempty"`
	TokenType       string     `json:"tokenType,omitempty"`
}

func (a *SocialAuthToken) UnmarshalJSON(data []byte) error {
	if string(data) == "null" || string(data) == `""` {
		return nil
	}
	var token map[string]interface{}
	err := json.Unmarshal(data, &token)
	if err != nil {
		return err
	}
	if ea, found := token["expiresAt"]; found {
		if expiresAt, err := time.Parse(time.RFC3339, ea.(string)); err == nil {
			a.ExpiresAt = &expiresAt
		}
	}
	a.Id, _ = token["id"].(string)
	if scopes, found := token["scopes"]; found {
		_scopes := scopes.([]interface{})
		a.Scopes = make([]string, len(_scopes))
		for i, scope := range _scopes {
			a.Scopes[i] = scope.(string)
		}
	}
	a.Token, _ = token["token"].(string)
	a.TokenAuthScheme, _ = token["tokenAuthScheme"].(string)
	a.TokenType, _ = token["tokenType"].(string)

	return nil
}
