package models

import (
    i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e "time"
    i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91 "github.com/microsoft/kiota-abstractions-go/serialization"
)

// MalwareStateForWindowsDevice malware state for a windows device
type MalwareStateForWindowsDevice struct {
    Entity
}
// NewMalwareStateForWindowsDevice instantiates a new malwareStateForWindowsDevice and sets the default values.
func NewMalwareStateForWindowsDevice()(*MalwareStateForWindowsDevice) {
    m := &MalwareStateForWindowsDevice{
        Entity: *NewEntity(),
    }
    return m
}
// CreateMalwareStateForWindowsDeviceFromDiscriminatorValue creates a new instance of the appropriate class based on discriminator value
func CreateMalwareStateForWindowsDeviceFromDiscriminatorValue(parseNode i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, error) {
    return NewMalwareStateForWindowsDevice(), nil
}
// GetDetectionCount gets the detectionCount property value. Indicates the number of times the malware is detected
func (m *MalwareStateForWindowsDevice) GetDetectionCount()(*int32) {
    val, err := m.GetBackingStore().Get("detectionCount")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*int32)
    }
    return nil
}
// GetDeviceName gets the deviceName property value. Indicates the name of the device being evaluated for malware state
func (m *MalwareStateForWindowsDevice) GetDeviceName()(*string) {
    val, err := m.GetBackingStore().Get("deviceName")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*string)
    }
    return nil
}
// GetExecutionState gets the executionState property value. Indicates execution status of the malware. Possible values are: unknown, blocked, allowed, running, notRunning. Defaults to unknown. Possible values are: unknown, blocked, allowed, running, notRunning.
func (m *MalwareStateForWindowsDevice) GetExecutionState()(*WindowsMalwareExecutionState) {
    val, err := m.GetBackingStore().Get("executionState")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*WindowsMalwareExecutionState)
    }
    return nil
}
// GetFieldDeserializers the deserialization information for the current model
func (m *MalwareStateForWindowsDevice) GetFieldDeserializers()(map[string]func(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(error)) {
    res := m.Entity.GetFieldDeserializers()
    res["detectionCount"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetInt32Value()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetDetectionCount(val)
        }
        return nil
    }
    res["deviceName"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetStringValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetDeviceName(val)
        }
        return nil
    }
    res["executionState"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetEnumValue(ParseWindowsMalwareExecutionState)
        if err != nil {
            return err
        }
        if val != nil {
            m.SetExecutionState(val.(*WindowsMalwareExecutionState))
        }
        return nil
    }
    res["initialDetectionDateTime"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetTimeValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetInitialDetectionDateTime(val)
        }
        return nil
    }
    res["lastStateChangeDateTime"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetTimeValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetLastStateChangeDateTime(val)
        }
        return nil
    }
    res["threatState"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetEnumValue(ParseWindowsMalwareThreatState)
        if err != nil {
            return err
        }
        if val != nil {
            m.SetThreatState(val.(*WindowsMalwareThreatState))
        }
        return nil
    }
    return res
}
// GetInitialDetectionDateTime gets the initialDetectionDateTime property value. Initial detection datetime of the malware
func (m *MalwareStateForWindowsDevice) GetInitialDetectionDateTime()(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time) {
    val, err := m.GetBackingStore().Get("initialDetectionDateTime")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)
    }
    return nil
}
// GetLastStateChangeDateTime gets the lastStateChangeDateTime property value. The last time this particular threat was changed
func (m *MalwareStateForWindowsDevice) GetLastStateChangeDateTime()(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time) {
    val, err := m.GetBackingStore().Get("lastStateChangeDateTime")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)
    }
    return nil
}
// GetThreatState gets the threatState property value. Indicates threat status of the malware. Possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared. defaults to noStatusCleared. Possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared.
func (m *MalwareStateForWindowsDevice) GetThreatState()(*WindowsMalwareThreatState) {
    val, err := m.GetBackingStore().Get("threatState")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*WindowsMalwareThreatState)
    }
    return nil
}
// Serialize serializes information the current object
func (m *MalwareStateForWindowsDevice) Serialize(writer i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.SerializationWriter)(error) {
    err := m.Entity.Serialize(writer)
    if err != nil {
        return err
    }
    {
        err = writer.WriteInt32Value("detectionCount", m.GetDetectionCount())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteStringValue("deviceName", m.GetDeviceName())
        if err != nil {
            return err
        }
    }
    if m.GetExecutionState() != nil {
        cast := (*m.GetExecutionState()).String()
        err = writer.WriteStringValue("executionState", &cast)
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteTimeValue("initialDetectionDateTime", m.GetInitialDetectionDateTime())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteTimeValue("lastStateChangeDateTime", m.GetLastStateChangeDateTime())
        if err != nil {
            return err
        }
    }
    if m.GetThreatState() != nil {
        cast := (*m.GetThreatState()).String()
        err = writer.WriteStringValue("threatState", &cast)
        if err != nil {
            return err
        }
    }
    return nil
}
// SetDetectionCount sets the detectionCount property value. Indicates the number of times the malware is detected
func (m *MalwareStateForWindowsDevice) SetDetectionCount(value *int32)() {
    err := m.GetBackingStore().Set("detectionCount", value)
    if err != nil {
        panic(err)
    }
}
// SetDeviceName sets the deviceName property value. Indicates the name of the device being evaluated for malware state
func (m *MalwareStateForWindowsDevice) SetDeviceName(value *string)() {
    err := m.GetBackingStore().Set("deviceName", value)
    if err != nil {
        panic(err)
    }
}
// SetExecutionState sets the executionState property value. Indicates execution status of the malware. Possible values are: unknown, blocked, allowed, running, notRunning. Defaults to unknown. Possible values are: unknown, blocked, allowed, running, notRunning.
func (m *MalwareStateForWindowsDevice) SetExecutionState(value *WindowsMalwareExecutionState)() {
    err := m.GetBackingStore().Set("executionState", value)
    if err != nil {
        panic(err)
    }
}
// SetInitialDetectionDateTime sets the initialDetectionDateTime property value. Initial detection datetime of the malware
func (m *MalwareStateForWindowsDevice) SetInitialDetectionDateTime(value *i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)() {
    err := m.GetBackingStore().Set("initialDetectionDateTime", value)
    if err != nil {
        panic(err)
    }
}
// SetLastStateChangeDateTime sets the lastStateChangeDateTime property value. The last time this particular threat was changed
func (m *MalwareStateForWindowsDevice) SetLastStateChangeDateTime(value *i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)() {
    err := m.GetBackingStore().Set("lastStateChangeDateTime", value)
    if err != nil {
        panic(err)
    }
}
// SetThreatState sets the threatState property value. Indicates threat status of the malware. Possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared. defaults to noStatusCleared. Possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared.
func (m *MalwareStateForWindowsDevice) SetThreatState(value *WindowsMalwareThreatState)() {
    err := m.GetBackingStore().Set("threatState", value)
    if err != nil {
        panic(err)
    }
}
// MalwareStateForWindowsDeviceable 
type MalwareStateForWindowsDeviceable interface {
    Entityable
    i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable
    GetDetectionCount()(*int32)
    GetDeviceName()(*string)
    GetExecutionState()(*WindowsMalwareExecutionState)
    GetInitialDetectionDateTime()(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)
    GetLastStateChangeDateTime()(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)
    GetThreatState()(*WindowsMalwareThreatState)
    SetDetectionCount(value *int32)()
    SetDeviceName(value *string)()
    SetExecutionState(value *WindowsMalwareExecutionState)()
    SetInitialDetectionDateTime(value *i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)()
    SetLastStateChangeDateTime(value *i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)()
    SetThreatState(value *WindowsMalwareThreatState)()
}
