#ifndef __ROCCAT_SKELTR_H__
#define __ROCCAT_SKELTR_H__

/*
 * This file is part of roccat-tools.
 *
 * roccat-tools is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * roccat-tools is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with roccat-tools. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>

G_BEGIN_DECLS

#define USB_DEVICE_ID_ROCCAT_SKELTR 0x2fc6

#define SKELTR_DEVICE_NAME "Skeltr"

enum {
	SKELTR_PROFILE_NUM = 5,
};

typedef enum {
	SKELTR_KEY_TYPE_DISABLED = 0x00,

	SKELTR_KEY_TYPE_SWARM_APP_SLIDE_1 = 0x66,
	SKELTR_KEY_TYPE_SWARM_APP_SLIDE_2 = 0x67,
	SKELTR_KEY_TYPE_SWARM_APP_SLIDE_3 = 0x68,
	SKELTR_KEY_TYPE_SWARM_APP_SLIDE_4 = 0x69,

	SKELTR_KEY_TYPE_SWARM_APP_BACK = 0x6b,

	SKELTR_KEY_TYPE_MULTIMEDIA_MUTE_MICROPHONE = 0x73,
	SKELTR_KEY_TYPE_FOLDER_DESKTOP = 0x74,
	SKELTR_KEY_TYPE_FOLDER_FAVORITES = 0x75,
	SKELTR_KEY_TYPE_FOLDER_FONTS = 0x76,
	SKELTR_KEY_TYPE_FOLDER_MY_DOCUMENTS = 0x77,
	SKELTR_KEY_TYPE_FOLDER_MY_DOWNLOADS = 0x78,
	SKELTR_KEY_TYPE_FOLDER_MY_MUSIC = 0x79,
	SKELTR_KEY_TYPE_FOLDER_MY_PICTURES = 0x7a,
	SKELTR_KEY_TYPE_FOLDER_MY_NETWORK = 0x7b,
	SKELTR_KEY_TYPE_FOLDER_PRINTERS = 0x7c,
	SKELTR_KEY_TYPE_FOLDER_SYSTEM = 0x7d,

	SKELTR_KEY_TYPE_SWARM_APP_MAIN_MENU = 0x80,
	SKELTR_KEY_TYPE_SYSTEM_SHUTDOWN = 0x81,
	SKELTR_KEY_TYPE_SYSTEM_SLEEP = 0x82,
	SKELTR_KEY_TYPE_SYSTEM_WAKE = 0x83,

	SKELTR_KEY_TYPE_TALK_EASYSHIFT_ALL = 0x8c,

	SKELTR_KEY_TYPE_SWARM_APP_SLIDE_NEXT = 0x92,
	SKELTR_KEY_TYPE_SWARM_APP_SLIDE_PREV = 0x93,

	SKELTR_KEY_TYPE_SWARM_APP_NAV_UP = 0x97,
	SKELTR_KEY_TYPE_SWARM_APP_NAV_DOWN = 0x98,
	SKELTR_KEY_TYPE_SWARM_APP_NAV_LEFT = 0x99,
	SKELTR_KEY_TYPE_SWARM_APP_NAV_RIGHT = 0x9a,

	SKELTR_KEY_TYPE_SWARM_APP_ENTER = 0x9c,

	SKELTR_KEY_TYPE_SWARM_APP_CYCLE = 0x9e,
	SKELTR_KEY_TYPE_SYSTEM_HIBERNATE = 0x9f,
	SKELTR_KEY_TYPE_SYSTEM_REBOOT = 0xa0,
	SKELTR_KEY_TYPE_SYSTEM_LOCK = 0xa1,
	SKELTR_KEY_TYPE_SYSTEM_LOGOFF = 0xa2,
	SKELTR_KEY_TYPE_LIGHT = 0xa3,

	SKELTR_KEY_TYPE_BROWSER_NEW_TAB = 0xa5,
	SKELTR_KEY_TYPE_BROWSER_NEW_WINDOW = 0xa6,
	SKELTR_KEY_TYPE_RECORD = 0xa7,
	SKELTR_KEY_TYPE_SYSTEM_CONTROL_PANEL = 0xa8,
	SKELTR_KEY_TYPE_SYSTEM_SYSTEM_PANEL = 0xa9,
	SKELTR_KEY_TYPE_SYSTEM_TASK_MANAGER = 0xaa,
	SKELTR_KEY_TYPE_SYSTEM_SCREEN_SETTINGS = 0xab,
	SKELTR_KEY_TYPE_SYSTEM_SCREENSAVER = 0xac,
	SKELTR_KEY_TYPE_SYSTEM_THEMES = 0xad,
	SKELTR_KEY_TYPE_SYSTEM_DATE_TIME = 0xae,
	SKELTR_KEY_TYPE_SYSTEM_NETWORK_SETTINGS = 0xaf,
	SKELTR_KEY_TYPE_PROFILE_UP = 0xb0,
	SKELTR_KEY_TYPE_PROFILE_DOWN = 0xb1,
	SKELTR_KEY_TYPE_PROFILE_CYCLE = 0xb2,

	SKELTR_KEY_TYPE_SHORTCUT = 0xb8,
	SKELTR_KEY_TYPE_OPEN_APP = 0xb9,

	SKELTR_KEY_TYPE_TIMER = 0xbc,
	SKELTR_KEY_TYPE_TIMER_STOP = 0xbd,
	SKELTR_KEY_TYPE_MACRO = 0xbe,

	SKELTR_KEY_TYPE_APP_EMAIL = 0xc0,
	SKELTR_KEY_TYPE_APP_CALCULATOR = 0xc1,
	SKELTR_KEY_TYPE_APP_MY_COMPUTER = 0xc2,
	SKELTR_KEY_TYPE_APP_BROWSER = 0xc3,
	SKELTR_KEY_TYPE_BROWSER_SEARCH = 0xc4,
	SKELTR_KEY_TYPE_BROWSER_HOME = 0xc5,
	SKELTR_KEY_TYPE_BROWSER_BACK = 0xc6,
	SKELTR_KEY_TYPE_BROWSER_FORWARD = 0xc7,
	SKELTR_KEY_TYPE_BROWSER_STOP = 0xc8,
	SKELTR_KEY_TYPE_BROWSER_REFRESH = 0xc9,

	SKELTR_KEY_TYPE_MULTIMEDIA_OPEN_PLAYER = 0xcb,
	SKELTR_KEY_TYPE_MULTIMEDIA_PLAY_PAUSE = 0xcc,
	SKELTR_KEY_TYPE_MULTIMEDIA_NEXT_TRACK = 0xcd,
	SKELTR_KEY_TYPE_MULTIMEDIA_PREVIOUS_TRACK = 0xce,
	SKELTR_KEY_TYPE_MULTIMEDIA_STOP = 0xcf,
	SKELTR_KEY_TYPE_MULTIMEDIA_VOLUME_UP = 0xd0,
	SKELTR_KEY_TYPE_MULTIMEDIA_VOLUME_DOWN = 0xd1,
	SKELTR_KEY_TYPE_MULTIMEDIA_MUTE_MASTER_VOLUME = 0xd2,
	SKELTR_KEY_TYPE_SHIFT_1 = 0xd3,
	SKELTR_KEY_TYPE_SHIFT_2 = 0xd4,
	SKELTR_KEY_TYPE_SHIFT_3 = 0xd5,
	SKELTR_KEY_TYPE_SHIFT_4 = 0xd6,
	SKELTR_KEY_TYPE_SHIFT_5 = 0xd7,
	SKELTR_KEY_TYPE_CTRL_1 = 0xd8,
	SKELTR_KEY_TYPE_CTRL_2 = 0xd9,
	SKELTR_KEY_TYPE_CTRL_3 = 0xda,
	SKELTR_KEY_TYPE_CTRL_4 = 0xdb,
	SKELTR_KEY_TYPE_CTRL_5 = 0xdc,
	SKELTR_KEY_TYPE_OPEN_DRIVER = 0xdd,

	SKELTR_KEY_TYPE_SYSTEM_ADMIN_PANEL = 0xe8,
	SKELTR_KEY_TYPE_SYSTEM_WINDOWS_FIREWALL = 0xe9,
	SKELTR_KEY_TYPE_SYSTEM_REGEDIT = 0xea,
	SKELTR_KEY_TYPE_SYSTEM_EVENT_MONITOR = 0xeb,
	SKELTR_KEY_TYPE_SYSTEM_PERFORMANCE_MONITOR = 0xec,
	SKELTR_KEY_TYPE_SYSTEM_SOUND_SETTINGS = 0xed,
	SKELTR_KEY_TYPE_SYSTEM_INTERNET_SETTINGS = 0xee,
	SKELTR_KEY_TYPE_SYSTEM_DIRECTX_DIAG = 0xef,
	SKELTR_KEY_TYPE_APP_COMMANDLINE = 0xf0,
	SKELTR_KEY_TYPE_FN = 0xf1,
	SKELTR_KEY_TYPE_OPEN_DOCUMENT = 0xf2,
	SKELTR_KEY_TYPE_OPEN_FOLDER = 0xf3,
	SKELTR_KEY_TYPE_OPEN_WEBSITE = 0xf4,

	SKELTR_KEY_TYPE_EASYSHIFT = 0xff,
} SkeltrKeyType;
G_END_DECLS

#endif
