/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import megamek.common.ITerrain;
import megamek.common.Terrains;

public class Terrain
implements ITerrain,
Serializable {
    private static final long serialVersionUID = -7624691566755134033L;
    private final int type;
    private int level;
    private boolean exitsSpecified = false;
    private int exits;
    private int terrainFactor;

    public Terrain(int n, int n2) {
        this(n, n2, false, 0);
    }

    public Terrain(int n, int n2, boolean bl, int n3) {
        this.type = n;
        this.level = n2;
        this.exitsSpecified = bl;
        this.exits = n3;
        this.terrainFactor = Terrains.getTerrainFactor(n, n2);
    }

    public Terrain(ITerrain iTerrain) {
        this.type = iTerrain.getType();
        this.level = iTerrain.getLevel();
        this.exitsSpecified = iTerrain.hasExitsSpecified();
        this.exits = iTerrain.getExits();
        this.terrainFactor = iTerrain.getTerrainFactor();
    }

    public Terrain(String string) {
        int n = string.indexOf(58);
        int n2 = string.lastIndexOf(58);
        String string2 = string.substring(0, n);
        this.type = Terrains.getType(string2);
        if (n == n2) {
            this.level = Terrain.levelFor(string.substring(n + 1));
            this.exitsSpecified = false;
            if (this.type == 22 || this.type == 29) {
                this.exitsSpecified = true;
            }
        } else {
            this.level = Terrain.levelFor(string.substring(n + 1, n2));
            this.exitsSpecified = true;
            this.exits = Terrain.levelFor(string.substring(n2 + 1));
        }
        this.terrainFactor = Terrains.getTerrainFactor(this.type, this.level);
    }

    public static int levelFor(String string) {
        if (string.equals("*")) {
            return Integer.MAX_VALUE;
        }
        return Integer.parseInt(string);
    }

    public int getType() {
        return this.type;
    }

    public int getLevel() {
        return this.level;
    }

    public int getTerrainFactor() {
        return this.terrainFactor;
    }

    public void setTerrainFactor(int n) {
        this.terrainFactor = n;
    }

    public int getExits() {
        return this.exits;
    }

    public boolean hasExitsSpecified() {
        return this.exitsSpecified;
    }

    public void setExits(int n) {
        this.exits = n;
    }

    public void setExit(int n, boolean bl) {
        int n2 = (int)Math.pow(2.0, n);
        this.exits = bl ? (this.exits |= n2) : (this.exits &= 0x3F ^ n2);
    }

    public void flipExits(boolean bl, boolean bl2) {
        if (!bl && !bl2) {
            return;
        }
        int n = 0;
        if (0 != (this.exits & 1) && bl2) {
            n |= 8;
        }
        if (0 != (this.exits & 2)) {
            if (bl2 && bl) {
                n |= 0x10;
            } else if (bl) {
                n |= 0x20;
            } else if (bl2) {
                n |= 4;
            }
        }
        if (0 != (this.exits & 4)) {
            if (bl2 && bl) {
                n |= 0x20;
            } else if (bl) {
                n |= 0x10;
            } else if (bl2) {
                n |= 2;
            }
        }
        if (0 != (this.exits & 8) && bl2) {
            n |= 1;
        }
        if (0 != (this.exits & 0x10)) {
            if (bl2 && bl) {
                n |= 2;
            } else if (bl) {
                n |= 4;
            } else if (bl2) {
                n |= 0x20;
            }
        }
        if (0 != (this.exits & 0x20)) {
            if (bl2 && bl) {
                n |= 4;
            } else if (bl) {
                n |= 2;
            } else if (bl2) {
                n |= 0x10;
            }
        }
        this.setExits(n);
    }

    public boolean exitsTo(ITerrain iTerrain) {
        if (iTerrain == null) {
            return false;
        }
        return this.type == iTerrain.getType() && this.level == iTerrain.getLevel();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof ITerrain)) {
            return false;
        }
        ITerrain iTerrain = (ITerrain)object;
        return this.type == iTerrain.getType() && this.level == iTerrain.getLevel();
    }

    public String toString() {
        return Terrains.getName(this.type) + ":" + this.level + (this.exitsSpecified ? ":" + this.exits : "");
    }

    public int pilotingModifier(int n) {
        switch (this.type) {
            case 5: {
                return this.level;
            }
            case 8: {
                return this.level == 2 ? 4 : 1;
            }
            case 6: 
            case 7: {
                return 1;
            }
            case 18: {
                return this.level == 2 ? 1 : 0;
            }
            case 14: {
                if (n == 5 || n == 15) {
                    return 0;
                }
                if (n == 1 || n == 2) {
                    return 1;
                }
                return 2;
            }
            case 15: {
                if (n == 1 || n == 2 || n == 5 || n == 15) {
                    return 0;
                }
                return 1;
            }
            case 4: 
            case 21: {
                if (this.level == 2) {
                    return 1;
                }
                return 0;
            }
            case 16: {
                if (this.level == 2) {
                    return 3;
                }
                return 2;
            }
            case 17: {
                if (n == 5 || n == 15) {
                    return 0;
                }
                return 4;
            }
            case 10: {
                return 1;
            }
        }
        return 0;
    }

    public int movementCost(int n) {
        switch (this.type) {
            case 8: {
                return this.level - 1;
            }
            case 21: {
                if (this.level == 2) {
                    return 1;
                }
                return 0;
            }
            case 4: {
                return 1;
            }
            case 1: {
                return this.level;
            }
            case 5: {
                return this.level + 1;
            }
            case 18: {
                if (this.level == 2) {
                    if (n == 5 || n == 15) {
                        return 0;
                    }
                    return 1;
                }
                if (n == 4 || n == 12 || n == 10 || n == 11) {
                    return 1;
                }
                return 0;
            }
            case 15: {
                if (n == 1 || n == 2 || n == 5 || n == 15) {
                    return 0;
                }
                return 1;
            }
            case 14: {
                if (n == 5 || n == 15) {
                    return 0;
                }
                if (n == 1 || n == 2) {
                    return 1;
                }
                return 2;
            }
            case 17: {
                if (n == 5 || n == 15) {
                    return 0;
                }
                return 1;
            }
            case 3: 
            case 16: {
                if (this.level == 2) {
                    return 2;
                }
                return 1;
            }
            case 6: {
                if (n == 4 || n == 12 || n == 10 || n == 11) {
                    return 1;
                }
                return 0;
            }
            case 10: {
                if (n == 1 || n == 2) {
                    return 1;
                }
                return 0;
            }
        }
        return 0;
    }

    public int ignitionModifier() {
        switch (this.type) {
            case 5: {
                return 1;
            }
            case 18: {
                if (this.level == 2) {
                    return 2;
                }
                return 0;
            }
            case 9: {
                return -1;
            }
        }
        return 0;
    }

    public int getBogDownModifier(int n, boolean bl) {
        if (n == 5 || n == 15) {
            return Integer.MIN_VALUE;
        }
        switch (this.type) {
            case 14: {
                if (this.level > 1) {
                    return 0x7FFFFFFE;
                }
                if (n == 6) {
                    return 0x7FFFFFFE;
                }
                return 0;
            }
            case 8: {
                if (this.level == 2) {
                    return 0;
                }
                return Integer.MIN_VALUE;
            }
            case 15: {
                if (n == 1 || n == 2) {
                    return Integer.MIN_VALUE;
                }
            }
            case 7: {
                return -1;
            }
            case 18: {
                if (this.level == 2) {
                    return -1;
                }
                return Integer.MIN_VALUE;
            }
            case 6: {
                if (bl) {
                    return 0;
                }
                return Integer.MIN_VALUE;
            }
        }
        return Integer.MIN_VALUE;
    }

    public int getUnstuckModifier(int n) {
        switch (this.type) {
            case 14: {
                if (this.level > 1) {
                    return 3 + -3 * n;
                }
                return 0;
            }
            case 7: {
                return -1;
            }
            case 18: {
                return -1;
            }
        }
        return 0;
    }
}

