/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.StringTokenizer;
import megamek.common.IHex;
import megamek.common.ITerrain;
import megamek.common.ITerrainFactory;
import megamek.common.Terrains;

public class Hex
implements IHex,
Serializable {
    private static final long serialVersionUID = 82483704768044696L;
    private int elevation;
    private ITerrain[] terrains;
    private String theme;
    private int fireTurn;

    public Hex() {
        this(0);
    }

    public Hex(int n) {
        this(n, new ITerrain[Terrains.SIZE], null);
    }

    public Hex(int n, ITerrain[] iTerrainArray, String string) {
        this.elevation = n;
        this.terrains = iTerrainArray;
        this.theme = string == null || string.length() > 0 ? string : null;
    }

    public Hex(int n, String string, String string2) {
        this(n, new ITerrain[Terrains.SIZE], string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
        while (stringTokenizer.hasMoreTokens()) {
            this.addTerrain(Terrains.getTerrainFactory().createTerrain(stringTokenizer.nextToken()));
        }
    }

    public int getElevation() {
        return this.elevation;
    }

    public void setElevation(int n) {
        this.elevation = n;
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String string) {
        this.theme = string;
    }

    public void clearExits() {
        for (int i = 0; i < Terrains.SIZE; ++i) {
            ITerrain iTerrain = this.getTerrain(i);
            if (iTerrain == null || iTerrain.hasExitsSpecified()) continue;
            iTerrain.setExits(0);
        }
    }

    public void setExits(IHex iHex, int n) {
        this.setExits(iHex, n, true);
    }

    public void setExits(IHex iHex, int n, boolean bl) {
        for (int i = 0; i < Terrains.SIZE; ++i) {
            ITerrain iTerrain = this.getTerrain(i);
            if (iTerrain == null || iTerrain.hasExitsSpecified()) continue;
            ITerrain iTerrain2 = iHex != null ? iHex.getTerrain(i) : null;
            iTerrain.setExit(n, iTerrain.exitsTo(iTerrain2));
            if (iHex == null || !bl || iTerrain.getType() != 13 || !iHex.containsTerrain(12)) continue;
            iTerrain.setExit(n, true);
        }
    }

    public boolean containsTerrainExit(int n, int n2) {
        int n3;
        int n4;
        boolean bl = false;
        ITerrain iTerrain = this.getTerrain(n);
        if (n2 >= 0 && n2 <= 5 && iTerrain != null && ((n4 = iTerrain.getExits()) & (n3 = (int)Math.pow(2.0, n2))) > 0) {
            bl = true;
        }
        return bl;
    }

    public int ceiling() {
        int n = 0;
        if (this.containsTerrain(9)) {
            n = 1;
        }
        if (this.containsTerrain(1) || this.containsTerrain(5)) {
            n = 2;
        }
        if (this.terrainLevel(1) > 2 || this.terrainLevel(5) > 2) {
            n = 3;
        }
        if (n < this.terrainLevel(10)) {
            n = this.terrainLevel(10);
        }
        if (n < this.terrainLevel(24)) {
            n = this.terrainLevel(24);
        }
        if (n < this.terrainLevel(28)) {
            n = this.terrainLevel(28);
        }
        return this.elevation + n;
    }

    public int surface() {
        return this.elevation;
    }

    public int floor() {
        return this.elevation - this.depth();
    }

    public int depth() {
        int n = 0;
        ITerrain iTerrain = this.getTerrain(2);
        ITerrain iTerrain2 = this.getTerrain(25);
        if (iTerrain != null) {
            n += iTerrain.getLevel();
        }
        if (iTerrain2 != null) {
            n += iTerrain2.getLevel();
        }
        return n;
    }

    public boolean containsTerrain(int n) {
        return this.getTerrain(n) != null;
    }

    public boolean containsTerrain(int n, int n2) {
        ITerrain iTerrain = this.getTerrain(n);
        if (iTerrain != null) {
            return iTerrain.getLevel() == n2;
        }
        return false;
    }

    public boolean hasPavement() {
        return this.containsTerrain(12) || this.containsTerrain(13) || this.containsTerrain(26);
    }

    public int terrainLevel(int n) {
        ITerrain iTerrain = this.getTerrain(n);
        if (iTerrain != null) {
            return iTerrain.getLevel();
        }
        return Integer.MIN_VALUE;
    }

    public ITerrain getTerrain(int n) {
        return this.terrains[n];
    }

    public void addTerrain(ITerrain iTerrain) {
        this.terrains[iTerrain.getType()] = iTerrain;
    }

    public void removeTerrain(int n) {
        this.terrains[n] = null;
    }

    public void removeAllTerrains() {
        for (int i = 0; i < this.terrains.length; ++i) {
            this.terrains[i] = null;
        }
    }

    public int displayableTerrainsPresent() {
        int n = 0;
        for (int i = 0; i < this.terrains.length; ++i) {
            if (null == this.terrains[i] || null == Terrains.getDisplayName(i, this.terrains[i].getLevel())) continue;
            ++n;
        }
        return n;
    }

    public int terrainsPresent() {
        int n = 0;
        for (int i = 0; i < this.terrains.length; ++i) {
            if (this.terrains[i] == null) continue;
            ++n;
        }
        return n;
    }

    public IHex duplicate() {
        ITerrain[] iTerrainArray = new ITerrain[this.terrains.length];
        ITerrainFactory iTerrainFactory = Terrains.getTerrainFactory();
        for (int i = 0; i < this.terrains.length; ++i) {
            if (this.terrains[i] == null) continue;
            iTerrainArray[i] = iTerrainFactory.createTerrain(this.terrains[i]);
        }
        return new Hex(this.elevation, iTerrainArray, this.theme);
    }

    public int terrainPilotingModifier(int n) {
        int n2 = 0;
        for (int i = 0; i < this.terrains.length; ++i) {
            if (this.terrains[i] == null) continue;
            n2 += this.terrains[i].pilotingModifier(n);
        }
        return n2;
    }

    public int movementCost(int n) {
        int n2 = 0;
        for (int i = 0; i < this.terrains.length; ++i) {
            if (this.terrains[i] == null) continue;
            n2 += this.terrains[i].movementCost(n);
        }
        return n2;
    }

    public String toString() {
        String string = "Elevation: " + this.getElevation();
        string = string + "  Features: ";
        for (ITerrain iTerrain : this.terrains) {
            if (iTerrain == null) continue;
            switch (iTerrain.getType()) {
                case 1: {
                    if (iTerrain.getLevel() == 2) {
                        string = string + "Heavy Woods";
                        break;
                    }
                    if (iTerrain.getLevel() == 1) {
                        string = string + "Light Woods";
                        break;
                    }
                    string = string + "??? Woods";
                    break;
                }
                case 2: {
                    string = string + "Water, depth: " + iTerrain.getLevel();
                    break;
                }
                case 13: {
                    string = string + "Road";
                    break;
                }
                case 3: {
                    string = string + "Rough";
                    break;
                }
                case 4: {
                    string = string + "Rubble";
                    break;
                }
                case 14: {
                    string = string + "Swamp";
                    break;
                }
                case 38: {
                    string = string + "Arm";
                    break;
                }
                case 39: {
                    string = string + "Leg";
                    break;
                }
                default: {
                    string = string + Terrains.getName(iTerrain.getType()) + "(" + iTerrain.getLevel() + ", " + iTerrain.getTerrainFactor() + ")";
                }
            }
            string = string + "; ";
        }
        return string;
    }

    public int getIgnitionModifier() {
        int n = 0;
        for (int i = 0; i < this.terrains.length; ++i) {
            if (this.terrains[i] == null) continue;
            n += this.terrains[i].ignitionModifier();
        }
        return n;
    }

    public boolean isIgnitable() {
        return this.containsTerrain(1) || this.containsTerrain(5) || this.containsTerrain(22) || this.containsTerrain(29) || this.containsTerrain(9) || this.containsTerrain(10);
    }

    public int getFireTurn() {
        return this.fireTurn;
    }

    public void incrementFireTurn() {
        ++this.fireTurn;
    }

    public void resetFireTurn() {
        this.fireTurn = 0;
    }

    public int getBogDownModifier(int n, boolean bl) {
        int n2 = Integer.MIN_VALUE;
        for (int i = 0; i < this.terrains.length; ++i) {
            if (this.terrains[i] == null || n2 >= this.terrains[i].getBogDownModifier(n, bl)) continue;
            n2 = this.terrains[i].getBogDownModifier(n, bl);
        }
        return n2;
    }

    public int getUnstuckModifier(int n) {
        int n2 = 0;
        for (int i = 0; i < this.terrains.length; ++i) {
            if (this.terrains[i] == null) continue;
            n2 += this.terrains[i].getUnstuckModifier(n);
        }
        return n2;
    }
}

