// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

//go:build go1.16
// +build go1.16

package bedrockruntime

import (
	"bytes"
	"context"
	"io/ioutil"
	"net/http"
	"reflect"
	"strings"
	"sync"
	"testing"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/corehandlers"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/awstesting/unit"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/eventstream"
	"github.com/aws/aws-sdk-go/private/protocol/eventstream/eventstreamapi"
	"github.com/aws/aws-sdk-go/private/protocol/eventstream/eventstreamtest"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

var _ time.Time
var _ awserr.Error
var _ context.Context
var _ sync.WaitGroup
var _ strings.Reader

func TestConverseStream_Read(t *testing.T) {
	expectEvents, eventMsgs := mockConverseStreamReadEvents()
	sess, cleanupFn, err := eventstreamtest.SetupEventStreamSession(t,
		eventstreamtest.ServeEventStream{
			T:      t,
			Events: eventMsgs,
		},
		true,
	)
	if err != nil {
		t.Fatalf("expect no error, %v", err)
	}
	defer cleanupFn()

	svc := New(sess)
	resp, err := svc.ConverseStream(nil)
	if err != nil {
		t.Fatalf("expect no error got, %v", err)
	}
	defer resp.GetStream().Close()

	var i int
	for event := range resp.GetStream().Events() {
		if event == nil {
			t.Errorf("%d, expect event, got nil", i)
		}
		if e, a := expectEvents[i], event; !reflect.DeepEqual(e, a) {
			t.Errorf("%d, expect %T %v, got %T %v", i, e, e, a, a)
		}
		i++
	}

	if err := resp.GetStream().Err(); err != nil {
		t.Errorf("expect no error, %v", err)
	}
}

func TestConverseStream_ReadClose(t *testing.T) {
	_, eventMsgs := mockConverseStreamReadEvents()
	sess, cleanupFn, err := eventstreamtest.SetupEventStreamSession(t,
		eventstreamtest.ServeEventStream{
			T:      t,
			Events: eventMsgs,
		},
		true,
	)
	if err != nil {
		t.Fatalf("expect no error, %v", err)
	}
	defer cleanupFn()

	svc := New(sess)
	resp, err := svc.ConverseStream(nil)
	if err != nil {
		t.Fatalf("expect no error got, %v", err)
	}

	// Assert calling Err before close does not close the stream.
	resp.GetStream().Err()
	select {
	case _, ok := <-resp.GetStream().Events():
		if !ok {
			t.Fatalf("expect stream not to be closed, but was")
		}
	default:
	}

	resp.GetStream().Close()
	<-resp.GetStream().Events()

	if err := resp.GetStream().Err(); err != nil {
		t.Errorf("expect no error, %v", err)
	}
}

func TestConverseStream_ReadUnknownEvent(t *testing.T) {
	expectEvents, eventMsgs := mockConverseStreamReadEvents()
	var eventOffset int

	unknownEvent := eventstream.Message{
		Headers: eventstream.Headers{
			eventstreamtest.EventMessageTypeHeader,
			{
				Name:  eventstreamapi.EventTypeHeader,
				Value: eventstream.StringValue("UnknownEventName"),
			},
		},
		Payload: []byte("some unknown event"),
	}

	eventMsgs = append(eventMsgs[:eventOffset],
		append([]eventstream.Message{unknownEvent}, eventMsgs[eventOffset:]...)...)

	expectEvents = append(expectEvents[:eventOffset],
		append([]ConverseStreamOutput_Event{
			&ConverseStreamOutput_UnknownEvent{
				Type:    "UnknownEventName",
				Message: unknownEvent,
			},
		},
			expectEvents[eventOffset:]...)...)

	sess, cleanupFn, err := eventstreamtest.SetupEventStreamSession(t,
		eventstreamtest.ServeEventStream{
			T:      t,
			Events: eventMsgs,
		},
		true,
	)
	if err != nil {
		t.Fatalf("expect no error, %v", err)
	}
	defer cleanupFn()

	svc := New(sess)
	resp, err := svc.ConverseStream(nil)
	if err != nil {
		t.Fatalf("expect no error got, %v", err)
	}
	defer resp.GetStream().Close()

	var i int
	for event := range resp.GetStream().Events() {
		if event == nil {
			t.Errorf("%d, expect event, got nil", i)
		}
		if e, a := expectEvents[i], event; !reflect.DeepEqual(e, a) {
			t.Errorf("%d, expect %T %v, got %T %v", i, e, e, a, a)
		}
		i++
	}

	if err := resp.GetStream().Err(); err != nil {
		t.Errorf("expect no error, %v", err)
	}
}

func BenchmarkConverseStream_Read(b *testing.B) {
	_, eventMsgs := mockConverseStreamReadEvents()
	var buf bytes.Buffer
	encoder := eventstream.NewEncoder(&buf)
	for _, msg := range eventMsgs {
		if err := encoder.Encode(msg); err != nil {
			b.Fatalf("failed to encode message, %v", err)
		}
	}
	stream := &loopReader{source: bytes.NewReader(buf.Bytes())}

	sess := unit.Session
	svc := New(sess, &aws.Config{
		Endpoint:               aws.String("https://example.com"),
		DisableParamValidation: aws.Bool(true),
	})
	svc.Handlers.Send.Swap(corehandlers.SendHandler.Name,
		request.NamedHandler{Name: "mockSend",
			Fn: func(r *request.Request) {
				r.HTTPResponse = &http.Response{
					Status:     "200 OK",
					StatusCode: 200,
					Header:     http.Header{},
					Body:       ioutil.NopCloser(stream),
				}
			},
		},
	)

	resp, err := svc.ConverseStream(nil)
	if err != nil {
		b.Fatalf("failed to create request, %v", err)
	}
	defer resp.GetStream().Close()
	b.ResetTimer()

	for i := 0; i < b.N; i++ {
		if err = resp.GetStream().Err(); err != nil {
			b.Fatalf("expect no error, got %v", err)
		}
		event := <-resp.GetStream().Events()
		if event == nil {
			b.Fatalf("expect event, got nil, %v, %d", resp.GetStream().Err(), i)
		}
	}
}

func mockConverseStreamReadEvents() (
	[]ConverseStreamOutput_Event,
	[]eventstream.Message,
) {
	expectEvents := []ConverseStreamOutput_Event{
		&ContentBlockDeltaEvent{
			ContentBlockIndex: aws.Int64(123),
			Delta: &ContentBlockDelta{
				Text: aws.String("string value goes here"),
				ToolUse: &ToolUseBlockDelta{
					Input: aws.String("string value goes here"),
				},
			},
		},
		&ContentBlockStartEvent{
			ContentBlockIndex: aws.Int64(123),
			Start: &ContentBlockStart{
				ToolUse: &ToolUseBlockStart{
					Name:      aws.String("string value goes here"),
					ToolUseId: aws.String("string value goes here"),
				},
			},
		},
		&ContentBlockStopEvent{
			ContentBlockIndex: aws.Int64(123),
		},
		&MessageStartEvent{
			Role: aws.String("string value goes here"),
		},
		&MessageStopEvent{
			StopReason: aws.String("string value goes here"),
		},
		&ConverseStreamMetadataEvent{
			Metrics: &ConverseStreamMetrics{
				LatencyMs: aws.Int64(1234),
			},
			Trace: &ConverseStreamTrace{
				Guardrail: &GuardrailTraceAssessment{
					InputAssessment: map[string]*GuardrailAssessment{
						"a": {
							ContentPolicy: &GuardrailContentPolicyAssessment{
								Filters: []*GuardrailContentFilter{
									{
										Action:     aws.String("string value goes here"),
										Confidence: aws.String("string value goes here"),
										Type:       aws.String("string value goes here"),
									},
									{
										Action:     aws.String("string value goes here"),
										Confidence: aws.String("string value goes here"),
										Type:       aws.String("string value goes here"),
									},
									{
										Action:     aws.String("string value goes here"),
										Confidence: aws.String("string value goes here"),
										Type:       aws.String("string value goes here"),
									},
								},
							},
							ContextualGroundingPolicy: &GuardrailContextualGroundingPolicyAssessment{
								Filters: []*GuardrailContextualGroundingFilter{
									{
										Action:    aws.String("string value goes here"),
										Score:     aws.Float64(123.45),
										Threshold: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
									{
										Action:    aws.String("string value goes here"),
										Score:     aws.Float64(123.45),
										Threshold: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
									{
										Action:    aws.String("string value goes here"),
										Score:     aws.Float64(123.45),
										Threshold: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
								},
							},
							SensitiveInformationPolicy: &GuardrailSensitiveInformationPolicyAssessment{
								PiiEntities: []*GuardrailPiiEntityFilter{
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
										Type:   aws.String("string value goes here"),
									},
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
										Type:   aws.String("string value goes here"),
									},
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
										Type:   aws.String("string value goes here"),
									},
								},
								Regexes: []*GuardrailRegexFilter{
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
										Name:   aws.String("string value goes here"),
										Regex:  aws.String("string value goes here"),
									},
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
										Name:   aws.String("string value goes here"),
										Regex:  aws.String("string value goes here"),
									},
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
										Name:   aws.String("string value goes here"),
										Regex:  aws.String("string value goes here"),
									},
								},
							},
							TopicPolicy: &GuardrailTopicPolicyAssessment{
								Topics: []*GuardrailTopic{
									{
										Action: aws.String("string value goes here"),
										Name:   aws.String("string value goes here"),
										Type:   aws.String("string value goes here"),
									},
									{
										Action: aws.String("string value goes here"),
										Name:   aws.String("string value goes here"),
										Type:   aws.String("string value goes here"),
									},
									{
										Action: aws.String("string value goes here"),
										Name:   aws.String("string value goes here"),
										Type:   aws.String("string value goes here"),
									},
								},
							},
							WordPolicy: &GuardrailWordPolicyAssessment{
								CustomWords: []*GuardrailCustomWord{
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
									},
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
									},
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
									},
								},
								ManagedWordLists: []*GuardrailManagedWord{
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
										Type:   aws.String("string value goes here"),
									},
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
										Type:   aws.String("string value goes here"),
									},
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
										Type:   aws.String("string value goes here"),
									},
								},
							},
						},
						"b": {
							ContentPolicy: &GuardrailContentPolicyAssessment{
								Filters: []*GuardrailContentFilter{
									{
										Action:     aws.String("string value goes here"),
										Confidence: aws.String("string value goes here"),
										Type:       aws.String("string value goes here"),
									},
									{
										Action:     aws.String("string value goes here"),
										Confidence: aws.String("string value goes here"),
										Type:       aws.String("string value goes here"),
									},
									{
										Action:     aws.String("string value goes here"),
										Confidence: aws.String("string value goes here"),
										Type:       aws.String("string value goes here"),
									},
								},
							},
							ContextualGroundingPolicy: &GuardrailContextualGroundingPolicyAssessment{
								Filters: []*GuardrailContextualGroundingFilter{
									{
										Action:    aws.String("string value goes here"),
										Score:     aws.Float64(123.45),
										Threshold: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
									{
										Action:    aws.String("string value goes here"),
										Score:     aws.Float64(123.45),
										Threshold: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
									{
										Action:    aws.String("string value goes here"),
										Score:     aws.Float64(123.45),
										Threshold: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
								},
							},
							SensitiveInformationPolicy: &GuardrailSensitiveInformationPolicyAssessment{
								PiiEntities: []*GuardrailPiiEntityFilter{
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
										Type:   aws.String("string value goes here"),
									},
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
										Type:   aws.String("string value goes here"),
									},
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
										Type:   aws.String("string value goes here"),
									},
								},
								Regexes: []*GuardrailRegexFilter{
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
										Name:   aws.String("string value goes here"),
										Regex:  aws.String("string value goes here"),
									},
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
										Name:   aws.String("string value goes here"),
										Regex:  aws.String("string value goes here"),
									},
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
										Name:   aws.String("string value goes here"),
										Regex:  aws.String("string value goes here"),
									},
								},
							},
							TopicPolicy: &GuardrailTopicPolicyAssessment{
								Topics: []*GuardrailTopic{
									{
										Action: aws.String("string value goes here"),
										Name:   aws.String("string value goes here"),
										Type:   aws.String("string value goes here"),
									},
									{
										Action: aws.String("string value goes here"),
										Name:   aws.String("string value goes here"),
										Type:   aws.String("string value goes here"),
									},
									{
										Action: aws.String("string value goes here"),
										Name:   aws.String("string value goes here"),
										Type:   aws.String("string value goes here"),
									},
								},
							},
							WordPolicy: &GuardrailWordPolicyAssessment{
								CustomWords: []*GuardrailCustomWord{
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
									},
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
									},
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
									},
								},
								ManagedWordLists: []*GuardrailManagedWord{
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
										Type:   aws.String("string value goes here"),
									},
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
										Type:   aws.String("string value goes here"),
									},
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
										Type:   aws.String("string value goes here"),
									},
								},
							},
						},
						"c": {
							ContentPolicy: &GuardrailContentPolicyAssessment{
								Filters: []*GuardrailContentFilter{
									{
										Action:     aws.String("string value goes here"),
										Confidence: aws.String("string value goes here"),
										Type:       aws.String("string value goes here"),
									},
									{
										Action:     aws.String("string value goes here"),
										Confidence: aws.String("string value goes here"),
										Type:       aws.String("string value goes here"),
									},
									{
										Action:     aws.String("string value goes here"),
										Confidence: aws.String("string value goes here"),
										Type:       aws.String("string value goes here"),
									},
								},
							},
							ContextualGroundingPolicy: &GuardrailContextualGroundingPolicyAssessment{
								Filters: []*GuardrailContextualGroundingFilter{
									{
										Action:    aws.String("string value goes here"),
										Score:     aws.Float64(123.45),
										Threshold: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
									{
										Action:    aws.String("string value goes here"),
										Score:     aws.Float64(123.45),
										Threshold: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
									{
										Action:    aws.String("string value goes here"),
										Score:     aws.Float64(123.45),
										Threshold: aws.Float64(123.45),
										Type:      aws.String("string value goes here"),
									},
								},
							},
							SensitiveInformationPolicy: &GuardrailSensitiveInformationPolicyAssessment{
								PiiEntities: []*GuardrailPiiEntityFilter{
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
										Type:   aws.String("string value goes here"),
									},
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
										Type:   aws.String("string value goes here"),
									},
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
										Type:   aws.String("string value goes here"),
									},
								},
								Regexes: []*GuardrailRegexFilter{
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
										Name:   aws.String("string value goes here"),
										Regex:  aws.String("string value goes here"),
									},
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
										Name:   aws.String("string value goes here"),
										Regex:  aws.String("string value goes here"),
									},
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
										Name:   aws.String("string value goes here"),
										Regex:  aws.String("string value goes here"),
									},
								},
							},
							TopicPolicy: &GuardrailTopicPolicyAssessment{
								Topics: []*GuardrailTopic{
									{
										Action: aws.String("string value goes here"),
										Name:   aws.String("string value goes here"),
										Type:   aws.String("string value goes here"),
									},
									{
										Action: aws.String("string value goes here"),
										Name:   aws.String("string value goes here"),
										Type:   aws.String("string value goes here"),
									},
									{
										Action: aws.String("string value goes here"),
										Name:   aws.String("string value goes here"),
										Type:   aws.String("string value goes here"),
									},
								},
							},
							WordPolicy: &GuardrailWordPolicyAssessment{
								CustomWords: []*GuardrailCustomWord{
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
									},
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
									},
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
									},
								},
								ManagedWordLists: []*GuardrailManagedWord{
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
										Type:   aws.String("string value goes here"),
									},
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
										Type:   aws.String("string value goes here"),
									},
									{
										Action: aws.String("string value goes here"),
										Match:  aws.String("string value goes here"),
										Type:   aws.String("string value goes here"),
									},
								},
							},
						},
					},
					ModelOutput: []*string{
						aws.String("string value goes here"),
						aws.String("string value goes here"),
						aws.String("string value goes here"),
					},
					OutputAssessments: map[string][]*GuardrailAssessment{
						"a": {
							{
								ContentPolicy: &GuardrailContentPolicyAssessment{
									Filters: []*GuardrailContentFilter{
										{
											Action:     aws.String("string value goes here"),
											Confidence: aws.String("string value goes here"),
											Type:       aws.String("string value goes here"),
										},
										{
											Action:     aws.String("string value goes here"),
											Confidence: aws.String("string value goes here"),
											Type:       aws.String("string value goes here"),
										},
										{
											Action:     aws.String("string value goes here"),
											Confidence: aws.String("string value goes here"),
											Type:       aws.String("string value goes here"),
										},
									},
								},
								ContextualGroundingPolicy: &GuardrailContextualGroundingPolicyAssessment{
									Filters: []*GuardrailContextualGroundingFilter{
										{
											Action:    aws.String("string value goes here"),
											Score:     aws.Float64(123.45),
											Threshold: aws.Float64(123.45),
											Type:      aws.String("string value goes here"),
										},
										{
											Action:    aws.String("string value goes here"),
											Score:     aws.Float64(123.45),
											Threshold: aws.Float64(123.45),
											Type:      aws.String("string value goes here"),
										},
										{
											Action:    aws.String("string value goes here"),
											Score:     aws.Float64(123.45),
											Threshold: aws.Float64(123.45),
											Type:      aws.String("string value goes here"),
										},
									},
								},
								SensitiveInformationPolicy: &GuardrailSensitiveInformationPolicyAssessment{
									PiiEntities: []*GuardrailPiiEntityFilter{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
									},
									Regexes: []*GuardrailRegexFilter{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Regex:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Regex:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Regex:  aws.String("string value goes here"),
										},
									},
								},
								TopicPolicy: &GuardrailTopicPolicyAssessment{
									Topics: []*GuardrailTopic{
										{
											Action: aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
									},
								},
								WordPolicy: &GuardrailWordPolicyAssessment{
									CustomWords: []*GuardrailCustomWord{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
										},
									},
									ManagedWordLists: []*GuardrailManagedWord{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
									},
								},
							},
							{
								ContentPolicy: &GuardrailContentPolicyAssessment{
									Filters: []*GuardrailContentFilter{
										{
											Action:     aws.String("string value goes here"),
											Confidence: aws.String("string value goes here"),
											Type:       aws.String("string value goes here"),
										},
										{
											Action:     aws.String("string value goes here"),
											Confidence: aws.String("string value goes here"),
											Type:       aws.String("string value goes here"),
										},
										{
											Action:     aws.String("string value goes here"),
											Confidence: aws.String("string value goes here"),
											Type:       aws.String("string value goes here"),
										},
									},
								},
								ContextualGroundingPolicy: &GuardrailContextualGroundingPolicyAssessment{
									Filters: []*GuardrailContextualGroundingFilter{
										{
											Action:    aws.String("string value goes here"),
											Score:     aws.Float64(123.45),
											Threshold: aws.Float64(123.45),
											Type:      aws.String("string value goes here"),
										},
										{
											Action:    aws.String("string value goes here"),
											Score:     aws.Float64(123.45),
											Threshold: aws.Float64(123.45),
											Type:      aws.String("string value goes here"),
										},
										{
											Action:    aws.String("string value goes here"),
											Score:     aws.Float64(123.45),
											Threshold: aws.Float64(123.45),
											Type:      aws.String("string value goes here"),
										},
									},
								},
								SensitiveInformationPolicy: &GuardrailSensitiveInformationPolicyAssessment{
									PiiEntities: []*GuardrailPiiEntityFilter{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
									},
									Regexes: []*GuardrailRegexFilter{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Regex:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Regex:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Regex:  aws.String("string value goes here"),
										},
									},
								},
								TopicPolicy: &GuardrailTopicPolicyAssessment{
									Topics: []*GuardrailTopic{
										{
											Action: aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
									},
								},
								WordPolicy: &GuardrailWordPolicyAssessment{
									CustomWords: []*GuardrailCustomWord{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
										},
									},
									ManagedWordLists: []*GuardrailManagedWord{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
									},
								},
							},
							{
								ContentPolicy: &GuardrailContentPolicyAssessment{
									Filters: []*GuardrailContentFilter{
										{
											Action:     aws.String("string value goes here"),
											Confidence: aws.String("string value goes here"),
											Type:       aws.String("string value goes here"),
										},
										{
											Action:     aws.String("string value goes here"),
											Confidence: aws.String("string value goes here"),
											Type:       aws.String("string value goes here"),
										},
										{
											Action:     aws.String("string value goes here"),
											Confidence: aws.String("string value goes here"),
											Type:       aws.String("string value goes here"),
										},
									},
								},
								ContextualGroundingPolicy: &GuardrailContextualGroundingPolicyAssessment{
									Filters: []*GuardrailContextualGroundingFilter{
										{
											Action:    aws.String("string value goes here"),
											Score:     aws.Float64(123.45),
											Threshold: aws.Float64(123.45),
											Type:      aws.String("string value goes here"),
										},
										{
											Action:    aws.String("string value goes here"),
											Score:     aws.Float64(123.45),
											Threshold: aws.Float64(123.45),
											Type:      aws.String("string value goes here"),
										},
										{
											Action:    aws.String("string value goes here"),
											Score:     aws.Float64(123.45),
											Threshold: aws.Float64(123.45),
											Type:      aws.String("string value goes here"),
										},
									},
								},
								SensitiveInformationPolicy: &GuardrailSensitiveInformationPolicyAssessment{
									PiiEntities: []*GuardrailPiiEntityFilter{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
									},
									Regexes: []*GuardrailRegexFilter{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Regex:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Regex:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Regex:  aws.String("string value goes here"),
										},
									},
								},
								TopicPolicy: &GuardrailTopicPolicyAssessment{
									Topics: []*GuardrailTopic{
										{
											Action: aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
									},
								},
								WordPolicy: &GuardrailWordPolicyAssessment{
									CustomWords: []*GuardrailCustomWord{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
										},
									},
									ManagedWordLists: []*GuardrailManagedWord{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
									},
								},
							},
						},
						"b": {
							{
								ContentPolicy: &GuardrailContentPolicyAssessment{
									Filters: []*GuardrailContentFilter{
										{
											Action:     aws.String("string value goes here"),
											Confidence: aws.String("string value goes here"),
											Type:       aws.String("string value goes here"),
										},
										{
											Action:     aws.String("string value goes here"),
											Confidence: aws.String("string value goes here"),
											Type:       aws.String("string value goes here"),
										},
										{
											Action:     aws.String("string value goes here"),
											Confidence: aws.String("string value goes here"),
											Type:       aws.String("string value goes here"),
										},
									},
								},
								ContextualGroundingPolicy: &GuardrailContextualGroundingPolicyAssessment{
									Filters: []*GuardrailContextualGroundingFilter{
										{
											Action:    aws.String("string value goes here"),
											Score:     aws.Float64(123.45),
											Threshold: aws.Float64(123.45),
											Type:      aws.String("string value goes here"),
										},
										{
											Action:    aws.String("string value goes here"),
											Score:     aws.Float64(123.45),
											Threshold: aws.Float64(123.45),
											Type:      aws.String("string value goes here"),
										},
										{
											Action:    aws.String("string value goes here"),
											Score:     aws.Float64(123.45),
											Threshold: aws.Float64(123.45),
											Type:      aws.String("string value goes here"),
										},
									},
								},
								SensitiveInformationPolicy: &GuardrailSensitiveInformationPolicyAssessment{
									PiiEntities: []*GuardrailPiiEntityFilter{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
									},
									Regexes: []*GuardrailRegexFilter{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Regex:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Regex:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Regex:  aws.String("string value goes here"),
										},
									},
								},
								TopicPolicy: &GuardrailTopicPolicyAssessment{
									Topics: []*GuardrailTopic{
										{
											Action: aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
									},
								},
								WordPolicy: &GuardrailWordPolicyAssessment{
									CustomWords: []*GuardrailCustomWord{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
										},
									},
									ManagedWordLists: []*GuardrailManagedWord{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
									},
								},
							},
							{
								ContentPolicy: &GuardrailContentPolicyAssessment{
									Filters: []*GuardrailContentFilter{
										{
											Action:     aws.String("string value goes here"),
											Confidence: aws.String("string value goes here"),
											Type:       aws.String("string value goes here"),
										},
										{
											Action:     aws.String("string value goes here"),
											Confidence: aws.String("string value goes here"),
											Type:       aws.String("string value goes here"),
										},
										{
											Action:     aws.String("string value goes here"),
											Confidence: aws.String("string value goes here"),
											Type:       aws.String("string value goes here"),
										},
									},
								},
								ContextualGroundingPolicy: &GuardrailContextualGroundingPolicyAssessment{
									Filters: []*GuardrailContextualGroundingFilter{
										{
											Action:    aws.String("string value goes here"),
											Score:     aws.Float64(123.45),
											Threshold: aws.Float64(123.45),
											Type:      aws.String("string value goes here"),
										},
										{
											Action:    aws.String("string value goes here"),
											Score:     aws.Float64(123.45),
											Threshold: aws.Float64(123.45),
											Type:      aws.String("string value goes here"),
										},
										{
											Action:    aws.String("string value goes here"),
											Score:     aws.Float64(123.45),
											Threshold: aws.Float64(123.45),
											Type:      aws.String("string value goes here"),
										},
									},
								},
								SensitiveInformationPolicy: &GuardrailSensitiveInformationPolicyAssessment{
									PiiEntities: []*GuardrailPiiEntityFilter{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
									},
									Regexes: []*GuardrailRegexFilter{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Regex:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Regex:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Regex:  aws.String("string value goes here"),
										},
									},
								},
								TopicPolicy: &GuardrailTopicPolicyAssessment{
									Topics: []*GuardrailTopic{
										{
											Action: aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
									},
								},
								WordPolicy: &GuardrailWordPolicyAssessment{
									CustomWords: []*GuardrailCustomWord{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
										},
									},
									ManagedWordLists: []*GuardrailManagedWord{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
									},
								},
							},
							{
								ContentPolicy: &GuardrailContentPolicyAssessment{
									Filters: []*GuardrailContentFilter{
										{
											Action:     aws.String("string value goes here"),
											Confidence: aws.String("string value goes here"),
											Type:       aws.String("string value goes here"),
										},
										{
											Action:     aws.String("string value goes here"),
											Confidence: aws.String("string value goes here"),
											Type:       aws.String("string value goes here"),
										},
										{
											Action:     aws.String("string value goes here"),
											Confidence: aws.String("string value goes here"),
											Type:       aws.String("string value goes here"),
										},
									},
								},
								ContextualGroundingPolicy: &GuardrailContextualGroundingPolicyAssessment{
									Filters: []*GuardrailContextualGroundingFilter{
										{
											Action:    aws.String("string value goes here"),
											Score:     aws.Float64(123.45),
											Threshold: aws.Float64(123.45),
											Type:      aws.String("string value goes here"),
										},
										{
											Action:    aws.String("string value goes here"),
											Score:     aws.Float64(123.45),
											Threshold: aws.Float64(123.45),
											Type:      aws.String("string value goes here"),
										},
										{
											Action:    aws.String("string value goes here"),
											Score:     aws.Float64(123.45),
											Threshold: aws.Float64(123.45),
											Type:      aws.String("string value goes here"),
										},
									},
								},
								SensitiveInformationPolicy: &GuardrailSensitiveInformationPolicyAssessment{
									PiiEntities: []*GuardrailPiiEntityFilter{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
									},
									Regexes: []*GuardrailRegexFilter{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Regex:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Regex:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Regex:  aws.String("string value goes here"),
										},
									},
								},
								TopicPolicy: &GuardrailTopicPolicyAssessment{
									Topics: []*GuardrailTopic{
										{
											Action: aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
									},
								},
								WordPolicy: &GuardrailWordPolicyAssessment{
									CustomWords: []*GuardrailCustomWord{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
										},
									},
									ManagedWordLists: []*GuardrailManagedWord{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
									},
								},
							},
						},
						"c": {
							{
								ContentPolicy: &GuardrailContentPolicyAssessment{
									Filters: []*GuardrailContentFilter{
										{
											Action:     aws.String("string value goes here"),
											Confidence: aws.String("string value goes here"),
											Type:       aws.String("string value goes here"),
										},
										{
											Action:     aws.String("string value goes here"),
											Confidence: aws.String("string value goes here"),
											Type:       aws.String("string value goes here"),
										},
										{
											Action:     aws.String("string value goes here"),
											Confidence: aws.String("string value goes here"),
											Type:       aws.String("string value goes here"),
										},
									},
								},
								ContextualGroundingPolicy: &GuardrailContextualGroundingPolicyAssessment{
									Filters: []*GuardrailContextualGroundingFilter{
										{
											Action:    aws.String("string value goes here"),
											Score:     aws.Float64(123.45),
											Threshold: aws.Float64(123.45),
											Type:      aws.String("string value goes here"),
										},
										{
											Action:    aws.String("string value goes here"),
											Score:     aws.Float64(123.45),
											Threshold: aws.Float64(123.45),
											Type:      aws.String("string value goes here"),
										},
										{
											Action:    aws.String("string value goes here"),
											Score:     aws.Float64(123.45),
											Threshold: aws.Float64(123.45),
											Type:      aws.String("string value goes here"),
										},
									},
								},
								SensitiveInformationPolicy: &GuardrailSensitiveInformationPolicyAssessment{
									PiiEntities: []*GuardrailPiiEntityFilter{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
									},
									Regexes: []*GuardrailRegexFilter{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Regex:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Regex:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Regex:  aws.String("string value goes here"),
										},
									},
								},
								TopicPolicy: &GuardrailTopicPolicyAssessment{
									Topics: []*GuardrailTopic{
										{
											Action: aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
									},
								},
								WordPolicy: &GuardrailWordPolicyAssessment{
									CustomWords: []*GuardrailCustomWord{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
										},
									},
									ManagedWordLists: []*GuardrailManagedWord{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
									},
								},
							},
							{
								ContentPolicy: &GuardrailContentPolicyAssessment{
									Filters: []*GuardrailContentFilter{
										{
											Action:     aws.String("string value goes here"),
											Confidence: aws.String("string value goes here"),
											Type:       aws.String("string value goes here"),
										},
										{
											Action:     aws.String("string value goes here"),
											Confidence: aws.String("string value goes here"),
											Type:       aws.String("string value goes here"),
										},
										{
											Action:     aws.String("string value goes here"),
											Confidence: aws.String("string value goes here"),
											Type:       aws.String("string value goes here"),
										},
									},
								},
								ContextualGroundingPolicy: &GuardrailContextualGroundingPolicyAssessment{
									Filters: []*GuardrailContextualGroundingFilter{
										{
											Action:    aws.String("string value goes here"),
											Score:     aws.Float64(123.45),
											Threshold: aws.Float64(123.45),
											Type:      aws.String("string value goes here"),
										},
										{
											Action:    aws.String("string value goes here"),
											Score:     aws.Float64(123.45),
											Threshold: aws.Float64(123.45),
											Type:      aws.String("string value goes here"),
										},
										{
											Action:    aws.String("string value goes here"),
											Score:     aws.Float64(123.45),
											Threshold: aws.Float64(123.45),
											Type:      aws.String("string value goes here"),
										},
									},
								},
								SensitiveInformationPolicy: &GuardrailSensitiveInformationPolicyAssessment{
									PiiEntities: []*GuardrailPiiEntityFilter{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
									},
									Regexes: []*GuardrailRegexFilter{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Regex:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Regex:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Regex:  aws.String("string value goes here"),
										},
									},
								},
								TopicPolicy: &GuardrailTopicPolicyAssessment{
									Topics: []*GuardrailTopic{
										{
											Action: aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
									},
								},
								WordPolicy: &GuardrailWordPolicyAssessment{
									CustomWords: []*GuardrailCustomWord{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
										},
									},
									ManagedWordLists: []*GuardrailManagedWord{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
									},
								},
							},
							{
								ContentPolicy: &GuardrailContentPolicyAssessment{
									Filters: []*GuardrailContentFilter{
										{
											Action:     aws.String("string value goes here"),
											Confidence: aws.String("string value goes here"),
											Type:       aws.String("string value goes here"),
										},
										{
											Action:     aws.String("string value goes here"),
											Confidence: aws.String("string value goes here"),
											Type:       aws.String("string value goes here"),
										},
										{
											Action:     aws.String("string value goes here"),
											Confidence: aws.String("string value goes here"),
											Type:       aws.String("string value goes here"),
										},
									},
								},
								ContextualGroundingPolicy: &GuardrailContextualGroundingPolicyAssessment{
									Filters: []*GuardrailContextualGroundingFilter{
										{
											Action:    aws.String("string value goes here"),
											Score:     aws.Float64(123.45),
											Threshold: aws.Float64(123.45),
											Type:      aws.String("string value goes here"),
										},
										{
											Action:    aws.String("string value goes here"),
											Score:     aws.Float64(123.45),
											Threshold: aws.Float64(123.45),
											Type:      aws.String("string value goes here"),
										},
										{
											Action:    aws.String("string value goes here"),
											Score:     aws.Float64(123.45),
											Threshold: aws.Float64(123.45),
											Type:      aws.String("string value goes here"),
										},
									},
								},
								SensitiveInformationPolicy: &GuardrailSensitiveInformationPolicyAssessment{
									PiiEntities: []*GuardrailPiiEntityFilter{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
									},
									Regexes: []*GuardrailRegexFilter{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Regex:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Regex:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Regex:  aws.String("string value goes here"),
										},
									},
								},
								TopicPolicy: &GuardrailTopicPolicyAssessment{
									Topics: []*GuardrailTopic{
										{
											Action: aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Name:   aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
									},
								},
								WordPolicy: &GuardrailWordPolicyAssessment{
									CustomWords: []*GuardrailCustomWord{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
										},
									},
									ManagedWordLists: []*GuardrailManagedWord{
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
										{
											Action: aws.String("string value goes here"),
											Match:  aws.String("string value goes here"),
											Type:   aws.String("string value goes here"),
										},
									},
								},
							},
						},
					},
				},
			},
			Usage: &TokenUsage{
				InputTokens:  aws.Int64(123),
				OutputTokens: aws.Int64(123),
				TotalTokens:  aws.Int64(123),
			},
		},
	}

	var marshalers request.HandlerList
	marshalers.PushBackNamed(restjson.BuildHandler)
	payloadMarshaler := protocol.HandlerPayloadMarshal{
		Marshalers: marshalers,
	}
	_ = payloadMarshaler

	eventMsgs := []eventstream.Message{
		{
			Headers: eventstream.Headers{
				eventstreamtest.EventMessageTypeHeader,
				{
					Name:  eventstreamapi.EventTypeHeader,
					Value: eventstream.StringValue("contentBlockDelta"),
				},
			},
			Payload: eventstreamtest.MarshalEventPayload(payloadMarshaler, expectEvents[0]),
		},
		{
			Headers: eventstream.Headers{
				eventstreamtest.EventMessageTypeHeader,
				{
					Name:  eventstreamapi.EventTypeHeader,
					Value: eventstream.StringValue("contentBlockStart"),
				},
			},
			Payload: eventstreamtest.MarshalEventPayload(payloadMarshaler, expectEvents[1]),
		},
		{
			Headers: eventstream.Headers{
				eventstreamtest.EventMessageTypeHeader,
				{
					Name:  eventstreamapi.EventTypeHeader,
					Value: eventstream.StringValue("contentBlockStop"),
				},
			},
			Payload: eventstreamtest.MarshalEventPayload(payloadMarshaler, expectEvents[2]),
		},
		{
			Headers: eventstream.Headers{
				eventstreamtest.EventMessageTypeHeader,
				{
					Name:  eventstreamapi.EventTypeHeader,
					Value: eventstream.StringValue("messageStart"),
				},
			},
			Payload: eventstreamtest.MarshalEventPayload(payloadMarshaler, expectEvents[3]),
		},
		{
			Headers: eventstream.Headers{
				eventstreamtest.EventMessageTypeHeader,
				{
					Name:  eventstreamapi.EventTypeHeader,
					Value: eventstream.StringValue("messageStop"),
				},
			},
			Payload: eventstreamtest.MarshalEventPayload(payloadMarshaler, expectEvents[4]),
		},
		{
			Headers: eventstream.Headers{
				eventstreamtest.EventMessageTypeHeader,
				{
					Name:  eventstreamapi.EventTypeHeader,
					Value: eventstream.StringValue("metadata"),
				},
			},
			Payload: eventstreamtest.MarshalEventPayload(payloadMarshaler, expectEvents[5]),
		},
	}

	return expectEvents, eventMsgs
}
func TestConverseStream_ReadException(t *testing.T) {
	expectEvents := []ConverseStreamOutput_Event{
		&InternalServerException{
			RespMetadata: protocol.ResponseMetadata{
				StatusCode: 200,
			},
			Message_: aws.String("string value goes here"),
		},
	}

	var marshalers request.HandlerList
	marshalers.PushBackNamed(restjson.BuildHandler)
	payloadMarshaler := protocol.HandlerPayloadMarshal{
		Marshalers: marshalers,
	}

	eventMsgs := []eventstream.Message{
		{
			Headers: eventstream.Headers{
				eventstreamtest.EventExceptionTypeHeader,
				{
					Name:  eventstreamapi.ExceptionTypeHeader,
					Value: eventstream.StringValue("internalServerException"),
				},
			},
			Payload: eventstreamtest.MarshalEventPayload(payloadMarshaler, expectEvents[0]),
		},
	}

	sess, cleanupFn, err := eventstreamtest.SetupEventStreamSession(t,
		eventstreamtest.ServeEventStream{
			T:      t,
			Events: eventMsgs,
		},
		true,
	)
	if err != nil {
		t.Fatalf("expect no error, %v", err)
	}
	defer cleanupFn()

	svc := New(sess)
	resp, err := svc.ConverseStream(nil)
	if err != nil {
		t.Fatalf("expect no error got, %v", err)
	}

	defer resp.GetStream().Close()

	<-resp.GetStream().Events()

	err = resp.GetStream().Err()
	if err == nil {
		t.Fatalf("expect err, got none")
	}

	expectErr := &InternalServerException{
		RespMetadata: protocol.ResponseMetadata{
			StatusCode: 200,
		},
		Message_: aws.String("string value goes here"),
	}
	aerr, ok := err.(awserr.Error)
	if !ok {
		t.Errorf("expect exception, got %T, %#v", err, err)
	}
	if e, a := expectErr.Code(), aerr.Code(); e != a {
		t.Errorf("expect %v, got %v", e, a)
	}
	if e, a := expectErr.Message(), aerr.Message(); e != a {
		t.Errorf("expect %v, got %v", e, a)
	}

	if e, a := expectErr, aerr; !reflect.DeepEqual(e, a) {
		t.Errorf("expect error %+#v, got %+#v", e, a)
	}
}

var _ awserr.Error = (*InternalServerException)(nil)
var _ awserr.Error = (*ModelStreamErrorException)(nil)
var _ awserr.Error = (*ServiceUnavailableException)(nil)
var _ awserr.Error = (*ThrottlingException)(nil)
var _ awserr.Error = (*ValidationException)(nil)

func TestInvokeModelWithResponseStream_Read(t *testing.T) {
	expectEvents, eventMsgs := mockInvokeModelWithResponseStreamReadEvents()
	sess, cleanupFn, err := eventstreamtest.SetupEventStreamSession(t,
		eventstreamtest.ServeEventStream{
			T:      t,
			Events: eventMsgs,
		},
		true,
	)
	if err != nil {
		t.Fatalf("expect no error, %v", err)
	}
	defer cleanupFn()

	svc := New(sess)
	resp, err := svc.InvokeModelWithResponseStream(nil)
	if err != nil {
		t.Fatalf("expect no error got, %v", err)
	}
	defer resp.GetStream().Close()

	var i int
	for event := range resp.GetStream().Events() {
		if event == nil {
			t.Errorf("%d, expect event, got nil", i)
		}
		if e, a := expectEvents[i], event; !reflect.DeepEqual(e, a) {
			t.Errorf("%d, expect %T %v, got %T %v", i, e, e, a, a)
		}
		i++
	}

	if err := resp.GetStream().Err(); err != nil {
		t.Errorf("expect no error, %v", err)
	}
}

func TestInvokeModelWithResponseStream_ReadClose(t *testing.T) {
	_, eventMsgs := mockInvokeModelWithResponseStreamReadEvents()
	sess, cleanupFn, err := eventstreamtest.SetupEventStreamSession(t,
		eventstreamtest.ServeEventStream{
			T:      t,
			Events: eventMsgs,
		},
		true,
	)
	if err != nil {
		t.Fatalf("expect no error, %v", err)
	}
	defer cleanupFn()

	svc := New(sess)
	resp, err := svc.InvokeModelWithResponseStream(nil)
	if err != nil {
		t.Fatalf("expect no error got, %v", err)
	}

	// Assert calling Err before close does not close the stream.
	resp.GetStream().Err()
	select {
	case _, ok := <-resp.GetStream().Events():
		if !ok {
			t.Fatalf("expect stream not to be closed, but was")
		}
	default:
	}

	resp.GetStream().Close()
	<-resp.GetStream().Events()

	if err := resp.GetStream().Err(); err != nil {
		t.Errorf("expect no error, %v", err)
	}
}

func TestInvokeModelWithResponseStream_ReadUnknownEvent(t *testing.T) {
	expectEvents, eventMsgs := mockInvokeModelWithResponseStreamReadEvents()
	var eventOffset int

	unknownEvent := eventstream.Message{
		Headers: eventstream.Headers{
			eventstreamtest.EventMessageTypeHeader,
			{
				Name:  eventstreamapi.EventTypeHeader,
				Value: eventstream.StringValue("UnknownEventName"),
			},
		},
		Payload: []byte("some unknown event"),
	}

	eventMsgs = append(eventMsgs[:eventOffset],
		append([]eventstream.Message{unknownEvent}, eventMsgs[eventOffset:]...)...)

	expectEvents = append(expectEvents[:eventOffset],
		append([]ResponseStreamEvent{
			&ResponseStreamUnknownEvent{
				Type:    "UnknownEventName",
				Message: unknownEvent,
			},
		},
			expectEvents[eventOffset:]...)...)

	sess, cleanupFn, err := eventstreamtest.SetupEventStreamSession(t,
		eventstreamtest.ServeEventStream{
			T:      t,
			Events: eventMsgs,
		},
		true,
	)
	if err != nil {
		t.Fatalf("expect no error, %v", err)
	}
	defer cleanupFn()

	svc := New(sess)
	resp, err := svc.InvokeModelWithResponseStream(nil)
	if err != nil {
		t.Fatalf("expect no error got, %v", err)
	}
	defer resp.GetStream().Close()

	var i int
	for event := range resp.GetStream().Events() {
		if event == nil {
			t.Errorf("%d, expect event, got nil", i)
		}
		if e, a := expectEvents[i], event; !reflect.DeepEqual(e, a) {
			t.Errorf("%d, expect %T %v, got %T %v", i, e, e, a, a)
		}
		i++
	}

	if err := resp.GetStream().Err(); err != nil {
		t.Errorf("expect no error, %v", err)
	}
}

func BenchmarkInvokeModelWithResponseStream_Read(b *testing.B) {
	_, eventMsgs := mockInvokeModelWithResponseStreamReadEvents()
	var buf bytes.Buffer
	encoder := eventstream.NewEncoder(&buf)
	for _, msg := range eventMsgs {
		if err := encoder.Encode(msg); err != nil {
			b.Fatalf("failed to encode message, %v", err)
		}
	}
	stream := &loopReader{source: bytes.NewReader(buf.Bytes())}

	sess := unit.Session
	svc := New(sess, &aws.Config{
		Endpoint:               aws.String("https://example.com"),
		DisableParamValidation: aws.Bool(true),
	})
	svc.Handlers.Send.Swap(corehandlers.SendHandler.Name,
		request.NamedHandler{Name: "mockSend",
			Fn: func(r *request.Request) {
				r.HTTPResponse = &http.Response{
					Status:     "200 OK",
					StatusCode: 200,
					Header:     http.Header{},
					Body:       ioutil.NopCloser(stream),
				}
			},
		},
	)

	resp, err := svc.InvokeModelWithResponseStream(nil)
	if err != nil {
		b.Fatalf("failed to create request, %v", err)
	}
	defer resp.GetStream().Close()
	b.ResetTimer()

	for i := 0; i < b.N; i++ {
		if err = resp.GetStream().Err(); err != nil {
			b.Fatalf("expect no error, got %v", err)
		}
		event := <-resp.GetStream().Events()
		if event == nil {
			b.Fatalf("expect event, got nil, %v, %d", resp.GetStream().Err(), i)
		}
	}
}

func mockInvokeModelWithResponseStreamReadEvents() (
	[]ResponseStreamEvent,
	[]eventstream.Message,
) {
	expectEvents := []ResponseStreamEvent{
		&PayloadPart{
			Bytes: []byte("blob value goes here"),
		},
	}

	var marshalers request.HandlerList
	marshalers.PushBackNamed(restjson.BuildHandler)
	payloadMarshaler := protocol.HandlerPayloadMarshal{
		Marshalers: marshalers,
	}
	_ = payloadMarshaler

	eventMsgs := []eventstream.Message{
		{
			Headers: eventstream.Headers{
				eventstreamtest.EventMessageTypeHeader,
				{
					Name:  eventstreamapi.EventTypeHeader,
					Value: eventstream.StringValue("chunk"),
				},
			},
			Payload: eventstreamtest.MarshalEventPayload(payloadMarshaler, expectEvents[0]),
		},
	}

	return expectEvents, eventMsgs
}
func TestInvokeModelWithResponseStream_ReadException(t *testing.T) {
	expectEvents := []ResponseStreamEvent{
		&InternalServerException{
			RespMetadata: protocol.ResponseMetadata{
				StatusCode: 200,
			},
			Message_: aws.String("string value goes here"),
		},
	}

	var marshalers request.HandlerList
	marshalers.PushBackNamed(restjson.BuildHandler)
	payloadMarshaler := protocol.HandlerPayloadMarshal{
		Marshalers: marshalers,
	}

	eventMsgs := []eventstream.Message{
		{
			Headers: eventstream.Headers{
				eventstreamtest.EventExceptionTypeHeader,
				{
					Name:  eventstreamapi.ExceptionTypeHeader,
					Value: eventstream.StringValue("internalServerException"),
				},
			},
			Payload: eventstreamtest.MarshalEventPayload(payloadMarshaler, expectEvents[0]),
		},
	}

	sess, cleanupFn, err := eventstreamtest.SetupEventStreamSession(t,
		eventstreamtest.ServeEventStream{
			T:      t,
			Events: eventMsgs,
		},
		true,
	)
	if err != nil {
		t.Fatalf("expect no error, %v", err)
	}
	defer cleanupFn()

	svc := New(sess)
	resp, err := svc.InvokeModelWithResponseStream(nil)
	if err != nil {
		t.Fatalf("expect no error got, %v", err)
	}

	defer resp.GetStream().Close()

	<-resp.GetStream().Events()

	err = resp.GetStream().Err()
	if err == nil {
		t.Fatalf("expect err, got none")
	}

	expectErr := &InternalServerException{
		RespMetadata: protocol.ResponseMetadata{
			StatusCode: 200,
		},
		Message_: aws.String("string value goes here"),
	}
	aerr, ok := err.(awserr.Error)
	if !ok {
		t.Errorf("expect exception, got %T, %#v", err, err)
	}
	if e, a := expectErr.Code(), aerr.Code(); e != a {
		t.Errorf("expect %v, got %v", e, a)
	}
	if e, a := expectErr.Message(), aerr.Message(); e != a {
		t.Errorf("expect %v, got %v", e, a)
	}

	if e, a := expectErr, aerr; !reflect.DeepEqual(e, a) {
		t.Errorf("expect error %+#v, got %+#v", e, a)
	}
}

var _ awserr.Error = (*InternalServerException)(nil)
var _ awserr.Error = (*ModelStreamErrorException)(nil)
var _ awserr.Error = (*ModelTimeoutException)(nil)
var _ awserr.Error = (*ServiceUnavailableException)(nil)
var _ awserr.Error = (*ThrottlingException)(nil)
var _ awserr.Error = (*ValidationException)(nil)

type loopReader struct {
	source *bytes.Reader
}

func (c *loopReader) Read(p []byte) (int, error) {
	if c.source.Len() == 0 {
		c.source.Seek(0, 0)
	}

	return c.source.Read(p)
}
