// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Specifies a chunk-level location within a document, providing positioning information for cited content using logical document segments or chunks.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct DocumentChunkLocation {
    /// <p>The index of the document within the array of documents provided in the request.</p>
    pub document_index: ::std::option::Option<i32>,
    /// <p>The starting chunk identifier or index of the cited content within the document.</p>
    pub start: ::std::option::Option<i32>,
    /// <p>The ending chunk identifier or index of the cited content within the document.</p>
    pub end: ::std::option::Option<i32>,
}
impl DocumentChunkLocation {
    /// <p>The index of the document within the array of documents provided in the request.</p>
    pub fn document_index(&self) -> ::std::option::Option<i32> {
        self.document_index
    }
    /// <p>The starting chunk identifier or index of the cited content within the document.</p>
    pub fn start(&self) -> ::std::option::Option<i32> {
        self.start
    }
    /// <p>The ending chunk identifier or index of the cited content within the document.</p>
    pub fn end(&self) -> ::std::option::Option<i32> {
        self.end
    }
}
impl DocumentChunkLocation {
    /// Creates a new builder-style object to manufacture [`DocumentChunkLocation`](crate::types::DocumentChunkLocation).
    pub fn builder() -> crate::types::builders::DocumentChunkLocationBuilder {
        crate::types::builders::DocumentChunkLocationBuilder::default()
    }
}

/// A builder for [`DocumentChunkLocation`](crate::types::DocumentChunkLocation).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct DocumentChunkLocationBuilder {
    pub(crate) document_index: ::std::option::Option<i32>,
    pub(crate) start: ::std::option::Option<i32>,
    pub(crate) end: ::std::option::Option<i32>,
}
impl DocumentChunkLocationBuilder {
    /// <p>The index of the document within the array of documents provided in the request.</p>
    pub fn document_index(mut self, input: i32) -> Self {
        self.document_index = ::std::option::Option::Some(input);
        self
    }
    /// <p>The index of the document within the array of documents provided in the request.</p>
    pub fn set_document_index(mut self, input: ::std::option::Option<i32>) -> Self {
        self.document_index = input;
        self
    }
    /// <p>The index of the document within the array of documents provided in the request.</p>
    pub fn get_document_index(&self) -> &::std::option::Option<i32> {
        &self.document_index
    }
    /// <p>The starting chunk identifier or index of the cited content within the document.</p>
    pub fn start(mut self, input: i32) -> Self {
        self.start = ::std::option::Option::Some(input);
        self
    }
    /// <p>The starting chunk identifier or index of the cited content within the document.</p>
    pub fn set_start(mut self, input: ::std::option::Option<i32>) -> Self {
        self.start = input;
        self
    }
    /// <p>The starting chunk identifier or index of the cited content within the document.</p>
    pub fn get_start(&self) -> &::std::option::Option<i32> {
        &self.start
    }
    /// <p>The ending chunk identifier or index of the cited content within the document.</p>
    pub fn end(mut self, input: i32) -> Self {
        self.end = ::std::option::Option::Some(input);
        self
    }
    /// <p>The ending chunk identifier or index of the cited content within the document.</p>
    pub fn set_end(mut self, input: ::std::option::Option<i32>) -> Self {
        self.end = input;
        self
    }
    /// <p>The ending chunk identifier or index of the cited content within the document.</p>
    pub fn get_end(&self) -> &::std::option::Option<i32> {
        &self.end
    }
    /// Consumes the builder and constructs a [`DocumentChunkLocation`](crate::types::DocumentChunkLocation).
    pub fn build(self) -> crate::types::DocumentChunkLocation {
        crate::types::DocumentChunkLocation {
            document_index: self.document_index,
            start: self.start,
            end: self.end,
        }
    }
}
