// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package medicalimagingiface provides an interface to enable mocking the AWS Health Imaging service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package medicalimagingiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/medicalimaging"
)

// MedicalImagingAPI provides an interface to enable mocking the
// medicalimaging.MedicalImaging service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWS Health Imaging.
//	func myFunc(svc medicalimagingiface.MedicalImagingAPI) bool {
//	    // Make svc.CopyImageSet request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := medicalimaging.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockMedicalImagingClient struct {
//	    medicalimagingiface.MedicalImagingAPI
//	}
//	func (m *mockMedicalImagingClient) CopyImageSet(input *medicalimaging.CopyImageSetInput) (*medicalimaging.CopyImageSetOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockMedicalImagingClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type MedicalImagingAPI interface {
	CopyImageSet(*medicalimaging.CopyImageSetInput) (*medicalimaging.CopyImageSetOutput, error)
	CopyImageSetWithContext(aws.Context, *medicalimaging.CopyImageSetInput, ...request.Option) (*medicalimaging.CopyImageSetOutput, error)
	CopyImageSetRequest(*medicalimaging.CopyImageSetInput) (*request.Request, *medicalimaging.CopyImageSetOutput)

	CreateDatastore(*medicalimaging.CreateDatastoreInput) (*medicalimaging.CreateDatastoreOutput, error)
	CreateDatastoreWithContext(aws.Context, *medicalimaging.CreateDatastoreInput, ...request.Option) (*medicalimaging.CreateDatastoreOutput, error)
	CreateDatastoreRequest(*medicalimaging.CreateDatastoreInput) (*request.Request, *medicalimaging.CreateDatastoreOutput)

	DeleteDatastore(*medicalimaging.DeleteDatastoreInput) (*medicalimaging.DeleteDatastoreOutput, error)
	DeleteDatastoreWithContext(aws.Context, *medicalimaging.DeleteDatastoreInput, ...request.Option) (*medicalimaging.DeleteDatastoreOutput, error)
	DeleteDatastoreRequest(*medicalimaging.DeleteDatastoreInput) (*request.Request, *medicalimaging.DeleteDatastoreOutput)

	DeleteImageSet(*medicalimaging.DeleteImageSetInput) (*medicalimaging.DeleteImageSetOutput, error)
	DeleteImageSetWithContext(aws.Context, *medicalimaging.DeleteImageSetInput, ...request.Option) (*medicalimaging.DeleteImageSetOutput, error)
	DeleteImageSetRequest(*medicalimaging.DeleteImageSetInput) (*request.Request, *medicalimaging.DeleteImageSetOutput)

	GetDICOMImportJob(*medicalimaging.GetDICOMImportJobInput) (*medicalimaging.GetDICOMImportJobOutput, error)
	GetDICOMImportJobWithContext(aws.Context, *medicalimaging.GetDICOMImportJobInput, ...request.Option) (*medicalimaging.GetDICOMImportJobOutput, error)
	GetDICOMImportJobRequest(*medicalimaging.GetDICOMImportJobInput) (*request.Request, *medicalimaging.GetDICOMImportJobOutput)

	GetDatastore(*medicalimaging.GetDatastoreInput) (*medicalimaging.GetDatastoreOutput, error)
	GetDatastoreWithContext(aws.Context, *medicalimaging.GetDatastoreInput, ...request.Option) (*medicalimaging.GetDatastoreOutput, error)
	GetDatastoreRequest(*medicalimaging.GetDatastoreInput) (*request.Request, *medicalimaging.GetDatastoreOutput)

	GetImageFrame(*medicalimaging.GetImageFrameInput) (*medicalimaging.GetImageFrameOutput, error)
	GetImageFrameWithContext(aws.Context, *medicalimaging.GetImageFrameInput, ...request.Option) (*medicalimaging.GetImageFrameOutput, error)
	GetImageFrameRequest(*medicalimaging.GetImageFrameInput) (*request.Request, *medicalimaging.GetImageFrameOutput)

	GetImageSet(*medicalimaging.GetImageSetInput) (*medicalimaging.GetImageSetOutput, error)
	GetImageSetWithContext(aws.Context, *medicalimaging.GetImageSetInput, ...request.Option) (*medicalimaging.GetImageSetOutput, error)
	GetImageSetRequest(*medicalimaging.GetImageSetInput) (*request.Request, *medicalimaging.GetImageSetOutput)

	GetImageSetMetadata(*medicalimaging.GetImageSetMetadataInput) (*medicalimaging.GetImageSetMetadataOutput, error)
	GetImageSetMetadataWithContext(aws.Context, *medicalimaging.GetImageSetMetadataInput, ...request.Option) (*medicalimaging.GetImageSetMetadataOutput, error)
	GetImageSetMetadataRequest(*medicalimaging.GetImageSetMetadataInput) (*request.Request, *medicalimaging.GetImageSetMetadataOutput)

	ListDICOMImportJobs(*medicalimaging.ListDICOMImportJobsInput) (*medicalimaging.ListDICOMImportJobsOutput, error)
	ListDICOMImportJobsWithContext(aws.Context, *medicalimaging.ListDICOMImportJobsInput, ...request.Option) (*medicalimaging.ListDICOMImportJobsOutput, error)
	ListDICOMImportJobsRequest(*medicalimaging.ListDICOMImportJobsInput) (*request.Request, *medicalimaging.ListDICOMImportJobsOutput)

	ListDICOMImportJobsPages(*medicalimaging.ListDICOMImportJobsInput, func(*medicalimaging.ListDICOMImportJobsOutput, bool) bool) error
	ListDICOMImportJobsPagesWithContext(aws.Context, *medicalimaging.ListDICOMImportJobsInput, func(*medicalimaging.ListDICOMImportJobsOutput, bool) bool, ...request.Option) error

	ListDatastores(*medicalimaging.ListDatastoresInput) (*medicalimaging.ListDatastoresOutput, error)
	ListDatastoresWithContext(aws.Context, *medicalimaging.ListDatastoresInput, ...request.Option) (*medicalimaging.ListDatastoresOutput, error)
	ListDatastoresRequest(*medicalimaging.ListDatastoresInput) (*request.Request, *medicalimaging.ListDatastoresOutput)

	ListDatastoresPages(*medicalimaging.ListDatastoresInput, func(*medicalimaging.ListDatastoresOutput, bool) bool) error
	ListDatastoresPagesWithContext(aws.Context, *medicalimaging.ListDatastoresInput, func(*medicalimaging.ListDatastoresOutput, bool) bool, ...request.Option) error

	ListImageSetVersions(*medicalimaging.ListImageSetVersionsInput) (*medicalimaging.ListImageSetVersionsOutput, error)
	ListImageSetVersionsWithContext(aws.Context, *medicalimaging.ListImageSetVersionsInput, ...request.Option) (*medicalimaging.ListImageSetVersionsOutput, error)
	ListImageSetVersionsRequest(*medicalimaging.ListImageSetVersionsInput) (*request.Request, *medicalimaging.ListImageSetVersionsOutput)

	ListImageSetVersionsPages(*medicalimaging.ListImageSetVersionsInput, func(*medicalimaging.ListImageSetVersionsOutput, bool) bool) error
	ListImageSetVersionsPagesWithContext(aws.Context, *medicalimaging.ListImageSetVersionsInput, func(*medicalimaging.ListImageSetVersionsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*medicalimaging.ListTagsForResourceInput) (*medicalimaging.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *medicalimaging.ListTagsForResourceInput, ...request.Option) (*medicalimaging.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*medicalimaging.ListTagsForResourceInput) (*request.Request, *medicalimaging.ListTagsForResourceOutput)

	SearchImageSets(*medicalimaging.SearchImageSetsInput) (*medicalimaging.SearchImageSetsOutput, error)
	SearchImageSetsWithContext(aws.Context, *medicalimaging.SearchImageSetsInput, ...request.Option) (*medicalimaging.SearchImageSetsOutput, error)
	SearchImageSetsRequest(*medicalimaging.SearchImageSetsInput) (*request.Request, *medicalimaging.SearchImageSetsOutput)

	SearchImageSetsPages(*medicalimaging.SearchImageSetsInput, func(*medicalimaging.SearchImageSetsOutput, bool) bool) error
	SearchImageSetsPagesWithContext(aws.Context, *medicalimaging.SearchImageSetsInput, func(*medicalimaging.SearchImageSetsOutput, bool) bool, ...request.Option) error

	StartDICOMImportJob(*medicalimaging.StartDICOMImportJobInput) (*medicalimaging.StartDICOMImportJobOutput, error)
	StartDICOMImportJobWithContext(aws.Context, *medicalimaging.StartDICOMImportJobInput, ...request.Option) (*medicalimaging.StartDICOMImportJobOutput, error)
	StartDICOMImportJobRequest(*medicalimaging.StartDICOMImportJobInput) (*request.Request, *medicalimaging.StartDICOMImportJobOutput)

	TagResource(*medicalimaging.TagResourceInput) (*medicalimaging.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *medicalimaging.TagResourceInput, ...request.Option) (*medicalimaging.TagResourceOutput, error)
	TagResourceRequest(*medicalimaging.TagResourceInput) (*request.Request, *medicalimaging.TagResourceOutput)

	UntagResource(*medicalimaging.UntagResourceInput) (*medicalimaging.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *medicalimaging.UntagResourceInput, ...request.Option) (*medicalimaging.UntagResourceOutput, error)
	UntagResourceRequest(*medicalimaging.UntagResourceInput) (*request.Request, *medicalimaging.UntagResourceOutput)

	UpdateImageSetMetadata(*medicalimaging.UpdateImageSetMetadataInput) (*medicalimaging.UpdateImageSetMetadataOutput, error)
	UpdateImageSetMetadataWithContext(aws.Context, *medicalimaging.UpdateImageSetMetadataInput, ...request.Option) (*medicalimaging.UpdateImageSetMetadataOutput, error)
	UpdateImageSetMetadataRequest(*medicalimaging.UpdateImageSetMetadataInput) (*request.Request, *medicalimaging.UpdateImageSetMetadataOutput)
}

var _ MedicalImagingAPI = (*medicalimaging.MedicalImaging)(nil)
