/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// UpdateRotatedSecretSC struct for UpdateRotatedSecretSC
type UpdateRotatedSecretSC struct {
	// List of the new tags that will be attached to this item
	AddTag *[]string `json:"add-tag,omitempty"`
	// Whether to automatically rotate every --rotation-interval days, or disable existing automatic rotation
	AutoRotate *string `json:"auto-rotate,omitempty"`
	// Gateway url
	GatewayUrl *string `json:"gateway-url,omitempty"`
	// The name of a key that used to encrypt the secret value (if empty, the account default protectionKey key will be used)
	Key *string `json:"key,omitempty"`
	// Secret name
	Name string `json:"name"`
	// New item metadata
	NewMetadata *string `json:"new-metadata,omitempty"`
	// New item name
	NewName *string `json:"new-name,omitempty"`
	// Whether to create a new version of not
	NewVersion *bool `json:"new-version,omitempty"`
	// List of the existent tags that will be removed from this item
	RmTag *[]string `json:"rm-tag,omitempty"`
	// The number of days to wait between every automatic key rotation (7-365)
	RotationInterval *string `json:"rotation-interval,omitempty"`
	RotationHour *int32 `json:"rotation_hour,omitempty"`
	RotatorCredsType *string `json:"rotator_creds_type,omitempty"`
	SshPassword *string `json:"ssh-password,omitempty"`
	SshUsername *string `json:"ssh-username,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewUpdateRotatedSecretSC instantiates a new UpdateRotatedSecretSC object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewUpdateRotatedSecretSC(name string, ) *UpdateRotatedSecretSC {
	this := UpdateRotatedSecretSC{}
	var gatewayUrl string = "http://localhost:8000"
	this.GatewayUrl = &gatewayUrl
	this.Name = name
	var newMetadata string = "default_metadata"
	this.NewMetadata = &newMetadata
	var newVersion bool = false
	this.NewVersion = &newVersion
	return &this
}

// NewUpdateRotatedSecretSCWithDefaults instantiates a new UpdateRotatedSecretSC object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewUpdateRotatedSecretSCWithDefaults() *UpdateRotatedSecretSC {
	this := UpdateRotatedSecretSC{}
	var gatewayUrl string = "http://localhost:8000"
	this.GatewayUrl = &gatewayUrl
	var newMetadata string = "default_metadata"
	this.NewMetadata = &newMetadata
	var newVersion bool = false
	this.NewVersion = &newVersion
	return &this
}

// GetAddTag returns the AddTag field value if set, zero value otherwise.
func (o *UpdateRotatedSecretSC) GetAddTag() []string {
	if o == nil || o.AddTag == nil {
		var ret []string
		return ret
	}
	return *o.AddTag
}

// GetAddTagOk returns a tuple with the AddTag field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateRotatedSecretSC) GetAddTagOk() (*[]string, bool) {
	if o == nil || o.AddTag == nil {
		return nil, false
	}
	return o.AddTag, true
}

// HasAddTag returns a boolean if a field has been set.
func (o *UpdateRotatedSecretSC) HasAddTag() bool {
	if o != nil && o.AddTag != nil {
		return true
	}

	return false
}

// SetAddTag gets a reference to the given []string and assigns it to the AddTag field.
func (o *UpdateRotatedSecretSC) SetAddTag(v []string) {
	o.AddTag = &v
}

// GetAutoRotate returns the AutoRotate field value if set, zero value otherwise.
func (o *UpdateRotatedSecretSC) GetAutoRotate() string {
	if o == nil || o.AutoRotate == nil {
		var ret string
		return ret
	}
	return *o.AutoRotate
}

// GetAutoRotateOk returns a tuple with the AutoRotate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateRotatedSecretSC) GetAutoRotateOk() (*string, bool) {
	if o == nil || o.AutoRotate == nil {
		return nil, false
	}
	return o.AutoRotate, true
}

// HasAutoRotate returns a boolean if a field has been set.
func (o *UpdateRotatedSecretSC) HasAutoRotate() bool {
	if o != nil && o.AutoRotate != nil {
		return true
	}

	return false
}

// SetAutoRotate gets a reference to the given string and assigns it to the AutoRotate field.
func (o *UpdateRotatedSecretSC) SetAutoRotate(v string) {
	o.AutoRotate = &v
}

// GetGatewayUrl returns the GatewayUrl field value if set, zero value otherwise.
func (o *UpdateRotatedSecretSC) GetGatewayUrl() string {
	if o == nil || o.GatewayUrl == nil {
		var ret string
		return ret
	}
	return *o.GatewayUrl
}

// GetGatewayUrlOk returns a tuple with the GatewayUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateRotatedSecretSC) GetGatewayUrlOk() (*string, bool) {
	if o == nil || o.GatewayUrl == nil {
		return nil, false
	}
	return o.GatewayUrl, true
}

// HasGatewayUrl returns a boolean if a field has been set.
func (o *UpdateRotatedSecretSC) HasGatewayUrl() bool {
	if o != nil && o.GatewayUrl != nil {
		return true
	}

	return false
}

// SetGatewayUrl gets a reference to the given string and assigns it to the GatewayUrl field.
func (o *UpdateRotatedSecretSC) SetGatewayUrl(v string) {
	o.GatewayUrl = &v
}

// GetKey returns the Key field value if set, zero value otherwise.
func (o *UpdateRotatedSecretSC) GetKey() string {
	if o == nil || o.Key == nil {
		var ret string
		return ret
	}
	return *o.Key
}

// GetKeyOk returns a tuple with the Key field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateRotatedSecretSC) GetKeyOk() (*string, bool) {
	if o == nil || o.Key == nil {
		return nil, false
	}
	return o.Key, true
}

// HasKey returns a boolean if a field has been set.
func (o *UpdateRotatedSecretSC) HasKey() bool {
	if o != nil && o.Key != nil {
		return true
	}

	return false
}

// SetKey gets a reference to the given string and assigns it to the Key field.
func (o *UpdateRotatedSecretSC) SetKey(v string) {
	o.Key = &v
}

// GetName returns the Name field value
func (o *UpdateRotatedSecretSC) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *UpdateRotatedSecretSC) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *UpdateRotatedSecretSC) SetName(v string) {
	o.Name = v
}

// GetNewMetadata returns the NewMetadata field value if set, zero value otherwise.
func (o *UpdateRotatedSecretSC) GetNewMetadata() string {
	if o == nil || o.NewMetadata == nil {
		var ret string
		return ret
	}
	return *o.NewMetadata
}

// GetNewMetadataOk returns a tuple with the NewMetadata field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateRotatedSecretSC) GetNewMetadataOk() (*string, bool) {
	if o == nil || o.NewMetadata == nil {
		return nil, false
	}
	return o.NewMetadata, true
}

// HasNewMetadata returns a boolean if a field has been set.
func (o *UpdateRotatedSecretSC) HasNewMetadata() bool {
	if o != nil && o.NewMetadata != nil {
		return true
	}

	return false
}

// SetNewMetadata gets a reference to the given string and assigns it to the NewMetadata field.
func (o *UpdateRotatedSecretSC) SetNewMetadata(v string) {
	o.NewMetadata = &v
}

// GetNewName returns the NewName field value if set, zero value otherwise.
func (o *UpdateRotatedSecretSC) GetNewName() string {
	if o == nil || o.NewName == nil {
		var ret string
		return ret
	}
	return *o.NewName
}

// GetNewNameOk returns a tuple with the NewName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateRotatedSecretSC) GetNewNameOk() (*string, bool) {
	if o == nil || o.NewName == nil {
		return nil, false
	}
	return o.NewName, true
}

// HasNewName returns a boolean if a field has been set.
func (o *UpdateRotatedSecretSC) HasNewName() bool {
	if o != nil && o.NewName != nil {
		return true
	}

	return false
}

// SetNewName gets a reference to the given string and assigns it to the NewName field.
func (o *UpdateRotatedSecretSC) SetNewName(v string) {
	o.NewName = &v
}

// GetNewVersion returns the NewVersion field value if set, zero value otherwise.
func (o *UpdateRotatedSecretSC) GetNewVersion() bool {
	if o == nil || o.NewVersion == nil {
		var ret bool
		return ret
	}
	return *o.NewVersion
}

// GetNewVersionOk returns a tuple with the NewVersion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateRotatedSecretSC) GetNewVersionOk() (*bool, bool) {
	if o == nil || o.NewVersion == nil {
		return nil, false
	}
	return o.NewVersion, true
}

// HasNewVersion returns a boolean if a field has been set.
func (o *UpdateRotatedSecretSC) HasNewVersion() bool {
	if o != nil && o.NewVersion != nil {
		return true
	}

	return false
}

// SetNewVersion gets a reference to the given bool and assigns it to the NewVersion field.
func (o *UpdateRotatedSecretSC) SetNewVersion(v bool) {
	o.NewVersion = &v
}

// GetRmTag returns the RmTag field value if set, zero value otherwise.
func (o *UpdateRotatedSecretSC) GetRmTag() []string {
	if o == nil || o.RmTag == nil {
		var ret []string
		return ret
	}
	return *o.RmTag
}

// GetRmTagOk returns a tuple with the RmTag field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateRotatedSecretSC) GetRmTagOk() (*[]string, bool) {
	if o == nil || o.RmTag == nil {
		return nil, false
	}
	return o.RmTag, true
}

// HasRmTag returns a boolean if a field has been set.
func (o *UpdateRotatedSecretSC) HasRmTag() bool {
	if o != nil && o.RmTag != nil {
		return true
	}

	return false
}

// SetRmTag gets a reference to the given []string and assigns it to the RmTag field.
func (o *UpdateRotatedSecretSC) SetRmTag(v []string) {
	o.RmTag = &v
}

// GetRotationInterval returns the RotationInterval field value if set, zero value otherwise.
func (o *UpdateRotatedSecretSC) GetRotationInterval() string {
	if o == nil || o.RotationInterval == nil {
		var ret string
		return ret
	}
	return *o.RotationInterval
}

// GetRotationIntervalOk returns a tuple with the RotationInterval field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateRotatedSecretSC) GetRotationIntervalOk() (*string, bool) {
	if o == nil || o.RotationInterval == nil {
		return nil, false
	}
	return o.RotationInterval, true
}

// HasRotationInterval returns a boolean if a field has been set.
func (o *UpdateRotatedSecretSC) HasRotationInterval() bool {
	if o != nil && o.RotationInterval != nil {
		return true
	}

	return false
}

// SetRotationInterval gets a reference to the given string and assigns it to the RotationInterval field.
func (o *UpdateRotatedSecretSC) SetRotationInterval(v string) {
	o.RotationInterval = &v
}

// GetRotationHour returns the RotationHour field value if set, zero value otherwise.
func (o *UpdateRotatedSecretSC) GetRotationHour() int32 {
	if o == nil || o.RotationHour == nil {
		var ret int32
		return ret
	}
	return *o.RotationHour
}

// GetRotationHourOk returns a tuple with the RotationHour field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateRotatedSecretSC) GetRotationHourOk() (*int32, bool) {
	if o == nil || o.RotationHour == nil {
		return nil, false
	}
	return o.RotationHour, true
}

// HasRotationHour returns a boolean if a field has been set.
func (o *UpdateRotatedSecretSC) HasRotationHour() bool {
	if o != nil && o.RotationHour != nil {
		return true
	}

	return false
}

// SetRotationHour gets a reference to the given int32 and assigns it to the RotationHour field.
func (o *UpdateRotatedSecretSC) SetRotationHour(v int32) {
	o.RotationHour = &v
}

// GetRotatorCredsType returns the RotatorCredsType field value if set, zero value otherwise.
func (o *UpdateRotatedSecretSC) GetRotatorCredsType() string {
	if o == nil || o.RotatorCredsType == nil {
		var ret string
		return ret
	}
	return *o.RotatorCredsType
}

// GetRotatorCredsTypeOk returns a tuple with the RotatorCredsType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateRotatedSecretSC) GetRotatorCredsTypeOk() (*string, bool) {
	if o == nil || o.RotatorCredsType == nil {
		return nil, false
	}
	return o.RotatorCredsType, true
}

// HasRotatorCredsType returns a boolean if a field has been set.
func (o *UpdateRotatedSecretSC) HasRotatorCredsType() bool {
	if o != nil && o.RotatorCredsType != nil {
		return true
	}

	return false
}

// SetRotatorCredsType gets a reference to the given string and assigns it to the RotatorCredsType field.
func (o *UpdateRotatedSecretSC) SetRotatorCredsType(v string) {
	o.RotatorCredsType = &v
}

// GetSshPassword returns the SshPassword field value if set, zero value otherwise.
func (o *UpdateRotatedSecretSC) GetSshPassword() string {
	if o == nil || o.SshPassword == nil {
		var ret string
		return ret
	}
	return *o.SshPassword
}

// GetSshPasswordOk returns a tuple with the SshPassword field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateRotatedSecretSC) GetSshPasswordOk() (*string, bool) {
	if o == nil || o.SshPassword == nil {
		return nil, false
	}
	return o.SshPassword, true
}

// HasSshPassword returns a boolean if a field has been set.
func (o *UpdateRotatedSecretSC) HasSshPassword() bool {
	if o != nil && o.SshPassword != nil {
		return true
	}

	return false
}

// SetSshPassword gets a reference to the given string and assigns it to the SshPassword field.
func (o *UpdateRotatedSecretSC) SetSshPassword(v string) {
	o.SshPassword = &v
}

// GetSshUsername returns the SshUsername field value if set, zero value otherwise.
func (o *UpdateRotatedSecretSC) GetSshUsername() string {
	if o == nil || o.SshUsername == nil {
		var ret string
		return ret
	}
	return *o.SshUsername
}

// GetSshUsernameOk returns a tuple with the SshUsername field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateRotatedSecretSC) GetSshUsernameOk() (*string, bool) {
	if o == nil || o.SshUsername == nil {
		return nil, false
	}
	return o.SshUsername, true
}

// HasSshUsername returns a boolean if a field has been set.
func (o *UpdateRotatedSecretSC) HasSshUsername() bool {
	if o != nil && o.SshUsername != nil {
		return true
	}

	return false
}

// SetSshUsername gets a reference to the given string and assigns it to the SshUsername field.
func (o *UpdateRotatedSecretSC) SetSshUsername(v string) {
	o.SshUsername = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *UpdateRotatedSecretSC) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateRotatedSecretSC) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *UpdateRotatedSecretSC) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *UpdateRotatedSecretSC) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *UpdateRotatedSecretSC) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateRotatedSecretSC) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *UpdateRotatedSecretSC) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *UpdateRotatedSecretSC) SetUidToken(v string) {
	o.UidToken = &v
}

func (o UpdateRotatedSecretSC) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AddTag != nil {
		toSerialize["add-tag"] = o.AddTag
	}
	if o.AutoRotate != nil {
		toSerialize["auto-rotate"] = o.AutoRotate
	}
	if o.GatewayUrl != nil {
		toSerialize["gateway-url"] = o.GatewayUrl
	}
	if o.Key != nil {
		toSerialize["key"] = o.Key
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.NewMetadata != nil {
		toSerialize["new-metadata"] = o.NewMetadata
	}
	if o.NewName != nil {
		toSerialize["new-name"] = o.NewName
	}
	if o.NewVersion != nil {
		toSerialize["new-version"] = o.NewVersion
	}
	if o.RmTag != nil {
		toSerialize["rm-tag"] = o.RmTag
	}
	if o.RotationInterval != nil {
		toSerialize["rotation-interval"] = o.RotationInterval
	}
	if o.RotationHour != nil {
		toSerialize["rotation_hour"] = o.RotationHour
	}
	if o.RotatorCredsType != nil {
		toSerialize["rotator_creds_type"] = o.RotatorCredsType
	}
	if o.SshPassword != nil {
		toSerialize["ssh-password"] = o.SshPassword
	}
	if o.SshUsername != nil {
		toSerialize["ssh-username"] = o.SshUsername
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableUpdateRotatedSecretSC struct {
	value *UpdateRotatedSecretSC
	isSet bool
}

func (v NullableUpdateRotatedSecretSC) Get() *UpdateRotatedSecretSC {
	return v.value
}

func (v *NullableUpdateRotatedSecretSC) Set(val *UpdateRotatedSecretSC) {
	v.value = val
	v.isSet = true
}

func (v NullableUpdateRotatedSecretSC) IsSet() bool {
	return v.isSet
}

func (v *NullableUpdateRotatedSecretSC) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableUpdateRotatedSecretSC(val *UpdateRotatedSecretSC) *NullableUpdateRotatedSecretSC {
	return &NullableUpdateRotatedSecretSC{value: val, isSet: true}
}

func (v NullableUpdateRotatedSecretSC) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableUpdateRotatedSecretSC) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


