/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// CreateManagedKey CreateManagedKey is a command that creates managed key
type CreateManagedKey struct {
	// Managed Key type; options: [AES256GCM, RSA2048]
	Alg string `json:"alg"`
	// Base64-encoded managed key value
	ManagedKeyValue *string `json:"managed-key-value,omitempty"`
	// Metadata about the managed key
	Metadata *string `json:"metadata,omitempty"`
	// ManagedKey name
	Name string `json:"name"`
	// The name of a key that used to encrypt the secret value (if empty, the account default protectionKey key will be used)
	ProtectionKey *string `json:"protection_key,omitempty"`
	// List of the tags attached to this managed key
	Tags *[]string `json:"tags,omitempty"`
	// Target name
	TargetName *string `json:"target-name,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewCreateManagedKey instantiates a new CreateManagedKey object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCreateManagedKey(alg string, name string, ) *CreateManagedKey {
	this := CreateManagedKey{}
	this.Alg = alg
	this.Name = name
	return &this
}

// NewCreateManagedKeyWithDefaults instantiates a new CreateManagedKey object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCreateManagedKeyWithDefaults() *CreateManagedKey {
	this := CreateManagedKey{}
	return &this
}

// GetAlg returns the Alg field value
func (o *CreateManagedKey) GetAlg() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Alg
}

// GetAlgOk returns a tuple with the Alg field value
// and a boolean to check if the value has been set.
func (o *CreateManagedKey) GetAlgOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Alg, true
}

// SetAlg sets field value
func (o *CreateManagedKey) SetAlg(v string) {
	o.Alg = v
}

// GetManagedKeyValue returns the ManagedKeyValue field value if set, zero value otherwise.
func (o *CreateManagedKey) GetManagedKeyValue() string {
	if o == nil || o.ManagedKeyValue == nil {
		var ret string
		return ret
	}
	return *o.ManagedKeyValue
}

// GetManagedKeyValueOk returns a tuple with the ManagedKeyValue field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateManagedKey) GetManagedKeyValueOk() (*string, bool) {
	if o == nil || o.ManagedKeyValue == nil {
		return nil, false
	}
	return o.ManagedKeyValue, true
}

// HasManagedKeyValue returns a boolean if a field has been set.
func (o *CreateManagedKey) HasManagedKeyValue() bool {
	if o != nil && o.ManagedKeyValue != nil {
		return true
	}

	return false
}

// SetManagedKeyValue gets a reference to the given string and assigns it to the ManagedKeyValue field.
func (o *CreateManagedKey) SetManagedKeyValue(v string) {
	o.ManagedKeyValue = &v
}

// GetMetadata returns the Metadata field value if set, zero value otherwise.
func (o *CreateManagedKey) GetMetadata() string {
	if o == nil || o.Metadata == nil {
		var ret string
		return ret
	}
	return *o.Metadata
}

// GetMetadataOk returns a tuple with the Metadata field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateManagedKey) GetMetadataOk() (*string, bool) {
	if o == nil || o.Metadata == nil {
		return nil, false
	}
	return o.Metadata, true
}

// HasMetadata returns a boolean if a field has been set.
func (o *CreateManagedKey) HasMetadata() bool {
	if o != nil && o.Metadata != nil {
		return true
	}

	return false
}

// SetMetadata gets a reference to the given string and assigns it to the Metadata field.
func (o *CreateManagedKey) SetMetadata(v string) {
	o.Metadata = &v
}

// GetName returns the Name field value
func (o *CreateManagedKey) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *CreateManagedKey) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *CreateManagedKey) SetName(v string) {
	o.Name = v
}

// GetProtectionKey returns the ProtectionKey field value if set, zero value otherwise.
func (o *CreateManagedKey) GetProtectionKey() string {
	if o == nil || o.ProtectionKey == nil {
		var ret string
		return ret
	}
	return *o.ProtectionKey
}

// GetProtectionKeyOk returns a tuple with the ProtectionKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateManagedKey) GetProtectionKeyOk() (*string, bool) {
	if o == nil || o.ProtectionKey == nil {
		return nil, false
	}
	return o.ProtectionKey, true
}

// HasProtectionKey returns a boolean if a field has been set.
func (o *CreateManagedKey) HasProtectionKey() bool {
	if o != nil && o.ProtectionKey != nil {
		return true
	}

	return false
}

// SetProtectionKey gets a reference to the given string and assigns it to the ProtectionKey field.
func (o *CreateManagedKey) SetProtectionKey(v string) {
	o.ProtectionKey = &v
}

// GetTags returns the Tags field value if set, zero value otherwise.
func (o *CreateManagedKey) GetTags() []string {
	if o == nil || o.Tags == nil {
		var ret []string
		return ret
	}
	return *o.Tags
}

// GetTagsOk returns a tuple with the Tags field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateManagedKey) GetTagsOk() (*[]string, bool) {
	if o == nil || o.Tags == nil {
		return nil, false
	}
	return o.Tags, true
}

// HasTags returns a boolean if a field has been set.
func (o *CreateManagedKey) HasTags() bool {
	if o != nil && o.Tags != nil {
		return true
	}

	return false
}

// SetTags gets a reference to the given []string and assigns it to the Tags field.
func (o *CreateManagedKey) SetTags(v []string) {
	o.Tags = &v
}

// GetTargetName returns the TargetName field value if set, zero value otherwise.
func (o *CreateManagedKey) GetTargetName() string {
	if o == nil || o.TargetName == nil {
		var ret string
		return ret
	}
	return *o.TargetName
}

// GetTargetNameOk returns a tuple with the TargetName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateManagedKey) GetTargetNameOk() (*string, bool) {
	if o == nil || o.TargetName == nil {
		return nil, false
	}
	return o.TargetName, true
}

// HasTargetName returns a boolean if a field has been set.
func (o *CreateManagedKey) HasTargetName() bool {
	if o != nil && o.TargetName != nil {
		return true
	}

	return false
}

// SetTargetName gets a reference to the given string and assigns it to the TargetName field.
func (o *CreateManagedKey) SetTargetName(v string) {
	o.TargetName = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *CreateManagedKey) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateManagedKey) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *CreateManagedKey) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *CreateManagedKey) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *CreateManagedKey) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateManagedKey) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *CreateManagedKey) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *CreateManagedKey) SetUidToken(v string) {
	o.UidToken = &v
}

func (o CreateManagedKey) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["alg"] = o.Alg
	}
	if o.ManagedKeyValue != nil {
		toSerialize["managed-key-value"] = o.ManagedKeyValue
	}
	if o.Metadata != nil {
		toSerialize["metadata"] = o.Metadata
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.ProtectionKey != nil {
		toSerialize["protection_key"] = o.ProtectionKey
	}
	if o.Tags != nil {
		toSerialize["tags"] = o.Tags
	}
	if o.TargetName != nil {
		toSerialize["target-name"] = o.TargetName
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableCreateManagedKey struct {
	value *CreateManagedKey
	isSet bool
}

func (v NullableCreateManagedKey) Get() *CreateManagedKey {
	return v.value
}

func (v *NullableCreateManagedKey) Set(val *CreateManagedKey) {
	v.value = val
	v.isSet = true
}

func (v NullableCreateManagedKey) IsSet() bool {
	return v.isSet
}

func (v *NullableCreateManagedKey) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCreateManagedKey(val *CreateManagedKey) *NullableCreateManagedKey {
	return &NullableCreateManagedKey{value: val, isSet: true}
}

func (v NullableCreateManagedKey) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCreateManagedKey) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


