/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
	"time"
)

// ClientsUsageReport struct for ClientsUsageReport
type ClientsUsageReport struct {
	AccountId *string `json:"account_id,omitempty"`
	Clients *[]ClientUsageInfo `json:"clients,omitempty"`
	Product *string `json:"product,omitempty"`
	Time *time.Time `json:"time,omitempty"`
	TotalClients *int64 `json:"total_clients,omitempty"`
}

// NewClientsUsageReport instantiates a new ClientsUsageReport object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewClientsUsageReport() *ClientsUsageReport {
	this := ClientsUsageReport{}
	return &this
}

// NewClientsUsageReportWithDefaults instantiates a new ClientsUsageReport object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewClientsUsageReportWithDefaults() *ClientsUsageReport {
	this := ClientsUsageReport{}
	return &this
}

// GetAccountId returns the AccountId field value if set, zero value otherwise.
func (o *ClientsUsageReport) GetAccountId() string {
	if o == nil || o.AccountId == nil {
		var ret string
		return ret
	}
	return *o.AccountId
}

// GetAccountIdOk returns a tuple with the AccountId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ClientsUsageReport) GetAccountIdOk() (*string, bool) {
	if o == nil || o.AccountId == nil {
		return nil, false
	}
	return o.AccountId, true
}

// HasAccountId returns a boolean if a field has been set.
func (o *ClientsUsageReport) HasAccountId() bool {
	if o != nil && o.AccountId != nil {
		return true
	}

	return false
}

// SetAccountId gets a reference to the given string and assigns it to the AccountId field.
func (o *ClientsUsageReport) SetAccountId(v string) {
	o.AccountId = &v
}

// GetClients returns the Clients field value if set, zero value otherwise.
func (o *ClientsUsageReport) GetClients() []ClientUsageInfo {
	if o == nil || o.Clients == nil {
		var ret []ClientUsageInfo
		return ret
	}
	return *o.Clients
}

// GetClientsOk returns a tuple with the Clients field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ClientsUsageReport) GetClientsOk() (*[]ClientUsageInfo, bool) {
	if o == nil || o.Clients == nil {
		return nil, false
	}
	return o.Clients, true
}

// HasClients returns a boolean if a field has been set.
func (o *ClientsUsageReport) HasClients() bool {
	if o != nil && o.Clients != nil {
		return true
	}

	return false
}

// SetClients gets a reference to the given []ClientUsageInfo and assigns it to the Clients field.
func (o *ClientsUsageReport) SetClients(v []ClientUsageInfo) {
	o.Clients = &v
}

// GetProduct returns the Product field value if set, zero value otherwise.
func (o *ClientsUsageReport) GetProduct() string {
	if o == nil || o.Product == nil {
		var ret string
		return ret
	}
	return *o.Product
}

// GetProductOk returns a tuple with the Product field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ClientsUsageReport) GetProductOk() (*string, bool) {
	if o == nil || o.Product == nil {
		return nil, false
	}
	return o.Product, true
}

// HasProduct returns a boolean if a field has been set.
func (o *ClientsUsageReport) HasProduct() bool {
	if o != nil && o.Product != nil {
		return true
	}

	return false
}

// SetProduct gets a reference to the given string and assigns it to the Product field.
func (o *ClientsUsageReport) SetProduct(v string) {
	o.Product = &v
}

// GetTime returns the Time field value if set, zero value otherwise.
func (o *ClientsUsageReport) GetTime() time.Time {
	if o == nil || o.Time == nil {
		var ret time.Time
		return ret
	}
	return *o.Time
}

// GetTimeOk returns a tuple with the Time field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ClientsUsageReport) GetTimeOk() (*time.Time, bool) {
	if o == nil || o.Time == nil {
		return nil, false
	}
	return o.Time, true
}

// HasTime returns a boolean if a field has been set.
func (o *ClientsUsageReport) HasTime() bool {
	if o != nil && o.Time != nil {
		return true
	}

	return false
}

// SetTime gets a reference to the given time.Time and assigns it to the Time field.
func (o *ClientsUsageReport) SetTime(v time.Time) {
	o.Time = &v
}

// GetTotalClients returns the TotalClients field value if set, zero value otherwise.
func (o *ClientsUsageReport) GetTotalClients() int64 {
	if o == nil || o.TotalClients == nil {
		var ret int64
		return ret
	}
	return *o.TotalClients
}

// GetTotalClientsOk returns a tuple with the TotalClients field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ClientsUsageReport) GetTotalClientsOk() (*int64, bool) {
	if o == nil || o.TotalClients == nil {
		return nil, false
	}
	return o.TotalClients, true
}

// HasTotalClients returns a boolean if a field has been set.
func (o *ClientsUsageReport) HasTotalClients() bool {
	if o != nil && o.TotalClients != nil {
		return true
	}

	return false
}

// SetTotalClients gets a reference to the given int64 and assigns it to the TotalClients field.
func (o *ClientsUsageReport) SetTotalClients(v int64) {
	o.TotalClients = &v
}

func (o ClientsUsageReport) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AccountId != nil {
		toSerialize["account_id"] = o.AccountId
	}
	if o.Clients != nil {
		toSerialize["clients"] = o.Clients
	}
	if o.Product != nil {
		toSerialize["product"] = o.Product
	}
	if o.Time != nil {
		toSerialize["time"] = o.Time
	}
	if o.TotalClients != nil {
		toSerialize["total_clients"] = o.TotalClients
	}
	return json.Marshal(toSerialize)
}

type NullableClientsUsageReport struct {
	value *ClientsUsageReport
	isSet bool
}

func (v NullableClientsUsageReport) Get() *ClientsUsageReport {
	return v.value
}

func (v *NullableClientsUsageReport) Set(val *ClientsUsageReport) {
	v.value = val
	v.isSet = true
}

func (v NullableClientsUsageReport) IsSet() bool {
	return v.isSet
}

func (v *NullableClientsUsageReport) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableClientsUsageReport(val *ClientsUsageReport) *NullableClientsUsageReport {
	return &NullableClientsUsageReport{value: val, isSet: true}
}

func (v NullableClientsUsageReport) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableClientsUsageReport) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


