/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
	"time"
)

// ClassicKeyStatusInfo struct for ClassicKeyStatusInfo
type ClassicKeyStatusInfo struct {
	ErrorDate *time.Time `json:"error_date,omitempty"`
	LastError *string `json:"last_error,omitempty"`
	// ClassicKeyTargetStatus defines status of classic key target
	LastStatus *string `json:"last_status,omitempty"`
	Version *int64 `json:"version,omitempty"`
}

// NewClassicKeyStatusInfo instantiates a new ClassicKeyStatusInfo object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewClassicKeyStatusInfo() *ClassicKeyStatusInfo {
	this := ClassicKeyStatusInfo{}
	return &this
}

// NewClassicKeyStatusInfoWithDefaults instantiates a new ClassicKeyStatusInfo object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewClassicKeyStatusInfoWithDefaults() *ClassicKeyStatusInfo {
	this := ClassicKeyStatusInfo{}
	return &this
}

// GetErrorDate returns the ErrorDate field value if set, zero value otherwise.
func (o *ClassicKeyStatusInfo) GetErrorDate() time.Time {
	if o == nil || o.ErrorDate == nil {
		var ret time.Time
		return ret
	}
	return *o.ErrorDate
}

// GetErrorDateOk returns a tuple with the ErrorDate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ClassicKeyStatusInfo) GetErrorDateOk() (*time.Time, bool) {
	if o == nil || o.ErrorDate == nil {
		return nil, false
	}
	return o.ErrorDate, true
}

// HasErrorDate returns a boolean if a field has been set.
func (o *ClassicKeyStatusInfo) HasErrorDate() bool {
	if o != nil && o.ErrorDate != nil {
		return true
	}

	return false
}

// SetErrorDate gets a reference to the given time.Time and assigns it to the ErrorDate field.
func (o *ClassicKeyStatusInfo) SetErrorDate(v time.Time) {
	o.ErrorDate = &v
}

// GetLastError returns the LastError field value if set, zero value otherwise.
func (o *ClassicKeyStatusInfo) GetLastError() string {
	if o == nil || o.LastError == nil {
		var ret string
		return ret
	}
	return *o.LastError
}

// GetLastErrorOk returns a tuple with the LastError field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ClassicKeyStatusInfo) GetLastErrorOk() (*string, bool) {
	if o == nil || o.LastError == nil {
		return nil, false
	}
	return o.LastError, true
}

// HasLastError returns a boolean if a field has been set.
func (o *ClassicKeyStatusInfo) HasLastError() bool {
	if o != nil && o.LastError != nil {
		return true
	}

	return false
}

// SetLastError gets a reference to the given string and assigns it to the LastError field.
func (o *ClassicKeyStatusInfo) SetLastError(v string) {
	o.LastError = &v
}

// GetLastStatus returns the LastStatus field value if set, zero value otherwise.
func (o *ClassicKeyStatusInfo) GetLastStatus() string {
	if o == nil || o.LastStatus == nil {
		var ret string
		return ret
	}
	return *o.LastStatus
}

// GetLastStatusOk returns a tuple with the LastStatus field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ClassicKeyStatusInfo) GetLastStatusOk() (*string, bool) {
	if o == nil || o.LastStatus == nil {
		return nil, false
	}
	return o.LastStatus, true
}

// HasLastStatus returns a boolean if a field has been set.
func (o *ClassicKeyStatusInfo) HasLastStatus() bool {
	if o != nil && o.LastStatus != nil {
		return true
	}

	return false
}

// SetLastStatus gets a reference to the given string and assigns it to the LastStatus field.
func (o *ClassicKeyStatusInfo) SetLastStatus(v string) {
	o.LastStatus = &v
}

// GetVersion returns the Version field value if set, zero value otherwise.
func (o *ClassicKeyStatusInfo) GetVersion() int64 {
	if o == nil || o.Version == nil {
		var ret int64
		return ret
	}
	return *o.Version
}

// GetVersionOk returns a tuple with the Version field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ClassicKeyStatusInfo) GetVersionOk() (*int64, bool) {
	if o == nil || o.Version == nil {
		return nil, false
	}
	return o.Version, true
}

// HasVersion returns a boolean if a field has been set.
func (o *ClassicKeyStatusInfo) HasVersion() bool {
	if o != nil && o.Version != nil {
		return true
	}

	return false
}

// SetVersion gets a reference to the given int64 and assigns it to the Version field.
func (o *ClassicKeyStatusInfo) SetVersion(v int64) {
	o.Version = &v
}

func (o ClassicKeyStatusInfo) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.ErrorDate != nil {
		toSerialize["error_date"] = o.ErrorDate
	}
	if o.LastError != nil {
		toSerialize["last_error"] = o.LastError
	}
	if o.LastStatus != nil {
		toSerialize["last_status"] = o.LastStatus
	}
	if o.Version != nil {
		toSerialize["version"] = o.Version
	}
	return json.Marshal(toSerialize)
}

type NullableClassicKeyStatusInfo struct {
	value *ClassicKeyStatusInfo
	isSet bool
}

func (v NullableClassicKeyStatusInfo) Get() *ClassicKeyStatusInfo {
	return v.value
}

func (v *NullableClassicKeyStatusInfo) Set(val *ClassicKeyStatusInfo) {
	v.value = val
	v.isSet = true
}

func (v NullableClassicKeyStatusInfo) IsSet() bool {
	return v.isSet
}

func (v *NullableClassicKeyStatusInfo) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableClassicKeyStatusInfo(val *ClassicKeyStatusInfo) *NullableClassicKeyStatusInfo {
	return &NullableClassicKeyStatusInfo{value: val, isSet: true}
}

func (v NullableClassicKeyStatusInfo) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableClassicKeyStatusInfo) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


