/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// AuthMethodCreateEmail authMethodCreateEmail is a command that creates a new auth method that will be able to authenticate using email.
type AuthMethodCreateEmail struct {
	// Access expiration date in Unix timestamp (select 0 for access without expiry date)
	AccessExpires *int64 `json:"access-expires,omitempty"`
	// Subclaims to include in audit logs, e.g \"--audit-logs-claims email --audit-logs-claims username\"
	AuditLogsClaims *[]string `json:"audit-logs-claims,omitempty"`
	// A CIDR whitelist with the IPs that the access is restricted to
	BoundIps *[]string `json:"bound-ips,omitempty"`
	// Protection from accidental deletion of this object [true/false]
	DeleteProtection *string `json:"delete_protection,omitempty"`
	// Auth Method description
	Description *string `json:"description,omitempty"`
	// An email address to be invited to have access
	Email string `json:"email"`
	// if true: enforce role-association must include sub claims
	ForceSubClaims *bool `json:"force-sub-claims,omitempty"`
	// A CIDR whitelist with the GW IPs that the access is restricted to
	GwBoundIps *[]string `json:"gw-bound-ips,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Jwt TTL
	JwtTtl *int64 `json:"jwt-ttl,omitempty"`
	// Auth Method name
	Name string `json:"name"`
	// Choose the relevant product type for the auth method [sm, sra, pm, dp, ca]
	ProductType *[]string `json:"product-type,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewAuthMethodCreateEmail instantiates a new AuthMethodCreateEmail object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewAuthMethodCreateEmail(email string, name string, ) *AuthMethodCreateEmail {
	this := AuthMethodCreateEmail{}
	var accessExpires int64 = 0
	this.AccessExpires = &accessExpires
	this.Email = email
	var json bool = false
	this.Json = &json
	var jwtTtl int64 = 0
	this.JwtTtl = &jwtTtl
	this.Name = name
	return &this
}

// NewAuthMethodCreateEmailWithDefaults instantiates a new AuthMethodCreateEmail object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewAuthMethodCreateEmailWithDefaults() *AuthMethodCreateEmail {
	this := AuthMethodCreateEmail{}
	var accessExpires int64 = 0
	this.AccessExpires = &accessExpires
	var json bool = false
	this.Json = &json
	var jwtTtl int64 = 0
	this.JwtTtl = &jwtTtl
	return &this
}

// GetAccessExpires returns the AccessExpires field value if set, zero value otherwise.
func (o *AuthMethodCreateEmail) GetAccessExpires() int64 {
	if o == nil || o.AccessExpires == nil {
		var ret int64
		return ret
	}
	return *o.AccessExpires
}

// GetAccessExpiresOk returns a tuple with the AccessExpires field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateEmail) GetAccessExpiresOk() (*int64, bool) {
	if o == nil || o.AccessExpires == nil {
		return nil, false
	}
	return o.AccessExpires, true
}

// HasAccessExpires returns a boolean if a field has been set.
func (o *AuthMethodCreateEmail) HasAccessExpires() bool {
	if o != nil && o.AccessExpires != nil {
		return true
	}

	return false
}

// SetAccessExpires gets a reference to the given int64 and assigns it to the AccessExpires field.
func (o *AuthMethodCreateEmail) SetAccessExpires(v int64) {
	o.AccessExpires = &v
}

// GetAuditLogsClaims returns the AuditLogsClaims field value if set, zero value otherwise.
func (o *AuthMethodCreateEmail) GetAuditLogsClaims() []string {
	if o == nil || o.AuditLogsClaims == nil {
		var ret []string
		return ret
	}
	return *o.AuditLogsClaims
}

// GetAuditLogsClaimsOk returns a tuple with the AuditLogsClaims field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateEmail) GetAuditLogsClaimsOk() (*[]string, bool) {
	if o == nil || o.AuditLogsClaims == nil {
		return nil, false
	}
	return o.AuditLogsClaims, true
}

// HasAuditLogsClaims returns a boolean if a field has been set.
func (o *AuthMethodCreateEmail) HasAuditLogsClaims() bool {
	if o != nil && o.AuditLogsClaims != nil {
		return true
	}

	return false
}

// SetAuditLogsClaims gets a reference to the given []string and assigns it to the AuditLogsClaims field.
func (o *AuthMethodCreateEmail) SetAuditLogsClaims(v []string) {
	o.AuditLogsClaims = &v
}

// GetBoundIps returns the BoundIps field value if set, zero value otherwise.
func (o *AuthMethodCreateEmail) GetBoundIps() []string {
	if o == nil || o.BoundIps == nil {
		var ret []string
		return ret
	}
	return *o.BoundIps
}

// GetBoundIpsOk returns a tuple with the BoundIps field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateEmail) GetBoundIpsOk() (*[]string, bool) {
	if o == nil || o.BoundIps == nil {
		return nil, false
	}
	return o.BoundIps, true
}

// HasBoundIps returns a boolean if a field has been set.
func (o *AuthMethodCreateEmail) HasBoundIps() bool {
	if o != nil && o.BoundIps != nil {
		return true
	}

	return false
}

// SetBoundIps gets a reference to the given []string and assigns it to the BoundIps field.
func (o *AuthMethodCreateEmail) SetBoundIps(v []string) {
	o.BoundIps = &v
}

// GetDeleteProtection returns the DeleteProtection field value if set, zero value otherwise.
func (o *AuthMethodCreateEmail) GetDeleteProtection() string {
	if o == nil || o.DeleteProtection == nil {
		var ret string
		return ret
	}
	return *o.DeleteProtection
}

// GetDeleteProtectionOk returns a tuple with the DeleteProtection field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateEmail) GetDeleteProtectionOk() (*string, bool) {
	if o == nil || o.DeleteProtection == nil {
		return nil, false
	}
	return o.DeleteProtection, true
}

// HasDeleteProtection returns a boolean if a field has been set.
func (o *AuthMethodCreateEmail) HasDeleteProtection() bool {
	if o != nil && o.DeleteProtection != nil {
		return true
	}

	return false
}

// SetDeleteProtection gets a reference to the given string and assigns it to the DeleteProtection field.
func (o *AuthMethodCreateEmail) SetDeleteProtection(v string) {
	o.DeleteProtection = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *AuthMethodCreateEmail) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateEmail) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *AuthMethodCreateEmail) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *AuthMethodCreateEmail) SetDescription(v string) {
	o.Description = &v
}

// GetEmail returns the Email field value
func (o *AuthMethodCreateEmail) GetEmail() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Email
}

// GetEmailOk returns a tuple with the Email field value
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateEmail) GetEmailOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Email, true
}

// SetEmail sets field value
func (o *AuthMethodCreateEmail) SetEmail(v string) {
	o.Email = v
}

// GetForceSubClaims returns the ForceSubClaims field value if set, zero value otherwise.
func (o *AuthMethodCreateEmail) GetForceSubClaims() bool {
	if o == nil || o.ForceSubClaims == nil {
		var ret bool
		return ret
	}
	return *o.ForceSubClaims
}

// GetForceSubClaimsOk returns a tuple with the ForceSubClaims field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateEmail) GetForceSubClaimsOk() (*bool, bool) {
	if o == nil || o.ForceSubClaims == nil {
		return nil, false
	}
	return o.ForceSubClaims, true
}

// HasForceSubClaims returns a boolean if a field has been set.
func (o *AuthMethodCreateEmail) HasForceSubClaims() bool {
	if o != nil && o.ForceSubClaims != nil {
		return true
	}

	return false
}

// SetForceSubClaims gets a reference to the given bool and assigns it to the ForceSubClaims field.
func (o *AuthMethodCreateEmail) SetForceSubClaims(v bool) {
	o.ForceSubClaims = &v
}

// GetGwBoundIps returns the GwBoundIps field value if set, zero value otherwise.
func (o *AuthMethodCreateEmail) GetGwBoundIps() []string {
	if o == nil || o.GwBoundIps == nil {
		var ret []string
		return ret
	}
	return *o.GwBoundIps
}

// GetGwBoundIpsOk returns a tuple with the GwBoundIps field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateEmail) GetGwBoundIpsOk() (*[]string, bool) {
	if o == nil || o.GwBoundIps == nil {
		return nil, false
	}
	return o.GwBoundIps, true
}

// HasGwBoundIps returns a boolean if a field has been set.
func (o *AuthMethodCreateEmail) HasGwBoundIps() bool {
	if o != nil && o.GwBoundIps != nil {
		return true
	}

	return false
}

// SetGwBoundIps gets a reference to the given []string and assigns it to the GwBoundIps field.
func (o *AuthMethodCreateEmail) SetGwBoundIps(v []string) {
	o.GwBoundIps = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *AuthMethodCreateEmail) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateEmail) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *AuthMethodCreateEmail) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *AuthMethodCreateEmail) SetJson(v bool) {
	o.Json = &v
}

// GetJwtTtl returns the JwtTtl field value if set, zero value otherwise.
func (o *AuthMethodCreateEmail) GetJwtTtl() int64 {
	if o == nil || o.JwtTtl == nil {
		var ret int64
		return ret
	}
	return *o.JwtTtl
}

// GetJwtTtlOk returns a tuple with the JwtTtl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateEmail) GetJwtTtlOk() (*int64, bool) {
	if o == nil || o.JwtTtl == nil {
		return nil, false
	}
	return o.JwtTtl, true
}

// HasJwtTtl returns a boolean if a field has been set.
func (o *AuthMethodCreateEmail) HasJwtTtl() bool {
	if o != nil && o.JwtTtl != nil {
		return true
	}

	return false
}

// SetJwtTtl gets a reference to the given int64 and assigns it to the JwtTtl field.
func (o *AuthMethodCreateEmail) SetJwtTtl(v int64) {
	o.JwtTtl = &v
}

// GetName returns the Name field value
func (o *AuthMethodCreateEmail) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateEmail) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *AuthMethodCreateEmail) SetName(v string) {
	o.Name = v
}

// GetProductType returns the ProductType field value if set, zero value otherwise.
func (o *AuthMethodCreateEmail) GetProductType() []string {
	if o == nil || o.ProductType == nil {
		var ret []string
		return ret
	}
	return *o.ProductType
}

// GetProductTypeOk returns a tuple with the ProductType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateEmail) GetProductTypeOk() (*[]string, bool) {
	if o == nil || o.ProductType == nil {
		return nil, false
	}
	return o.ProductType, true
}

// HasProductType returns a boolean if a field has been set.
func (o *AuthMethodCreateEmail) HasProductType() bool {
	if o != nil && o.ProductType != nil {
		return true
	}

	return false
}

// SetProductType gets a reference to the given []string and assigns it to the ProductType field.
func (o *AuthMethodCreateEmail) SetProductType(v []string) {
	o.ProductType = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *AuthMethodCreateEmail) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateEmail) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *AuthMethodCreateEmail) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *AuthMethodCreateEmail) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *AuthMethodCreateEmail) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateEmail) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *AuthMethodCreateEmail) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *AuthMethodCreateEmail) SetUidToken(v string) {
	o.UidToken = &v
}

func (o AuthMethodCreateEmail) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AccessExpires != nil {
		toSerialize["access-expires"] = o.AccessExpires
	}
	if o.AuditLogsClaims != nil {
		toSerialize["audit-logs-claims"] = o.AuditLogsClaims
	}
	if o.BoundIps != nil {
		toSerialize["bound-ips"] = o.BoundIps
	}
	if o.DeleteProtection != nil {
		toSerialize["delete_protection"] = o.DeleteProtection
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if true {
		toSerialize["email"] = o.Email
	}
	if o.ForceSubClaims != nil {
		toSerialize["force-sub-claims"] = o.ForceSubClaims
	}
	if o.GwBoundIps != nil {
		toSerialize["gw-bound-ips"] = o.GwBoundIps
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.JwtTtl != nil {
		toSerialize["jwt-ttl"] = o.JwtTtl
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.ProductType != nil {
		toSerialize["product-type"] = o.ProductType
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableAuthMethodCreateEmail struct {
	value *AuthMethodCreateEmail
	isSet bool
}

func (v NullableAuthMethodCreateEmail) Get() *AuthMethodCreateEmail {
	return v.value
}

func (v *NullableAuthMethodCreateEmail) Set(val *AuthMethodCreateEmail) {
	v.value = val
	v.isSet = true
}

func (v NullableAuthMethodCreateEmail) IsSet() bool {
	return v.isSet
}

func (v *NullableAuthMethodCreateEmail) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableAuthMethodCreateEmail(val *AuthMethodCreateEmail) *NullableAuthMethodCreateEmail {
	return &NullableAuthMethodCreateEmail{value: val, isSet: true}
}

func (v NullableAuthMethodCreateEmail) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableAuthMethodCreateEmail) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


